/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ruby.epp.ide.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.lang.puppet.ruby.epp.EppFileType;
import com.intellij.lang.puppet.ruby.epp.elementTypes.EppElementTypes;
import com.intellij.lang.puppet.ruby.epp.ide.editor.EppSmartKeysUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public final class EppBackSpaceHandler
extends BackspaceHandlerDelegate {
    private boolean isCharDeleted;

    public void beforeCharDeleted(char c, PsiFile file, @NotNull Editor editor) {
        if (editor == null) {
            EppBackSpaceHandler.$$$reportNull$$$0(0);
        }
        this.isCharDeleted = false;
        if (!FileTypeRegistry.getInstance().isFileOfType(file.getVirtualFile(), (FileType)EppFileType.getInstance())) {
            return;
        }
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int currentOffset = caretModel.getOffset();
        if (c == '|') {
            if (EppSmartKeysUtil.getTokenInfo((Editor)editor, (int)(currentOffset - 1)).tokenType == EppElementTypes.EPP_PARAMETER_OPENER) {
                EppSmartKeysUtil.TokenInfo nextEppTokenInfo = EppSmartKeysUtil.getNextEppTokenInfo(editor, currentOffset);
                if (nextEppTokenInfo.tokenType == EppElementTypes.EPP_PARAMETER_CLOSER) {
                    document.deleteString(nextEppTokenInfo.startOffset, nextEppTokenInfo.startOffset + 2);
                }
                this.isCharDeleted = true;
            } else if (EppSmartKeysUtil.getTokenInfo((Editor)editor, (int)currentOffset).tokenType == EppElementTypes.EPP_PARAMETER_CLOSER) {
                EppSmartKeysUtil.TokenInfo prevEppTokenInfo = EppSmartKeysUtil.getPrevEppTokenInfo(editor, currentOffset - 2);
                if (prevEppTokenInfo.tokenType == EppElementTypes.EPP_PARAMETER_OPENER) {
                    document.deleteString(prevEppTokenInfo.endOffset - 1, prevEppTokenInfo.endOffset);
                }
                this.isCharDeleted = true;
            }
        }
        if (c == '%') {
            EppSmartKeysUtil.TokenInfo currentTokenInfo = EppSmartKeysUtil.getTokenInfo(editor, currentOffset - 1);
            if (currentTokenInfo.tokenType == EppElementTypes.EPP_EXPRESSION_OPENER) {
                EppSmartKeysUtil.TokenInfo nextEppTokenInfo = EppSmartKeysUtil.getNextEppTokenInfo(editor, currentOffset);
                if (nextEppTokenInfo.tokenType == EppElementTypes.EPP_EXPRESSION_CLOSER) {
                    nextEppTokenInfo.deleteFrom(document);
                }
                document.deleteString(currentOffset - 1, currentOffset);
                caretModel.moveToOffset(currentOffset - 1);
                this.isCharDeleted = true;
            }
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            EppBackSpaceHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            EppBackSpaceHandler.$$$reportNull$$$0(2);
        }
        return this.isCharDeleted;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/ruby/epp/ide/editor/EppBackSpaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

