/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ruby.epp;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.puppet.ruby.epp.EppLanguage;
import com.intellij.lang.puppet.ruby.epp.elementTypes.EppElementTypes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EppFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private final Set<Language> myRelevantLanguages;
    @NotNull
    private final Language myTemplateDataLanguage;

    public EppFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            EppFileViewProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            EppFileViewProvider.$$$reportNull$$$0(1);
        }
        super(manager, virtualFile, eventSystemEnabled);
        this.myRelevantLanguages = new HashSet<Language>();
        this.myTemplateDataLanguage = EppFileViewProvider.computeTemplateLanguage(virtualFile);
        this.myRelevantLanguages.add(this.getBaseLanguage());
        this.myRelevantLanguages.add(this.getTemplateDataLanguage());
    }

    @NotNull
    public static Language computeTemplateLanguage(@NotNull VirtualFile virtualFile) {
        FileType fileType;
        if (virtualFile == null) {
            EppFileViewProvider.$$$reportNull$$$0(2);
        }
        if (!((fileType = EppFileViewProvider.getTemplateFileType(virtualFile)) instanceof LanguageFileType)) {
            PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
            if (plainTextLanguage == null) {
                EppFileViewProvider.$$$reportNull$$$0(3);
            }
            return plainTextLanguage;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        Object object = language instanceof TemplateLanguage ? HTMLLanguage.INSTANCE : language;
        if (object == null) {
            EppFileViewProvider.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Nullable
    private static FileType getTemplateFileType(@Nullable VirtualFile virtualFile) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (virtualFile == null) {
            return null;
        }
        List nameChunks = StringUtil.split((String)virtualFile.getName(), (String)".");
        if (nameChunks.size() < 3) {
            return FileTypes.PLAIN_TEXT;
        }
        FileType fileType = fileTypeManager.getFileTypeByExtension((String)nameChunks.get(nameChunks.size() - 2));
        return fileType == UnknownFileType.INSTANCE ? FileTypes.PLAIN_TEXT : fileType;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        boolean isTemplateLanguage;
        if (lang == null) {
            EppFileViewProvider.$$$reportNull$$$0(5);
        }
        boolean bl = isTemplateLanguage = lang == this.getTemplateDataLanguage();
        if (lang != this.getBaseLanguage() && !isTemplateLanguage) {
            return null;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition == null) {
            return null;
        }
        PsiFile psiFile = parserDefinition.createFile((FileViewProvider)this);
        if (isTemplateLanguage && psiFile instanceof PsiFileImpl) {
            ((PsiFileImpl)psiFile).setContentElementType(EppElementTypes.EPP_TEMPLATE_DATA);
        }
        return psiFile;
    }

    @Nullable
    public IElementType getContentElementType(@NotNull Language language) {
        if (language == null) {
            EppFileViewProvider.$$$reportNull$$$0(6);
        }
        return language == this.getTemplateDataLanguage() ? EppElementTypes.EPP_TEMPLATE_DATA : null;
    }

    @NotNull
    public Language getBaseLanguage() {
        EppLanguage eppLanguage = EppLanguage.getInstance();
        if (eppLanguage == null) {
            EppFileViewProvider.$$$reportNull$$$0(7);
        }
        return eppLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = this.myRelevantLanguages;
        if (set == null) {
            EppFileViewProvider.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            EppFileViewProvider.$$$reportNull$$$0(9);
        }
        return language;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            EppFileViewProvider.$$$reportNull$$$0(10);
        }
        return new EppFileViewProvider((PsiManager)this.getManager(), fileCopy, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ruby/epp/EppFileViewProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ruby/epp/EppFileViewProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTemplateLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateLanguage";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getContentElementType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

