/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ruby.adapters;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.lang.puppet.adapters.PuppetDependencyManagerAdapter;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;

public final class PuppetFixturesDependenciesAdapter
extends PuppetDependencyManagerAdapter {
    private static final String CLEAN_TASK = "spec_clean";
    private static final String PREPARE_TASK = "spec_prep";

    public boolean isApplicable(@NotNull PuppetEntity entity) {
        if (entity == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(0);
        }
        return entity instanceof PuppetModule && ((PuppetModule)entity).hasFixturesFile() && entity.getIdeaModule() != null;
    }

    protected void installDependencies(@NotNull PuppetEntity puppetEntity, @NotNull ProgressIndicator indicator) {
        if (puppetEntity == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!puppetEntity.isValid()) {
                return;
            }
            PuppetFixturesDependenciesAdapter.runCleanTask(puppetEntity, (Consumer<RunnerAndConfigurationSettings>)((Consumer)settings -> {
                RunConfiguration configuration = settings.getConfiguration();
                assert (configuration instanceof RakeRunConfiguration);
                ((RakeRunConfiguration)configuration).setWorkingDirectory(puppetEntity.getRoot().getCanonicalPath());
            }));
        });
    }

    private static void runCleanTask(final @NotNull PuppetEntity<?> puppetEntity, final @NotNull Consumer<RunnerAndConfigurationSettings> settingsMutator) {
        if (puppetEntity == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(3);
        }
        if (settingsMutator == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(4);
        }
        Module module = puppetEntity.getIdeaModule();
        assert (module != null);
        RakeUtil.runRakeTask((String)CLEAN_TASK, (Module)module, null, settingsMutator, cleanRunContentDescriptor -> {
            ProcessHandler cleanProcessHandler = cleanRunContentDescriptor.getProcessHandler();
            if (cleanProcessHandler != null) {
                cleanProcessHandler.addProcessListener(new ProcessListener(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (event.getExitCode() == 0) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (puppetEntity.isValid()) {
                                    PuppetFixturesDependenciesAdapter.runPrepareTask(puppetEntity, (Consumer<RunnerAndConfigurationSettings>)settingsMutator);
                                }
                            });
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/puppet/ruby/adapters/PuppetFixturesDependenciesAdapter$1", "processTerminated"));
                    }
                });
            }
        }, () -> PuppetFixturesDependenciesAdapter.getRakeTaskName(module, CLEAN_TASK, puppetEntity));
    }

    private static void runPrepareTask(final @NotNull PuppetEntity<?> puppetEntity, @NotNull Consumer<RunnerAndConfigurationSettings> settingsMutator) {
        if (puppetEntity == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(5);
        }
        if (settingsMutator == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(6);
        }
        Module module = puppetEntity.getIdeaModule();
        assert (module != null);
        RakeUtil.runRakeTask((String)PREPARE_TASK, (Module)module, null, settingsMutator, prepRunContentDescriptor -> {
            ProcessHandler prepProcessHandler = prepRunContentDescriptor.getProcessHandler();
            if (prepProcessHandler != null) {
                prepProcessHandler.addProcessListener(new ProcessListener(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (event.getExitCode() != 0) {
                            return;
                        }
                        ApplicationManager.getApplication().runReadAction(() -> {
                            if (puppetEntity.isValid()) {
                                PuppetFixturesDependenciesAdapter.refreshDeepestSubdirectory(puppetEntity.getRoot(), "spec", "fixtures", "modules");
                            }
                        });
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/puppet/ruby/adapters/PuppetFixturesDependenciesAdapter$2", "processTerminated"));
                    }
                });
            }
        }, () -> PuppetFixturesDependenciesAdapter.getRakeTaskName(module, PREPARE_TASK, puppetEntity));
    }

    @NotNull
    private static String getRakeTaskName(@NotNull Module module, @NotNull String taskName, @NotNull PuppetEntity puppetEntity) {
        if (module == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(7);
        }
        if (taskName == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(8);
        }
        if (puppetEntity == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(9);
        }
        String string = module.getName() + ": " + taskName + " for " + puppetEntity.getName();
        if (string == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static void refreshDeepestSubdirectory(@NotNull VirtualFile root, String ... pathChunks) {
        String pathChunk;
        VirtualFile newRoot;
        if (root == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(11);
        }
        if (pathChunks == null) {
            PuppetFixturesDependenciesAdapter.$$$reportNull$$$0(12);
        }
        String[] stringArray = pathChunks;
        int n = stringArray.length;
        for (int i = 0; i < n && (newRoot = root.findChild(pathChunk = stringArray[i])) != null; ++i) {
            root = newRoot;
        }
        root.refresh(true, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "puppetEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsMutator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ruby/adapters/PuppetFixturesDependenciesAdapter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathChunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ruby/adapters/PuppetFixturesDependenciesAdapter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRakeTaskName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installDependencies";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runCleanTask";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runPrepareTask";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRakeTaskName";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "refreshDeepestSubdirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

