/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ruby;

import com.intellij.ide.actions.CreateInDirectoryActionBase;
import com.intellij.ide.actions.NewFileActionWithCategory;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.lang.puppet.rubyShared.CreatePuppetModuleHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

final class CreatePuppetModuleAction
extends CreateInDirectoryActionBase
implements NewFileActionWithCategory {
    private static final Pattern PUPPET_FULL_MODULE_NAME_PATTERN = Pattern.compile(String.valueOf(CreatePuppetModuleHelper.PUPPET_USER_NAME_PATTERN) + "-" + String.valueOf(CreatePuppetModuleHelper.PUPPET_MODULE_NAME_PATTERN));

    CreatePuppetModuleAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String newName;
        if (e == null) {
            CreatePuppetModuleAction.$$$reportNull$$$0(0);
        }
        if (!StringUtil.isEmpty((String)(newName = Messages.showInputDialog((Project)e.getProject(), (String)PuppetBundle.message((String)"puppet.create.module.text", (Object[])new Object[0]), (String)PuppetBundle.message((String)"puppet.create.module.title", (Object[])new Object[0]), (Icon)this.getTemplatePresentation().getIcon(), null, (InputValidator)new InputValidator(this){

            public boolean checkInput(String inputString) {
                return PUPPET_FULL_MODULE_NAME_PATTERN.matcher(inputString).matches();
            }

            public boolean canClose(String inputString) {
                return true;
            }
        })))) {
            CreatePuppetModuleAction.createModule(newName, e);
        }
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        VirtualFile rootDirectory = CreatePuppetModuleAction.getValidRootDirectory(dataContext);
        if (rootDirectory == null) {
            return false;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        assert (project != null) : "Should be checked by super-method";
        Sdk fileSdk = RModuleUtil.getInstance().findRubySdkForVirtualFile(project, rootDirectory);
        if (fileSdk == null) {
            return false;
        }
        PuppetEntity puppetEntity = PuppetProjectManager.getInstance((Project)project).findModuleOrEnvironmentForFile(rootDirectory);
        if (puppetEntity == null) {
            return true;
        }
        for (VirtualFile dependencyRoot : puppetEntity.getAllDependenciesRoots()) {
            if (!rootDirectory.equals(dependencyRoot)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getCategory() {
        return "Deployment";
    }

    @RequiresReadLock
    private static void createModule(@NotNull String name, AnActionEvent e) {
        if (name == null) {
            CreatePuppetModuleAction.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.softAssertReadAccess();
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        VirtualFile rootDirectory = CreatePuppetModuleAction.getValidRootDirectory(e.getDataContext());
        if (rootDirectory == null || !rootDirectory.isValid()) {
            return;
        }
        Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)rootDirectory, (Project)project);
        if (fileModule == null || fileModule.isDisposed()) {
            return;
        }
        CreatePuppetModuleHelper.createModule((Module)fileModule, (VirtualFile)rootDirectory, (String)name);
    }

    @Nullable
    private static VirtualFile getValidRootDirectory(@NotNull DataContext dataContext) {
        VirtualFile rootDirectory;
        if (dataContext == null) {
            CreatePuppetModuleAction.$$$reportNull$$$0(2);
        }
        return (rootDirectory = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) == null || !rootDirectory.isDirectory() || !rootDirectory.isValid() ? null : rootDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/ruby/CreatePuppetModuleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getValidRootDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

