/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.indexes;

import com.intellij.lang.Language;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;

public final class RubyIndexPatternBuilder
implements IndexPatternBuilder {
    public static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.TLINE_COMMENT, RubyTokenTypes.tBLOCK_COMMENT});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (file == null) {
            RubyIndexPatternBuilder.$$$reportNull$$$0(0);
        }
        if (file instanceof RFile) {
            try {
                LayeredLexer.ourDisableLayersFlag.set(Boolean.TRUE);
                SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)file.getLanguage(), (Project)file.getProject(), (VirtualFile)file.getVirtualFile());
                Lexer lexer = syntaxHighlighter.getHighlightingLexer();
                return lexer;
            }
            finally {
                LayeredLexer.ourDisableLayersFlag.remove();
            }
        }
        return null;
    }

    @Nullable
    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (file == null) {
            RubyIndexPatternBuilder.$$$reportNull$$$0(1);
        }
        if (file instanceof RFile) {
            return COMMENTS;
        }
        return null;
    }

    public int getCommentStartDelta(IElementType tokenType) {
        if (tokenType == RubyTokenTypes.TLINE_COMMENT) {
            return 1;
        }
        if (tokenType == RubyTokenTypes.tBLOCK_COMMENT) {
            return 6;
        }
        return 0;
    }

    public int getCommentEndDelta(IElementType tokenType) {
        if (tokenType == RubyTokenTypes.tBLOCK_COMMENT) {
            return 4;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/indexes/RubyIndexPatternBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentTokenSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

