/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.wizard.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsConfigurableBase;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.ui.RubySdkRenderer;
import org.jetbrains.plugins.ruby.utils.RubyUIUtil;

public final class RubySdkComboBox
extends ComboBox<Sdk> {
    private static final String SELECTED_RUBY_SDK_PROPERTY = "sdk.selected.RUBY_MODULE";
    @Nullable
    private final JLabel myBundlerVersionLabel;
    @Nullable
    private final JLabel myBundlerVersionIcon;
    private final Supplier<? extends List<Sdk>> mySdksSupplier;

    public RubySdkComboBox(@NotNull Supplier<? extends List<Sdk>> sdksSupplier, boolean showBundlerInfo) {
        if (sdksSupplier == null) {
            RubySdkComboBox.$$$reportNull$$$0(0);
        }
        this(sdksSupplier, null, showBundlerInfo);
    }

    public RubySdkComboBox(@NotNull Supplier<? extends List<Sdk>> sdksSupplier, @Nullable @Nullable ObservableMutableProperty<@Nullable Sdk> sdkProperty, boolean showBundlerInfo) {
        if (sdksSupplier == null) {
            RubySdkComboBox.$$$reportNull$$$0(1);
        }
        super(RubySdkComboBox.createModel(sdksSupplier.get(), null));
        this.myBundlerVersionLabel = showBundlerInfo ? RubySdkComboBox.createBundlerVersionLabel() : null;
        this.myBundlerVersionIcon = showBundlerInfo ? RubySdkComboBox.createBundlerVersionIcon() : null;
        this.mySdksSupplier = sdksSupplier;
        JBLabel selectedSdkLabel = new JBLabel();
        selectedSdkLabel.setPreferredSize(new Dimension(0, 0));
        selectedSdkLabel.setBackground(UIUtil.getListBackground());
        selectedSdkLabel.setForeground(UIUtil.getListForeground());
        ComboBoxCompositeEditor editor = new ComboBoxCompositeEditor((JComponent)selectedSdkLabel, this.createComponents());
        editor.onSetItem((sdk, label) -> {
            if (sdk == null) {
                label.setIcon(RubySdkType.getInstance().getIcon());
                label.setText(RBundle.message((String)"sdk.renderer.no.sdk.chosen"));
                label.setForeground((Color)JBColor.RED);
                return;
            }
            label.setIcon(((SdkType)sdk.getSdkType()).getIcon());
            label.setText(RubySdkRenderer.getSdkText(sdk, true, true));
            label.setForeground(RubySdkUtil.isSDKValid(sdk) ? UIUtil.getListForeground() : JBColor.RED);
        });
        this.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(@NotNull PopupMenuEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubySdkComboBox.this.requestFocusInWindow();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/wizard/ui/RubySdkComboBox$1", "popupMenuWillBecomeVisible"));
            }
        });
        this.setEditable(true);
        this.setEditor((ComboBoxEditor)editor);
        this.setRenderer((ListCellRenderer)((Object)new RubySdkRenderer(true, true)));
        ComboboxSpeedSearch.installSpeedSearch((JComboBox)((Object)this), RubySdkRenderer::getSdkText);
        this.addActionListener(event -> {
            PropertiesComponent stateComponent = PropertiesComponent.getInstance();
            Sdk currentSdk = (Sdk)this.getItem();
            if (currentSdk != null) {
                stateComponent.setValue(SELECTED_RUBY_SDK_PROPERTY, currentSdk.getName());
            }
            if (sdkProperty != null) {
                sdkProperty.set((Object)currentSdk);
            }
        });
        this.preselectSdk(sdksSupplier.get());
    }

    private void preselectSdk(@NotNull List<Sdk> sdks) {
        PropertiesComponent stateComponent;
        String lastSelectedSdkName;
        Sdk lastSelectedSdk;
        if (sdks == null) {
            RubySdkComboBox.$$$reportNull$$$0(2);
        }
        if ((lastSelectedSdk = (Sdk)ContainerUtil.find(sdks, arg_0 -> RubySdkComboBox.lambda$preselectSdk$2(lastSelectedSdkName = (stateComponent = PropertiesComponent.getInstance()).getValue(SELECTED_RUBY_SDK_PROPERTY), arg_0))) != null) {
            this.setItem(lastSelectedSdk);
        } else if (this.getModel().getSize() != 0) {
            this.setSelectedIndex(0);
        }
    }

    public void refreshBundlerVersion(@Nullable Sdk sdk) {
        if (this.myBundlerVersionLabel == null || this.myBundlerVersionIcon == null) {
            return;
        }
        GemInfo bundler = BundlerUtil.getBundlerGem(sdk, null, false);
        if (bundler != null) {
            this.myBundlerVersionLabel.setText(RBundle.message((String)"ruby.project.wizard.tab.bundler.version", (Object[])new Object[]{bundler.getVersion()}));
        }
        this.myBundlerVersionLabel.setVisible(bundler != null);
        this.myBundlerVersionIcon.setVisible(bundler == null);
    }

    public void refreshSdks() {
        this.setModel((ComboBoxModel)RubySdkComboBox.createModel(this.mySdksSupplier.get(), (Sdk)this.getSelectedItem()));
    }

    private JComponent @NotNull [] createComponents() {
        ArrayList<JLabel> components = new ArrayList<JLabel>();
        if (this.myBundlerVersionLabel != null && this.myBundlerVersionIcon != null) {
            components.add(this.myBundlerVersionLabel);
            components.add(this.myBundlerVersionIcon);
        }
        components.add(this.createAddSdkLabel());
        JComponent[] jComponentArray = components.toArray(new JComponent[0]);
        if (jComponentArray == null) {
            RubySdkComboBox.$$$reportNull$$$0(3);
        }
        return jComponentArray;
    }

    @NotNull
    private JLabel createAddSdkLabel() {
        final JLabel label = new JLabel(AllIcons.General.Add);
        label.setToolTipText(RBundle.message((String)"ruby.project.wizard.tab.sdk.add"));
        label.setCursor(Cursor.getPredefinedCursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(@NotNull MouseEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                label.setIcon(AllIcons.General.Add);
            }

            @Override
            public void mouseExited(@NotNull MouseEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                label.setIcon(AllIcons.General.Add);
            }

            @Override
            public void mouseClicked(@NotNull MouseEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)((Object)RubySdkComboBox.this)));
                SdkConfigurationUtil.createSdk((Project)project, (Sdk[])ProjectJdkTable.getInstance().getAllJdks(), sdk -> {
                    if (sdk == null) {
                        return;
                    }
                    SdkConfigurationUtil.addSdk((Sdk)sdk);
                    RubySdkComboBox.this.refreshSdks();
                    ApplicationManager.getApplication().invokeLater(() -> RubySdkComboBox.this.setSelectedItem(sdk));
                }, (SdkType[])RubySdkGemsConfigurableBase.getAllRubySdkTypes());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/wizard/ui/RubySdkComboBox$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseEntered";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseExited";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseClicked";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        JLabel jLabel = label;
        if (jLabel == null) {
            RubySdkComboBox.$$$reportNull$$$0(4);
        }
        return jLabel;
    }

    @NotNull
    private static JLabel createBundlerVersionLabel() {
        JLabel label = new JLabel();
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
        label.setForeground(UIUtil.getContextHelpForeground());
        label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        label.setVisible(false);
        JLabel jLabel = label;
        if (jLabel == null) {
            RubySdkComboBox.$$$reportNull$$$0(5);
        }
        return jLabel;
    }

    @NotNull
    private static JLabel createBundlerVersionIcon() {
        JLabel label = new JLabel(AllIcons.General.Information);
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
        label.setToolTipText(RBundle.message((String)"ruby.project.wizard.tab.bundler.version.tooltip"));
        JLabel jLabel = label;
        if (jLabel == null) {
            RubySdkComboBox.$$$reportNull$$$0(6);
        }
        return jLabel;
    }

    @NotNull
    private static CollectionComboBoxModel<Sdk> createModel(@NotNull List<Sdk> sdks, @Nullable Sdk selectedItem) {
        if (sdks == null) {
            RubySdkComboBox.$$$reportNull$$$0(7);
        }
        CollectionComboBoxModel<Sdk> collectionComboBoxModel = RubyUIUtil.createSdkComboBoxModel(sdks, selectedItem);
        if (collectionComboBoxModel == null) {
            RubySdkComboBox.$$$reportNull$$$0(8);
        }
        return collectionComboBoxModel;
    }

    private static /* synthetic */ boolean lambda$preselectSdk$2(String lastSelectedSdkName, Sdk sdk) {
        return sdk.getName().equals(lastSelectedSdkName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdksSupplier";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/wizard/ui/RubySdkComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/wizard/ui/RubySdkComboBox";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponents";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddSdkLabel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createBundlerVersionLabel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createBundlerVersionIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "preselectSdk";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

