/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.wizard;

import com.intellij.ide.projectView.actions.MarkRootsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGeneratorBase;
import com.intellij.platform.ProjectGeneratorPeer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.wizard.RubyWizardSharedSettings;

public abstract class RubyFrameworkProjectGenerator<T>
extends DirectoryProjectGeneratorBase<T> {
    private static final Logger LOG = Logger.getInstance(RubyFrameworkProjectGenerator.class);
    private static final List<String> STANDARD_TEST_SOURCE_PATHS = Arrays.asList("features", "spec", "test");

    @NotNull
    @NlsActions.ActionText
    public abstract String getParentGroupName();

    public NotNullLazyValue<ProjectGeneratorPeer<T>> createLazyPeer(@NotNull RubyWizardSharedSettings sharedSettings) {
        if (sharedSettings == null) {
            RubyFrameworkProjectGenerator.$$$reportNull$$$0(0);
        }
        return NotNullLazyValue.lazy(() -> this.createPeer(sharedSettings));
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull T settings, @NotNull Module module) {
        if (project == null) {
            RubyFrameworkProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            RubyFrameworkProjectGenerator.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            RubyFrameworkProjectGenerator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            RubyFrameworkProjectGenerator.$$$reportNull$$$0(4);
        }
        RModuleUtil.getInstance().changeModuleSdk(this.getSdkForNewProject(settings), module);
        new Task.Modal(this, project, RBundle.message((String)"ruby.project.wizard.synchronizing.gems"), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubySdkGemLibraryManager.getInstance().refresh(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/wizard/RubyFrameworkProjectGenerator$1", "run"));
            }
        }.queue();
        this.doGenerateProject(project, baseDir, settings, module);
    }

    @Nullable
    protected abstract Sdk getSdkForNewProject(@NotNull T var1);

    protected abstract void doGenerateProject(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull T var3, @NotNull Module var4);

    @NotNull
    public ProjectGeneratorPeer<T> createPeer() {
        throw new UnsupportedOperationException("Cannot create ruby project generator without shared settings.");
    }

    @NotNull
    protected abstract ProjectGeneratorPeer<T> createPeer(@NotNull RubyWizardSharedSettings var1);

    public static void setupStandardTestSourceRoots(@NotNull VirtualFile baseDir, @NotNull ModifiableRootModel model) {
        ContentEntry entry;
        if (baseDir == null) {
            RubyFrameworkProjectGenerator.$$$reportNull$$$0(5);
        }
        if (model == null) {
            RubyFrameworkProjectGenerator.$$$reportNull$$$0(6);
        }
        if ((entry = MarkRootsManager.findContentEntry((ModuleRootModel)model, (VirtualFile)baseDir)) != null) {
            String baseDirUrl = baseDir.getUrl();
            STANDARD_TEST_SOURCE_PATHS.forEach(path -> entry.addSourceFolder(VirtualFileUtil.buildUrl(baseDirUrl, path), true));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/wizard/RubyFrameworkProjectGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLazyPeer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "generateProject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setupStandardTestSourceRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

