/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.utils.OSUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemData;

public final class RubySystemVersionManagerHandler
extends RubyVersionManagerHandler<RubySystemData> {
    private static final Logger LOG = Logger.getInstance(RubySystemVersionManagerHandler.class);

    @NotNull
    public static RubySystemVersionManagerHandler getInstance() {
        RubySystemVersionManagerHandler rubySystemVersionManagerHandler = Objects.requireNonNull((RubySystemVersionManagerHandler)RubyVersionManagerHandler.findHandler(o -> o instanceof RubySystemVersionManagerHandler));
        if (rubySystemVersionManagerHandler == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(0);
        }
        return rubySystemVersionManagerHandler;
    }

    @Override
    @NotNull
    public String getId() {
        return "system";
    }

    @Override
    @NotNull
    public String getRemoteNameSuffix() {
        return "";
    }

    @Override
    @NotNull
    public RubySystemData createAdditionalData() {
        return new RubySystemData(this);
    }

    @NotNull
    public RubySystemData createAdditionalData(@NotNull List<@NlsSafe String> configuratorAndArguments) {
        if (configuratorAndArguments == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(1);
        }
        RubySystemData rubySystemData = this.createAdditionalData().withConfiguratorAndArguments(configuratorAndArguments);
        if (rubySystemData == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(2);
        }
        return rubySystemData;
    }

    @Override
    @Nullable
    protected RubyVersionManagerSdkData doLoadLegacy(@NotNull Element rootElement, @NotNull String interpreterPath) {
        if (rootElement == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(3);
        }
        if (interpreterPath == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(4);
        }
        return this.createAdditionalData();
    }

    @Override
    @Nullable
    protected RubySystemData doCreateAdditionalData(@NotNull RubyRemoteSdkAdditionalData remoteSdkAdditionalData) throws RemoteSdkException {
        if (remoteSdkAdditionalData == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(5);
        }
        RubySystemData data = this.createAdditionalData();
        RubySystemVersionManagerHandler.clarifyInterpreterPathIfNecessary(remoteSdkAdditionalData);
        return data;
    }

    @Override
    public void doPatchCommandLine(@NotNull RubyAbstractRunner rubyRunner, @NotNull GeneralCommandLine commandLine, @NotNull Map<String, String> envParams, @NotNull Map<String, String> customEnvVariables, @NotNull Sdk sdk, @NotNull PathMappingSettings pathMappings) {
        List<String> configuratorAndArguments;
        if (rubyRunner == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(6);
        }
        if (commandLine == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(7);
        }
        if (envParams == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(8);
        }
        if (customEnvVariables == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(9);
        }
        if (sdk == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(10);
        }
        if (pathMappings == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(11);
        }
        if (!ContainerUtil.isEmpty(configuratorAndArguments = RubySystemVersionManagerHandler.getConfiguratorAndArgumentsFrom(sdk))) {
            List commands = ContainerUtil.concat(configuratorAndArguments, (List)commandLine.getCommandLineList(null));
            commandLine.setExePath(RunnerUtil.clarifyExePath((String)commands.get(0)));
            commandLine.getParametersList().clearAll();
            commandLine.withParameters(ContainerUtil.subList((List)commands, (int)1));
        }
        RubySystemVersionManagerHandler.removeGemHomeAndGemPath(envParams, commandLine);
        RubySdkAdditionalData sdkAdditionalData = RubySdkAdditionalData.notNullFrom(sdk);
        RubySdkSystemAccessor accessor = sdkAdditionalData.getSdkSystemAccessor();
        StringBuilder patchedPath = new StringBuilder();
        patchedPath.append(RubySdkAdditionalData.getInterpreterDir(sdk)).append(accessor.getPathSeparator());
        String gemsBinDirectory = sdkAdditionalData.hasGemsBinDirectory() ? sdkAdditionalData.getGemsBinDirectory() : RubySdkAdditionalData.getInterpreterDir(sdk);
        patchedPath.append(rubyRunner.toSystemDependentName(gemsBinDirectory, pathMappings));
        Collection<String> gemPathUrls = GemManager.getInstance().getGemRootUrlsForSDK(sdk);
        for (String gemPathUrl : gemPathUrls) {
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            VirtualFile gemRootFolder = virtualFileManager.findFileByUrl(gemPathUrl);
            VirtualFile gemsRootParentFolder = gemRootFolder == null ? null : gemRootFolder.getParent();
            VirtualFile gemsRootBinFolder = gemsRootParentFolder == null ? null : gemsRootParentFolder.findChild("bin");
            if (gemsRootBinFolder == null) continue;
            patchedPath.append(accessor.getPathSeparator()).append(RubySdkUtil.convertToRemote(sdk, rubyRunner.getModule(), gemsRootBinFolder.getPath()));
        }
        String pathEnvVarName = OSUtil.getPathEnvVariableName(accessor);
        String currentProcessPath = envParams.get(pathEnvVarName);
        if (!customEnvVariables.containsKey(pathEnvVarName)) {
            if (!patchedPath.isEmpty()) {
                envParams.put(pathEnvVarName, rubyRunner.toSystemDependentName(OSUtil.prependToPathEnvVariable(currentProcessPath, patchedPath.toString(), accessor), pathMappings));
            }
        } else {
            Map<String, String> parentEnv = rubyRunner.getParentEnv();
            String parentPath = parentEnv.getOrDefault(pathEnvVarName, "");
            if (currentProcessPath.contains(parentPath)) {
                String patchedParentPath = rubyRunner.toSystemDependentName(OSUtil.prependToPathEnvVariable(parentPath, patchedPath.toString(), accessor), pathMappings);
                String updatedCurrentPath = currentProcessPath.replace(parentPath, patchedParentPath);
                envParams.put(pathEnvVarName, updatedCurrentPath);
            }
        }
    }

    private static void clarifyInterpreterPathIfNecessary(@NotNull RubyRemoteSdkAdditionalData remoteSdkAdditionalData) throws RemoteSdkException {
        String interpreterPath;
        if (remoteSdkAdditionalData == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(12);
        }
        if (new File(interpreterPath = remoteSdkAdditionalData.getInterpreterPath()).getParent() == null) {
            String clarifiedInterpreterPath = RubySystemVersionManagerHandler.clarifyInterpreterPath(interpreterPath, remoteSdkAdditionalData.getRunner(null));
            if (!interpreterPath.equals(clarifiedInterpreterPath)) {
                remoteSdkAdditionalData.setInterpreterPath(clarifiedInterpreterPath);
            } else {
                throw new RemoteSdkException(RBundle.message((String)"dialog.message.unable.to.detect.full.path.for.interpreter", (Object[])new Object[]{interpreterPath}));
            }
        }
    }

    @NotNull
    private static String clarifyInterpreterPath(@NotNull String interpreterPath, @NotNull RubyRunner rubyRunner) throws RemoteSdkException {
        List stdoutLines;
        ProcessOutput processOutput;
        if (interpreterPath == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(13);
        }
        if (rubyRunner == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(14);
        }
        try {
            RubyRunnerExecutionContext whichRubyContext = RubyRunnerExecutionContext.create("which", interpreterPath);
            processOutput = rubyRunner.execute((RubyRunnerExecutionContext)whichRubyContext.inSameThreadCancelableUnderProgressIndicator(RubyRunner.DEFAULT_EXECUTION_TIMEOUT));
        }
        catch (ExecutionException e) {
            throw new RemoteSdkException(e.getMessage());
        }
        List list = stdoutLines = processOutput == null ? Collections.emptyList() : processOutput.getStdoutLines();
        if (!stdoutLines.isEmpty()) {
            String fullInterpreterPath = (String)stdoutLines.get(0);
            if (!StringUtil.isEmpty((String)interpreterPath)) {
                String string = fullInterpreterPath;
                if (string == null) {
                    RubySystemVersionManagerHandler.$$$reportNull$$$0(15);
                }
                return string;
            }
        }
        LOG.warn("Failed to retrieve interpreter's path. Output: " + String.valueOf(processOutput));
        throw new RemoteSdkException(RBundle.message((String)"dialog.message.unable.to.detect.full.path.for.interpreter", (Object[])new Object[]{interpreterPath}));
    }

    private static @Nullable List<@NlsSafe String> getConfiguratorAndArgumentsFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(16);
        }
        return (List)ObjectUtils.doIfNotNull((Object)RubySystemData.from(sdk), RubySystemData::getConfiguratorAndArguments);
    }

    public static boolean hasCustomConfigurator(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySystemVersionManagerHandler.$$$reportNull$$$0(17);
        }
        return !ContainerUtil.isEmpty(RubySystemVersionManagerHandler.getConfiguratorAndArgumentsFrom(sdk));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/system/RubySystemVersionManagerHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuratorAndArguments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkAdditionalData";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envParams";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customEnvVariables";
                break;
            }
            case 10: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/system/RubySystemVersionManagerHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalData";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "clarifyInterpreterPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doLoadLegacy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreateAdditionalData";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doPatchCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "clarifyInterpreterPathIfNecessary";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "clarifyInterpreterPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguratorAndArgumentsFrom";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasCustomConfigurator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

