/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.system;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.RubyImplementationHandler;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemVersionManagerHandler;

@ApiStatus.Internal
public final class RubySystemData
extends RubyVersionManagerSdkData<RubySystemData> {
    private static final Logger LOG = Logger.getInstance(RubySystemData.class);
    @Tag(value="custom-configurator")
    private @NotNull List<@NlsSafe String> myConfiguratorAndArguments;

    RubySystemData(@NotNull RubySystemVersionManagerHandler handler) {
        if (handler == null) {
            RubySystemData.$$$reportNull$$$0(0);
        }
        super(handler);
        this.myConfiguratorAndArguments = List.of();
    }

    public @NotNull List<@NlsSafe String> getConfiguratorAndArguments() {
        List<String> list = this.myConfiguratorAndArguments;
        if (list == null) {
            RubySystemData.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public RubySystemData withConfiguratorAndArguments(@NotNull List<@NlsSafe String> configuratorAndArguments) {
        if (configuratorAndArguments == null) {
            RubySystemData.$$$reportNull$$$0(2);
        }
        this.assertWritable();
        this.myConfiguratorAndArguments = List.copyOf(configuratorAndArguments);
        RubySystemData rubySystemData = this;
        if (rubySystemData == null) {
            RubySystemData.$$$reportNull$$$0(3);
        }
        return rubySystemData;
    }

    @Override
    @NotNull
    protected RubySystemData copyTo(@NotNull RubySystemData target) {
        if (target == null) {
            RubySystemData.$$$reportNull$$$0(4);
        }
        RubySystemData rubySystemData = target.withConfiguratorAndArguments(this.myConfiguratorAndArguments);
        if (rubySystemData == null) {
            RubySystemData.$$$reportNull$$$0(5);
        }
        return rubySystemData;
    }

    @Override
    @NotNull
    protected RubySystemData self() {
        RubySystemData rubySystemData = this;
        if (rubySystemData == null) {
            RubySystemData.$$$reportNull$$$0(6);
        }
        return rubySystemData;
    }

    @Override
    public boolean areGemsUserLocal(@NotNull Sdk sdk) {
        boolean isWindows;
        if (sdk == null) {
            RubySystemData.$$$reportNull$$$0(7);
        }
        if ((isWindows = RubySdkSystemAccessor.notNullFrom(sdk).isWindows()) && ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        RubyGemsEnvironment gemEnv = RubyGemsEnvironment.get(sdk);
        Path installDir = (Path)ObjectUtils.doIfNotNull((Object)gemEnv.getInstallationDirectory(), x$0 -> Path.of(x$0, new String[0]));
        if (installDir == null) {
            return false;
        }
        try {
            return isWindows ? Files.isReadable(installDir) && Files.isWritable(installDir) : Files.isReadable(installDir) && Files.isWritable(installDir) && Files.isExecutable(installDir);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = this.myConfiguratorAndArguments.isEmpty() ? RBundle.message((String)"ruby.ide.sdk.version.manager.presentable.name.system") : RBundle.message((String)"ruby.ide.sdk.version.manager.presentable.name.with.custom.configurator", (Object[])new Object[]{ParametersListUtil.DEFAULT_LINE_JOINER.fun(this.myConfiguratorAndArguments)});
        if (string == null) {
            RubySystemData.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public boolean isMatching(@NotNull RubySdkConfig sdkConfig, @NotNull Sdk sdk) {
        if (sdkConfig == null) {
            RubySystemData.$$$reportNull$$$0(9);
        }
        if (sdk == null) {
            RubySystemData.$$$reportNull$$$0(10);
        }
        if (!this.isMatchingVmHandler(sdkConfig)) {
            return false;
        }
        String fakeDistName = RubySystemData.createFakeDistributionId(sdk);
        LOG.debug("Fake distribution name for ", new Object[]{sdk, " is ", fakeDistName});
        return fakeDistName != null && StringUtil.startsWith((CharSequence)fakeDistName, (CharSequence)sdkConfig.distName());
    }

    @Nullable
    private static String createFakeDistributionId(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySystemData.$$$reportNull$$$0(11);
        }
        RubyImplementationHandler handler = RubyImplementationHandler.notNullFrom(sdk);
        String implementationName = handler.getImplementationName();
        String shortVersion = handler.getShortVersion();
        if (shortVersion == null) {
            return null;
        }
        String fakeDistributionId = implementationName + "-" + shortVersion;
        return RubyVersionUtil.normalizeVersionForVms(fakeDistributionId);
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static RubySystemData from(@Nullable Sdk sdk) {
        return (RubySystemData)ObjectUtils.tryCast((Object)RubyVersionManagerSdkData.from(sdk), RubySystemData.class);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.myConfiguratorAndArguments.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myConfiguratorAndArguments.equals(((RubySystemData)o).myConfiguratorAndArguments);
    }

    @Override
    @NotNull
    public RubySystemData withDistributionId(@NotNull String distributionId) {
        if (distributionId == null) {
            RubySystemData.$$$reportNull$$$0(12);
        }
        this.assertWritable();
        RubySystemData rubySystemData = this.self();
        if (rubySystemData == null) {
            RubySystemData.$$$reportNull$$$0(13);
        }
        return rubySystemData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6, 8, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/system/RubySystemData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuratorAndArguments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkConfig";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/system/RubySystemData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguratorAndArguments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withConfiguratorAndArguments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "self";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withDistributionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withConfiguratorAndArguments";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areGemsUserLocal";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMatching";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFakeDistributionId";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withDistributionId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6, 8, 13 -> new IllegalStateException(string);
        };
    }
}

