/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.version.management.KeyValueConfigFile;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

final class VersionsConfFile
extends KeyValueConfigFile {
    public static final String VERSIONS_CONF_FILE_NAME = ".versions.conf";
    private static final String RUBY_VERSION_KEY = "ruby";
    private static final String RUBY_GEMSET_KEY = "ruby-gemset";

    private VersionsConfFile(@NotNull String content) {
        if (content == null) {
            VersionsConfFile.$$$reportNull$$$0(0);
        }
        super(content, "=");
    }

    @Nullable
    public String getRubyVersion() {
        return this.get(RUBY_VERSION_KEY);
    }

    @Nullable
    public String getGemset() {
        return this.get(RUBY_GEMSET_KEY);
    }

    @Contract(value="null -> null")
    @Nullable
    public static VersionsConfFile create(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        String configContent = LoadTextUtil.loadText((VirtualFile)file).toString();
        if (configContent.isEmpty()) {
            return null;
        }
        return new VersionsConfFile(configContent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/ruby/version/management/rvm/VersionsConfFile", "<init>"));
    }

    static final class SdkConfigFactory
    implements RubySdkConfig.Factory {
        private static final List<String> SOURCE_FILENAMES = Collections.singletonList(".versions.conf");

        SdkConfigFactory() {
        }

        @Override
        @NotNull
        public Collection<String> getSourceFilenames() {
            List<String> list = SOURCE_FILENAMES;
            if (list == null) {
                SdkConfigFactory.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Nullable
        public RubySdkConfig createFromRoot(@NotNull VirtualFile root, @NotNull RubyVersionManagerHandler vmHandler) {
            VersionsConfFile file;
            if (root == null) {
                SdkConfigFactory.$$$reportNull$$$0(1);
            }
            if (vmHandler == null) {
                SdkConfigFactory.$$$reportNull$$$0(2);
            }
            if ((file = VersionsConfFile.create(root.findChild(VersionsConfFile.VERSIONS_CONF_FILE_NAME))) == null || file.getRubyVersion() == null) {
                return null;
            }
            String version = RubyVersionUtil.normalizeVersionForVms(file.getRubyVersion());
            return new RubySdkConfig(version, file.getGemset(), VersionsConfFile.VERSIONS_CONF_FILE_NAME, vmHandler);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/VersionsConfFile$SdkConfigFactory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vmHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFilenames";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/VersionsConfFile$SdkConfigFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createFromRoot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

