/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherVmBase;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.LocalRvmPathsSettings;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmVersionManagerHandler;

public final class RvmSdkRefresher
extends SdkRefresherVmBase {
    private static final Logger LOG = Logger.getInstance(RvmSdkRefresher.class);
    private static final Set<String> DIRS_TO_IGNORE = ContainerUtil.newHashSet((Object[])new String[]{"default", "cache"});
    private NullableLazyValue<RvmVersionManagerHandler.RvmEnvironment> myRvmEnvironmentProvider;

    public RvmSdkRefresher() {
        this.resetRvmEnvironment();
    }

    @Override
    @Nullable
    public String suggestSdkName(@NotNull String executablePath, @NotNull String distributionId, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        if (executablePath == null) {
            RvmSdkRefresher.$$$reportNull$$$0(0);
        }
        if (distributionId == null) {
            RvmSdkRefresher.$$$reportNull$$$0(1);
        }
        if (versionManagerSdkAdditionalData == null) {
            RvmSdkRefresher.$$$reportNull$$$0(2);
        }
        if (!(versionManagerSdkAdditionalData instanceof RvmSdkData)) {
            return null;
        }
        String name = "RVM: " + distributionId;
        String gemsetName = ((RvmSdkData)versionManagerSdkAdditionalData).getGemsetName();
        if (!StringUtil.isEmpty((String)gemsetName)) {
            return name + RVMSupportUtil.getGemsetSuffix(gemsetName);
        }
        return name;
    }

    @Override
    protected void doAdditionalInitialization() {
        super.doAdditionalInitialization();
        LocalRvmPathsSettings.getInstance().initialize();
    }

    @Override
    @NotNull
    protected List<String> getPossibleVersionManagersPaths() {
        List list = ContainerUtil.map(RvmVersionManagerHandler.RVM_SEARCH_PATHS_LIST, it -> Paths.get(it, this.getVersionManagerHandler().getVersionManagerExecutableName()).toString());
        if (list == null) {
            RvmSdkRefresher.$$$reportNull$$$0(3);
        }
        return list;
    }

    private void resetRvmEnvironment() {
        this.myRvmEnvironmentProvider = NullableLazyValue.atomicLazyNullable(() -> RvmVersionManagerHandler.RvmEnvironment.compute(this.getVersionManagerPath(), RubyLocalRunner.getRunner(null)));
    }

    @Nullable
    private RvmVersionManagerHandler.RvmEnvironment getRvmEnvironment() {
        return (RvmVersionManagerHandler.RvmEnvironment)Objects.requireNonNull(this.myRvmEnvironmentProvider).getValue();
    }

    @Override
    @NotNull
    protected List<String> getInstallationsRootsPathNames() {
        RvmVersionManagerHandler.RvmEnvironment rvmEnvironment = this.getRvmEnvironment();
        List<String> list = rvmEnvironment == null ? Collections.emptyList() : Collections.singletonList(rvmEnvironment.getGemsPath());
        if (list == null) {
            RvmSdkRefresher.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    protected Stream<? extends RubySdkInfo> getSdkInfosForInterpreterHome(@NotNull String versionManagerPathName, @NotNull VirtualFile interpreterHome) {
        String interpreterHomeName;
        if (versionManagerPathName == null) {
            RvmSdkRefresher.$$$reportNull$$$0(5);
        }
        if (interpreterHome == null) {
            RvmSdkRefresher.$$$reportNull$$$0(6);
        }
        if (DIRS_TO_IGNORE.contains(interpreterHomeName = interpreterHome.getName())) {
            this.myLog.debug("Skipping directory: " + interpreterHomeName);
            Stream stream = Stream.empty();
            if (stream == null) {
                RvmSdkRefresher.$$$reportNull$$$0(7);
            }
            return stream;
        }
        RvmVersionManagerHandler.RvmEnvironment rvmEnvironment = this.getRvmEnvironment();
        if (rvmEnvironment == null) {
            this.myLog.debug("Something is wrong, environment is empty");
            Stream stream = Stream.empty();
            if (stream == null) {
                RvmSdkRefresher.$$$reportNull$$$0(8);
            }
            return stream;
        }
        ArrayList versionAndGemSet = new ArrayList(StringUtil.split((String)interpreterHomeName, (String)"@", (boolean)true));
        String interpreterName = (String)versionAndGemSet.remove(0);
        VirtualFile realInterpreterHome = VfsUtil.findRelativeFile((VirtualFile)rvmEnvironment.getRubiesVirtualFile(), (String[])new String[]{interpreterName});
        if (realInterpreterHome == null) {
            this.myLog.debug("Unable to find interpreter home: [gem home: " + String.valueOf(interpreterHome) + "; interpreter name: " + interpreterName + "; rubies home: " + String.valueOf(rvmEnvironment.getRubiesVirtualFile()) + "]");
            Stream stream = Stream.empty();
            if (stream == null) {
                RvmSdkRefresher.$$$reportNull$$$0(9);
            }
            return stream;
        }
        Stream<RubySdkInfo> stream = Stream.of(new RubySdkInfo(versionManagerPathName, realInterpreterHome, versionAndGemSet.isEmpty() ? null : (String)versionAndGemSet.get(0)));
        if (stream == null) {
            RvmSdkRefresher.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @Override
    @NotNull
    protected Set<? extends RubySdkInfo> getSdkInfos() {
        this.resetRvmEnvironment();
        Set<? extends RubySdkInfo> set = super.getSdkInfos();
        if (set == null) {
            RvmSdkRefresher.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public static RvmSdkRefresher getInstance() {
        RvmSdkRefresher rvmSdkRefresher = (RvmSdkRefresher)EP_NAME.findExtensionOrFail(RvmSdkRefresher.class);
        if (rvmSdkRefresher == null) {
            RvmSdkRefresher.$$$reportNull$$$0(12);
        }
        return rvmSdkRefresher;
    }

    @Override
    @NotNull
    protected @NotNull Collection<? extends @NotNull VirtualFile> getRootsToRefresh() {
        VirtualFile gemsFolder = LocalRvmPathsSettings.getInstance().getGemsFolder();
        VirtualFile interpretersFolder = LocalRvmPathsSettings.getInstance().getInterpretersFolder();
        if (gemsFolder == null || interpretersFolder == null) {
            List list = List.of();
            if (list == null) {
                RvmSdkRefresher.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<VirtualFile> list = List.of(gemsFolder, interpretersFolder);
        if (list == null) {
            RvmSdkRefresher.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    public static String getVersion(@NotNull Sdk sdk) {
        String rbenvVersion;
        String rvmVersion;
        if (sdk == null) {
            RvmSdkRefresher.$$$reportNull$$$0(15);
        }
        if (RVMSupportUtil.isRVMInterpreter(sdk) && (rvmVersion = RVMSupportUtil.getRVMSdkVersion(sdk)) != null) {
            return rvmVersion;
        }
        if (RbenvGemsetManager.isRbenvSdk(sdk) && (rbenvVersion = RbenvGemsetManager.getSdkVersion(sdk)) != null) {
            return rbenvVersion;
        }
        return null;
    }

    public static void createRVMGemset(@Nullable Project project, @NotNull Sdk rootRVMSdk, @NotNull String gemset, @NotNull NullableConsumer<? super Sdk> postAction) {
        if (rootRVMSdk == null) {
            RvmSdkRefresher.$$$reportNull$$$0(16);
        }
        if (gemset == null) {
            RvmSdkRefresher.$$$reportNull$$$0(17);
        }
        if (postAction == null) {
            RvmSdkRefresher.$$$reportNull$$$0(18);
        }
        MultiMap rootRVMSdkToNewGemsets = new MultiMap();
        rootRVMSdkToNewGemsets.putValue((Object)rootRVMSdk, (Object)gemset);
        RvmSdkRefresher.createRVMGemsets(project, (MultiMap<Sdk, String>)rootRVMSdkToNewGemsets, postAction);
    }

    public static void createRVMGemsets(@Nullable Project project, final @NotNull MultiMap<Sdk, String> rootRVMSdkToNewGemsets, @NotNull NullableConsumer<? super Sdk> postAction) {
        if (rootRVMSdkToNewGemsets == null) {
            RvmSdkRefresher.$$$reportNull$$$0(19);
        }
        if (postAction == null) {
            RvmSdkRefresher.$$$reportNull$$$0(20);
        }
        final PairConsumer consumer = (sdk, gemset) -> {
            RubyRunner runner = RunnerUtil.getRunner(sdk, null);
            VirtualFile rvmExec = LocalRvmPathsSettings.getInstance().getRvmExecutable();
            if (rvmExec == null) {
                return;
            }
            String canonicalPath = rvmExec.getCanonicalPath();
            if (canonicalPath == null) {
                return;
            }
            try {
                String sdkVersion = RvmSdkRefresher.getVersion(sdk);
                runner.execute((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdk, canonicalPath, sdkVersion, "gemset", "create", gemset).withProject(project)).inSameThread(Registry.intValue((String)"command.line.execution.timeout")));
                RvmSdkRefresher.getInstance().refreshVfsRootsAndSdks(() -> postAction.consume((Object)RVMSupportUtil.findRVMGemsetSdk(sdk, gemset)));
            }
            catch (ExecutionException e) {
                LOG.error("Cannot create rvm gemset; " + e.getMessage());
            }
        };
        Task.Backgroundable task = new Task.Backgroundable(project, RBundle.message((String)"new.project.wizard.rvm.gemset.create.gemsets.title"), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                int gemsNumber = rootRVMSdkToNewGemsets.values().size();
                int i = 0;
                indicator.setIndeterminate(false);
                for (Sdk rootRVMSdk : rootRVMSdkToNewGemsets.keySet()) {
                    for (String gemset : rootRVMSdkToNewGemsets.get((Object)rootRVMSdk)) {
                        indicator.setFraction((double)i++ / (double)gemsNumber);
                        indicator.setText(RBundle.message((String)"new.project.wizard.rvm.gemset.create.title", (Object[])new Object[]{RvmSdkRefresher.getVersion(rootRVMSdk) + "@" + gemset}));
                        consumer.consume((Object)rootRVMSdk, (Object)gemset);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    @NotNull
    public static String getRvmRubyDistName(@NotNull VirtualFile rubyInterpreter) {
        if (rubyInterpreter == null) {
            RvmSdkRefresher.$$$reportNull$$$0(21);
        }
        VirtualFile binFolder = rubyInterpreter.getParent();
        VirtualFile rubyDistFolder = binFolder.getParent();
        String string = rubyDistFolder.getName();
        if (string == null) {
            RvmSdkRefresher.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public RvmVersionManagerHandler getVersionManagerHandler() {
        RvmVersionManagerHandler rvmVersionManagerHandler = RvmVersionManagerHandler.getInstance();
        if (rvmVersionManagerHandler == null) {
            RvmSdkRefresher.$$$reportNull$$$0(23);
        }
        return rvmVersionManagerHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPathName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterHome";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootRVMSdk";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemset";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postAction";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootRVMSdkToNewGemsets";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleVersionManagersPaths";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallationsRootsPathNames";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfos";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToRefresh";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRvmRubyDistName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createRVMGemset";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createRVMGemsets";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRvmRubyDistName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 22, 23 -> new IllegalStateException(string);
        };
    }
}

