/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.intellij.execution.CommandLineUtil;
import com.intellij.openapi.module.Module;
import com.intellij.util.system.OS;
import java.lang.invoke.CallSite;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.SdkActionHandler;
import org.jetbrains.plugins.ruby.version.management.SdkInstallerVmBase;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherVmBase;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkRefresher;

public final class RvmSdkInstaller
extends SdkInstallerVmBase {
    @Override
    @NotNull
    protected SdkRefresherVmBase getSdkRefresher() {
        RvmSdkRefresher rvmSdkRefresher = RvmSdkRefresher.getInstance();
        if (rvmSdkRefresher == null) {
            RvmSdkInstaller.$$$reportNull$$$0(0);
        }
        return rvmSdkRefresher;
    }

    @Override
    @NotNull
    protected List<String> getInstallCommand(@NotNull String versionManagerPath, @NotNull String version) {
        if (versionManagerPath == null) {
            RvmSdkInstaller.$$$reportNull$$$0(1);
        }
        if (version == null) {
            RvmSdkInstaller.$$$reportNull$$$0(2);
        }
        if (OS.CURRENT == OS.macOS && !version.isEmpty() && Character.isDigit(version.charAt(0))) {
            String quotedPath = CommandLineUtil.posixQuote((String)versionManagerPath);
            String quotedVersion = CommandLineUtil.posixQuote((String)version);
            List<CallSite> list = List.of("/bin/sh", "-c", quotedPath + " install " + quotedVersion + " --with-openssl-dir=`brew --prefix openssl@1.1`");
            if (list == null) {
                RvmSdkInstaller.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<String> list = List.of(versionManagerPath, "install", version);
        if (list == null) {
            RvmSdkInstaller.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<String> getUninstallCommand(@NotNull String versionManagerPath, @NotNull String version) {
        if (versionManagerPath == null) {
            RvmSdkInstaller.$$$reportNull$$$0(5);
        }
        if (version == null) {
            RvmSdkInstaller.$$$reportNull$$$0(6);
        }
        List<String> list = List.of(versionManagerPath, "remove", version);
        if (list == null) {
            RvmSdkInstaller.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @Nullable
    public SdkActionHandler createInstallHandler(@NotNull Module module, @NotNull RubySdkConfig sdkConfig) {
        if (module == null) {
            RvmSdkInstaller.$$$reportNull$$$0(8);
        }
        if (sdkConfig == null) {
            RvmSdkInstaller.$$$reportNull$$$0(9);
        }
        return sdkConfig.gemset() != null ? null : super.createInstallHandler(module, sdkConfig);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkInstaller";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRefresher";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkInstaller";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninstallCommand";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstallCommand";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUninstallCommand";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createInstallHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

