/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.version.management.GemsetSupporter;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkDataBase;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmVersionManagerHandler;

public class RvmSdkData
extends RubyVersionManagerSdkDataBase<RvmSdkData>
implements GemsetSupporter<RvmSdkData> {
    private boolean myRVMIgnoreGlobalGemset;

    RvmSdkData(@NotNull RvmVersionManagerHandler handler) {
        if (handler == null) {
            RvmSdkData.$$$reportNull$$$0(0);
        }
        super(handler);
    }

    @Override
    @NotNull
    protected RvmSdkData copyTo(@NotNull RvmSdkData target) {
        if (target == null) {
            RvmSdkData.$$$reportNull$$$0(1);
        }
        RvmSdkData rvmSdkData = super.copyTo(target).withRVMIgnoreGlobalGemset(this.isRVMIgnoreGlobalGemset());
        if (rvmSdkData == null) {
            RvmSdkData.$$$reportNull$$$0(2);
        }
        return rvmSdkData;
    }

    @Override
    @Nullable
    public String getGemsetName() {
        String distributionId = this.getDistributionId();
        int gemsetIndex = distributionId.indexOf("@");
        return gemsetIndex == -1 ? null : distributionId.substring(gemsetIndex + 1);
    }

    @Override
    @Deprecated
    @NotNull
    public RvmSdkData withGemsetName(@Nullable String gemsetName) {
        this.assertWritable();
        RvmSdkData rvmSdkData = this.withDistributionId(this.myDistributionId == null ? "" : this.getSelectedRubyVersion(), gemsetName);
        if (rvmSdkData == null) {
            RvmSdkData.$$$reportNull$$$0(3);
        }
        return rvmSdkData;
    }

    @NotNull
    private String getSelectedRubyVersion() {
        String distributionId = this.getDistributionId();
        int gemsetIndex = distributionId.indexOf("@");
        String string = gemsetIndex == -1 ? distributionId : distributionId.substring(0, gemsetIndex);
        if (string == null) {
            RvmSdkData.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isRVMIgnoreGlobalGemset() {
        return this.myRVMIgnoreGlobalGemset;
    }

    @NotNull
    public RvmSdkData withRVMIgnoreGlobalGemset(boolean RVMIgnoreGlobalGemset) {
        this.assertWritable();
        this.myRVMIgnoreGlobalGemset = RVMIgnoreGlobalGemset;
        RvmSdkData rvmSdkData = this.self();
        if (rvmSdkData == null) {
            RvmSdkData.$$$reportNull$$$0(5);
        }
        return rvmSdkData;
    }

    @NotNull
    public RvmSdkData withDistributionId(@NotNull String selectedRuby, @Nullable String gemsetName) {
        if (selectedRuby == null) {
            RvmSdkData.$$$reportNull$$$0(6);
        }
        this.assertWritable();
        RvmSdkData rvmSdkData = (RvmSdkData)super.withDistributionId((String)(gemsetName == null ? selectedRuby : selectedRuby + "@" + gemsetName));
        if (rvmSdkData == null) {
            RvmSdkData.$$$reportNull$$$0(7);
        }
        return rvmSdkData;
    }

    @Override
    @NotNull
    public String getRemoteSdkNameSuffix() {
        String gemsetName = this.getGemsetName();
        String string = StringUtil.isEmpty((String)gemsetName) ? super.getRemoteSdkNameSuffix() : RVMSupportUtil.getGemsetSuffix(gemsetName);
        if (string == null) {
            RvmSdkData.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = "Rvm sdk, gemset " + this.getGemsetName();
        if (string == null) {
            RvmSdkData.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public boolean isMatching(@NotNull RubySdkConfig sdkConfig, @NotNull Sdk sdk) {
        if (sdkConfig == null) {
            RvmSdkData.$$$reportNull$$$0(10);
        }
        if (sdk == null) {
            RvmSdkData.$$$reportNull$$$0(11);
        }
        return this.isMatchingVmHandler(sdkConfig) && StringUtil.startsWith((CharSequence)RubyVersionUtil.normalizeVersionForVms(this.getDistributionId()), (CharSequence)sdkConfig.distName()) && Objects.equals(this.getGemsetName(), sdkConfig.gemset());
    }

    @Override
    @NotNull
    protected RvmSdkData self() {
        RvmSdkData rvmSdkData = this;
        if (rvmSdkData == null) {
            RvmSdkData.$$$reportNull$$$0(12);
        }
        return rvmSdkData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RvmSdkData data = (RvmSdkData)o;
        return this.myRVMIgnoreGlobalGemset == data.myRVMIgnoreGlobalGemset;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myRVMIgnoreGlobalGemset ? 1 : 0);
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static RvmSdkData from(@Nullable SdkAdditionalData sdkAdditionalData) {
        return (RvmSdkData)ObjectUtils.tryCast((Object)RubyVersionManagerSdkData.from(sdkAdditionalData), RvmSdkData.class);
    }

    @NotNull
    public static RvmSdkData notNullFrom(@NotNull SdkAdditionalData sdkAdditionalData) {
        if (sdkAdditionalData == null) {
            RvmSdkData.$$$reportNull$$$0(13);
        }
        RvmSdkData rvmSdkData = Objects.requireNonNull(RvmSdkData.from(sdkAdditionalData), () -> "No Rvm sdk additional data in " + String.valueOf(sdkAdditionalData));
        if (rvmSdkData == null) {
            RvmSdkData.$$$reportNull$$$0(14);
        }
        return rvmSdkData;
    }

    @Contract(value="null -> null")
    @Nullable
    public static RvmSdkData from(@Nullable Sdk sdk) {
        return (RvmSdkData)ObjectUtils.tryCast((Object)RubyVersionManagerSdkData.from(sdk), RvmSdkData.class);
    }

    @NotNull
    public static RvmSdkData notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RvmSdkData.$$$reportNull$$$0(15);
        }
        RvmSdkData rvmSdkData = Objects.requireNonNull(RvmSdkData.from(sdk), () -> "No Rvm sdk additional data in " + String.valueOf(sdk));
        if (rvmSdkData == null) {
            RvmSdkData.$$$reportNull$$$0(16);
        }
        return rvmSdkData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7, 8, 9, 12, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRuby";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkConfig";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withGemsetName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRubyVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withRVMIgnoreGlobalGemset";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withDistributionId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkNameSuffix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "self";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withDistributionId";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMatching";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7, 8, 9, 12, 14, 16 -> new IllegalStateException(string);
        };
    }
}

