/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rbenv.gemsets;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvOptionReference;

public final class RbenvGemsetReferenceProvider
extends PsiReferenceProvider {
    public static final Set<String> RBENV_GEMSETS_COMPLETION_FILES_TO_IGNORE = Set.of(".idea", "specifications");
    private static RbenvGemsetReferenceProvider ourInstance;

    private RbenvGemsetReferenceProvider() {
    }

    public static RbenvGemsetReferenceProvider getInstance() {
        if (ourInstance == null) {
            ourInstance = new RbenvGemsetReferenceProvider();
        }
        return ourInstance;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            RbenvGemsetReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RbenvGemsetReferenceProvider.$$$reportNull$$$0(1);
        }
        final ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)element.getProject());
        FileReferenceSet set = new FileReferenceSet(this, element.getText(), element, 0, this, true){

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return item -> {
                    String name = item.getName();
                    VirtualFile file = item.getVirtualFile();
                    if (RBENV_GEMSETS_COMPLETION_FILES_TO_IGNORE.contains(name)) {
                        return false;
                    }
                    if (item.isDirectory() && name.startsWith(".") && !FileTypeRegistry.getInstance().isFileIgnored(file)) {
                        return true;
                    }
                    return !projectFileIndex.isExcluded(file) && !projectFileIndex.isInContent(file);
                };
            }

            public boolean supportsExtendedCompletion() {
                return false;
            }
        };
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                RbenvGemsetReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                RbenvGemsetReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, psiFile -> {
            ArrayList<PsiDirectory> gemsets = new ArrayList<PsiDirectory>();
            VirtualFile moduleRoot = RModuleUtil.getInstance().getFirstContentRoot(module);
            if (moduleRoot == null) {
                return ContainerUtil.emptyList();
            }
            PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
            gemsets.add(psiManager.findDirectory(moduleRoot));
            VirtualFile gemsetsFolder = RbenvGemsetManager.getGemsetsFolder(sdk);
            if (gemsetsFolder != null) {
                gemsets.add(psiManager.findDirectory(gemsetsFolder));
            }
            return gemsets;
        });
        ArrayList<RbenvOptionReference> list = new ArrayList<RbenvOptionReference>();
        ContainerUtil.addAll(list, (Object[])set.getAllReferences());
        list.add(new RbenvOptionReference(element));
        PsiReference[] psiReferenceArray = list.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            RbenvGemsetReferenceProvider.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rbenv/gemsets/RbenvGemsetReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/gemsets/RbenvGemsetReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

