/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rbenv.gemsets;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvSdkData;

public final class RbenvGemsetManager {
    public static final String RBENV_GEMSETS_DIRECTORY_NAME = "gemsets";
    public static final String DOT_PREFIX = ".";
    public static final String RBENV_VERSION_ENV = "RBENV_VERSION";
    public static final String RBENV_GEMSETS_ENV = "RBENV_GEMSETS";
    public static final String GEMS_FOLDER = "gems";
    public static final String RBENV_GLOBAL_GEMSET = "global";
    public static final String RBENV_GLOBAL_GEMSET_DISABLED = "-global";
    public static final String BUNDLER_FOLDER = "bundler";
    public static final Object RBENV_GEMSETS_CONFIG_REQUESTOR = new Object();
    public static final AtomicClearableLazyValue<Boolean> RBENV_PLUGIN_INSTALLED = new AtomicClearableLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            Boolean bl = RbenvGemsetManager.isRbenvGemsetsPluginEnabled();
            if (bl == null) {
                1.$$$reportNull$$$0(0);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/version/management/rbenv/gemsets/RbenvGemsetManager$1", "compute"));
        }
    };
    @NonNls
    static final String RBENV_GEMSETS_FILE_NAME = ".rbenv-gemsets";
    private static final Logger LOG = Logger.getInstance(RbenvGemsetManager.class);
    private static final String RBENV_SHIMS_PATH = ".rbenv/shims/";
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Rbenv Gemset Manager Executor", (int)1);

    private RbenvGemsetManager() {
    }

    public static void createGemset(@NotNull Sdk sdk, @Nullable Module module, @Nullable Project project, @NotNull String gemset, @NotNull String version) {
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(0);
        }
        if (gemset == null) {
            RbenvGemsetManager.$$$reportNull$$$0(1);
        }
        if (version == null) {
            RbenvGemsetManager.$$$reportNull$$$0(2);
        }
        RubyRunner runner = RunnerUtil.getRunner(sdk, module);
        String rbenvExecutable = OSAgnosticPathUtil.expandUserHome((String)RbenvSdkData.notNullFrom(sdk).getVersionManagerPath());
        try {
            runner.execute((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdk, rbenvExecutable, "gemset", "create", version, gemset).withProject(project)).withPatchWithVersionManager(false).inSameThread(Registry.intValue((String)"command.line.execution.timeout")));
        }
        catch (ExecutionException e) {
            LOG.error(e.getMessage());
        }
    }

    @Nullable
    public static Sdk getGemsetSdk(@NotNull Sdk sdk, @NotNull String gemset) {
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(3);
        }
        if (gemset == null) {
            RbenvGemsetManager.$$$reportNull$$$0(4);
        }
        List sdks = ContainerUtil.filter(RbenvGemsetManager.getGemsetsSdk(sdk), gemsetSdk -> gemset.equals(RbenvGemsetManager.getRbenvGemset(gemsetSdk)));
        return (Sdk)ContainerUtil.getOnlyItem((Collection)sdks);
    }

    @Nullable
    public static String getGemsetSdkVersion(@NotNull Sdk sdk) {
        VirtualFile sdkVersionDirectory;
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(5);
        }
        if ((sdkVersionDirectory = RbenvGemsetManager.getSdkHomeDirectory(sdk)) == null) {
            return null;
        }
        return sdkVersionDirectory.getName();
    }

    public static void addRbenvLocalGemsetsExcludedFolders(@NotNull Module module, @Nullable Sdk sdk, @NotNull ContentEntry contentEntry) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(6);
        }
        if (contentEntry == null) {
            RbenvGemsetManager.$$$reportNull$$$0(7);
        }
        if (!RbenvGemsetManager.useRbenvGemsets(module, sdk)) {
            return;
        }
        for (VirtualFile gemset : RbenvGemsetManager.getLocalGemsetFolders(module, sdk)) {
            contentEntry.addExcludeFolder(gemset.getUrl());
        }
    }

    public static boolean useRbenvGemsets(@Nullable Module module, @Nullable Sdk sdk) {
        return module != null && RbenvGemsetManager.isRbenvSdk(sdk) && RbenvGemsetManager.getConfigVirtualFile(module) != null;
    }

    @Nullable
    public static VirtualFile createLocalGemset(@NotNull Module module, final @NotNull String localGemsetName) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(8);
        }
        if (localGemsetName == null) {
            RbenvGemsetManager.$$$reportNull$$$0(9);
        }
        for (final VirtualFile file : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            try {
                VirtualFile localGemsetDirectory = (VirtualFile)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

                    public VirtualFile compute() throws IOException {
                        return file.createChildDirectory((Object)this, localGemsetName);
                    }
                });
                if (localGemsetDirectory == null) continue;
                return localGemsetDirectory;
            }
            catch (IOException e) {
                LOG.error("Cannot create local gemset " + file.getPath() + "; " + e.getMessage());
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile createRbenvGemsetConfig(@NotNull Module module) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(10);
        }
        for (final VirtualFile file : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            try {
                VirtualFile configFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

                    public VirtualFile compute() throws IOException {
                        return file.createChildData((Object)this, RbenvGemsetManager.RBENV_GEMSETS_FILE_NAME);
                    }
                });
                if (configFile == null) continue;
                return configFile;
            }
            catch (IOException e) {
                LOG.error("Cannot create .rbenv-gemsets file under " + file.getPath());
                return null;
            }
        }
        return null;
    }

    public static boolean isRbenvGemsetConfig(@NotNull Module module, @NotNull VirtualFile file) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(11);
        }
        if (file == null) {
            RbenvGemsetManager.$$$reportNull$$$0(12);
        }
        return file.equals(RbenvGemsetManager.getConfigVirtualFile(module));
    }

    @RequiresReadLock
    @Nullable
    public static PsiFile getRbenvGemsetConfig(@NotNull Module module) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.softAssertReadAccess();
        VirtualFile configVirtualFile = RbenvGemsetManager.getConfigVirtualFile(module);
        if (configVirtualFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)module.getProject()).findFile(configVirtualFile);
    }

    @Nullable
    public static VirtualFile getConfigVirtualFile(@NotNull Module module) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(14);
        }
        if (module.isDisposed()) {
            return null;
        }
        VirtualFile config = null;
        for (VirtualFile file : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            VirtualFile child = file.findChild(RBENV_GEMSETS_FILE_NAME);
            if (child != null) {
                config = child;
                break;
            }
            child = file.findChild(".ruby-gemset");
            if (child == null) continue;
            config = child;
            break;
        }
        return config;
    }

    @NotNull
    public static List<String> getRbenvGemsetNames(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(15);
        }
        List list = ContainerUtil.map((Object[])RbenvGemsetManager.getRbenvGemsets(sdk), VirtualFile::getName);
        if (list == null) {
            RbenvGemsetManager.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static VirtualFile @NotNull [] getRbenvGemsets(@NotNull Sdk sdk) {
        VirtualFile gemsetsFolder;
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(17);
        }
        if ((gemsetsFolder = RbenvGemsetManager.getGemsetsFolder(sdk)) == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                RbenvGemsetManager.$$$reportNull$$$0(18);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] virtualFileArray = ContainerUtil.filter((Object[])gemsetsFolder.getChildren(), VirtualFile::isDirectory).toArray(VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            RbenvGemsetManager.$$$reportNull$$$0(19);
        }
        return virtualFileArray;
    }

    @Nullable
    public static VirtualFile getGemsetsFolder(@NotNull Sdk sdk) {
        VirtualFile sdkHome;
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(20);
        }
        if ((sdkHome = RbenvGemsetManager.getSdkHomeDirectory(sdk)) == null) {
            return null;
        }
        return sdkHome.findChild(RBENV_GEMSETS_DIRECTORY_NAME);
    }

    @Nullable
    private static VirtualFile getSdkHomeDirectory(@NotNull Sdk sdk) {
        String sdkHomePath;
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(21);
        }
        if ((sdkHomePath = RbenvGemsetManager.getSdkHomePath(sdk)) == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(VirtualFileManager.constructUrl((String)(ApplicationManager.getApplication().isUnitTestMode() ? "temp" : "file"), (String)sdkHomePath));
    }

    @Nullable
    private static String getSdkHomePath(@NotNull Sdk sdk) {
        String sdkHomeDirectory;
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(22);
        }
        if ((sdkHomeDirectory = sdk.getHomePath()) == null) {
            return null;
        }
        String homeDirectoryParent = new File(sdkHomeDirectory).getParent();
        if (homeDirectoryParent == null) {
            return null;
        }
        return new File(homeDirectoryParent).getParent();
    }

    private static @Unmodifiable @NotNull Set<VirtualFile> getLocalGemsetsFolders(Module module, @NotNull String text) {
        if (text == null) {
            RbenvGemsetManager.$$$reportNull$$$0(23);
        }
        List<String> gemsets = RbenvGemsetManager.getRbenvConfiguredGemsets(text);
        gemsets.remove(RBENV_GLOBAL_GEMSET_DISABLED);
        gemsets.remove(RBENV_GLOBAL_GEMSET);
        Set set = ContainerUtil.map2SetNotNull(gemsets, gemsetName -> RbenvGemsetManager.getLocalGemsetFolder(module, gemsetName));
        if (set == null) {
            RbenvGemsetManager.$$$reportNull$$$0(24);
        }
        return set;
    }

    @NotNull
    public static List<String> getLocalGemsets(@NotNull Module module, @Nullable Sdk sdk) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(25);
        }
        List<String> gemsets = RbenvGemsetManager.getCommandLineRbenvGemsets(module, sdk);
        gemsets.remove(RBENV_GLOBAL_GEMSET);
        return RbenvGemsetManager.filterLocalGemsets(gemsets);
    }

    @NotNull
    public static List<String> filterLocalGemsets(@NotNull Collection<String> gemsets) {
        if (gemsets == null) {
            RbenvGemsetManager.$$$reportNull$$$0(26);
        }
        List list = ContainerUtil.filter(gemsets, RbenvGemsetManager::isLocalGemset);
        if (list == null) {
            RbenvGemsetManager.$$$reportNull$$$0(27);
        }
        return list;
    }

    private static boolean isLocalGemset(String gemset) {
        return gemset.startsWith(DOT_PREFIX);
    }

    @NotNull
    public static List<String> getCommandLineRbenvGemsets(@NotNull Module module, Sdk sdk) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(28);
        }
        List<String> gemsets = RbenvGemsetManager.getRbenvConfiguredGemsets(module, sdk);
        gemsets.remove(RBENV_GLOBAL_GEMSET_DISABLED);
        List<String> list = gemsets;
        if (list == null) {
            RbenvGemsetManager.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public static List<String> getCurrentGemsetsOnly(@NotNull Module module) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(30);
        }
        List<String> gemsets = RbenvGemsetManager.getRbenvCurrentGemsets(module);
        gemsets.remove(RBENV_GLOBAL_GEMSET_DISABLED);
        gemsets.remove(RBENV_GLOBAL_GEMSET);
        List<String> list = gemsets;
        if (list == null) {
            RbenvGemsetManager.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public static List<String> getRbenvCurrentGemsets(@Nullable Module module) {
        if (module == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RbenvGemsetManager.$$$reportNull$$$0(32);
            }
            return list;
        }
        PsiFile config = (PsiFile)ReadAction.nonBlocking(() -> RbenvGemsetManager.getRbenvGemsetConfig(module)).executeSynchronously();
        if (config == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                RbenvGemsetManager.$$$reportNull$$$0(33);
            }
            return list;
        }
        return RbenvGemsetManager.getRbenvConfiguredGemsets((String)ReadAction.compute(() -> config.getText()));
    }

    @NotNull
    public static List<Sdk> getCurrentGemsetSdks(@NotNull Sdk sdk, @NotNull Module module) {
        Sdk rootSdk;
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(34);
        }
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(35);
        }
        if (!RbenvGemsetManager.isRbenvSdk(sdk)) {
            List<Sdk> list = List.of(sdk);
            if (list == null) {
                RbenvGemsetManager.$$$reportNull$$$0(36);
            }
            return list;
        }
        Sdk sdk2 = rootSdk = RbenvGemsetManager.isGemsetSdk(sdk) ? RbenvGemsetManager.findRootRbenvSdk(sdk) : sdk;
        if (rootSdk == null) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                RbenvGemsetManager.$$$reportNull$$$0(37);
            }
            return list;
        }
        ArrayList<Sdk> sdks = new ArrayList<Sdk>(List.of(rootSdk));
        for (Sdk gemsetSdk : ContainerUtil.mapNotNull(RbenvGemsetManager.getRbenvCurrentGemsets(module), it -> RbenvGemsetManager.getGemsetSdk(rootSdk, it))) {
            if (!RbenvGemsetManager.isGemsetOfSdk(rootSdk, gemsetSdk)) continue;
            sdks.add(gemsetSdk);
        }
        List<Sdk> list = Collections.unmodifiableList(sdks);
        if (list == null) {
            RbenvGemsetManager.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    public static List<String> getRbenvConfiguredGemsets(@NotNull Module module, @Nullable Sdk sdk) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(39);
        }
        if (!RbenvGemsetManager.useRbenvGemsets(module, sdk)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RbenvGemsetManager.$$$reportNull$$$0(40);
            }
            return list;
        }
        String text = RbenvGemsetManager.getConfigText(module);
        if (text == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RbenvGemsetManager.$$$reportNull$$$0(41);
            }
            return list;
        }
        return RbenvGemsetManager.getRbenvConfiguredGemsets(text);
    }

    @Nullable
    public static String getConfigText(@NotNull Module module) {
        VirtualFile config;
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(42);
        }
        if ((config = RbenvGemsetManager.getConfigVirtualFile(module)) == null) {
            return null;
        }
        String text = "";
        try {
            text = VfsUtilCore.loadText((VirtualFile)config);
        }
        catch (IOException e) {
            LOG.error("Cannot read .rbenv-gemset(s) file (" + config.getPath() + "): " + e.getMessage());
        }
        return text;
    }

    @NotNull
    private static List<String> getRbenvConfiguredGemsets(@NotNull String text) {
        if (text == null) {
            RbenvGemsetManager.$$$reportNull$$$0(43);
        }
        if (!RbenvGemsetManager.hasGlobal((String)text) && !RbenvGemsetManager.hasGlobalDisabled((String)text)) {
            if (!((String)text).isEmpty()) {
                text = (String)text + "\n";
            }
            text = (String)text + RBENV_GLOBAL_GEMSET;
        }
        return new ArrayList<String>(ContainerUtil.filter((Object[])((String)text).split("[ \\n]"), gemset -> !gemset.isEmpty()));
    }

    @Nullable
    public static String getShimsCommandPath(@NotNull String command) {
        VirtualFile homeDir;
        if (command == null) {
            RbenvGemsetManager.$$$reportNull$$$0(44);
        }
        if ((homeDir = VfsUtil.getUserHomeDir()) == null) {
            return null;
        }
        VirtualFile rubyShims = homeDir.findFileByRelativePath(RBENV_SHIMS_PATH + command);
        return rubyShims == null ? null : rubyShims.getPath();
    }

    @Contract(value="null -> false")
    public static boolean isRbenvSdk(@Nullable Sdk sdk) {
        if (sdk == null) {
            return false;
        }
        return RbenvGemsetManager.isRbenvSdkPath(sdk.getHomePath());
    }

    public static boolean isLocalRbenvSdk(@Nullable Sdk sdk) {
        return RbenvGemsetManager.isRbenvSdk(sdk) && !RubyRemoteInterpreterManager.isRemoteSdk(sdk);
    }

    public static boolean isGemsetOfSdk(@NotNull Sdk rootSdk, @NotNull Sdk gemset) {
        if (rootSdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(45);
        }
        if (gemset == null) {
            RbenvGemsetManager.$$$reportNull$$$0(46);
        }
        return RbenvGemsetManager.isRbenvSdk(rootSdk) && RbenvGemsetManager.isRootRbenvSdk(rootSdk) && RbenvGemsetManager.getGemsetsSdk(rootSdk).contains(gemset);
    }

    public static boolean isGemsetSdk(@Nullable Sdk sdk) {
        return RbenvGemsetManager.getRbenvGemset(sdk) != null;
    }

    public static boolean isGemsetSdk(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RbenvGemsetManager.$$$reportNull$$$0(47);
        }
        return sdkInfo.getGemSet() != null;
    }

    @Contract(value="null -> false")
    public static boolean isRbenvSdkPath(@Nullable String path) {
        return path != null && path.contains("rbenv");
    }

    public static void applyRbenvGemsetsToConfig(@NotNull Module module, Collection<String> gemsetNames) {
        VirtualFile config;
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(48);
        }
        VirtualFile configVirtualFile = RbenvGemsetManager.getConfigVirtualFile(module);
        if (gemsetNames.isEmpty() && configVirtualFile == null) {
            return;
        }
        VirtualFile virtualFile = config = configVirtualFile != null ? configVirtualFile : RbenvGemsetManager.createRbenvGemsetConfig(module);
        if (config == null) {
            return;
        }
        VirtualFile finalConfig = config;
        try {
            String configText = VfsUtilCore.loadText((VirtualFile)finalConfig);
            ArrayList<String> gemsets = new ArrayList<String>(gemsetNames);
            if (!gemsets.contains(RBENV_GLOBAL_GEMSET)) {
                gemsets.add(RBENV_GLOBAL_GEMSET_DISABLED);
            }
            if (gemsets.contains(RBENV_GLOBAL_GEMSET) && !RbenvGemsetManager.hasGlobal(configText)) {
                gemsets.remove(RBENV_GLOBAL_GEMSET);
            }
            String gemsetsText = StringUtil.join(gemsets, (String)"\n");
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    finalConfig.setBinaryContent(gemsetsText.getBytes(finalConfig.getCharset()), -1L, -1L, RBENV_GEMSETS_CONFIG_REQUESTOR);
                }
                catch (IOException e) {
                    LOG.error("Cannot apply selected gemsets " + gemsetsText + " to the config file " + finalConfig.getPath());
                }
            });
        }
        catch (IOException e) {
            LOG.warn("Cannot read .rbenv-gemsets; " + e.getMessage());
        }
    }

    private static boolean hasGlobal(@NotNull String configText) {
        if (configText == null) {
            RbenvGemsetManager.$$$reportNull$$$0(49);
        }
        return ArrayUtil.contains((String)RBENV_GLOBAL_GEMSET, (String[])configText.split("[ \\n]"));
    }

    public static boolean hasGlobalDisabled(@NotNull Module module) {
        String configText;
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(50);
        }
        return (configText = RbenvGemsetManager.getConfigText(module)) == null || RbenvGemsetManager.hasGlobalDisabled(configText);
    }

    private static boolean hasGlobalDisabled(@NotNull String configText) {
        if (configText == null) {
            RbenvGemsetManager.$$$reportNull$$$0(51);
        }
        return ArrayUtil.contains((String)RBENV_GLOBAL_GEMSET_DISABLED, (String[])configText.split("[ \\n]"));
    }

    public static boolean isGlobalGemsetSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(52);
        }
        return RBENV_GLOBAL_GEMSET.equals(RbenvGemsetManager.getRbenvGemset(sdk));
    }

    @Contract(value="null -> null")
    @Nullable
    public static String getRbenvGemset(@Nullable Sdk sdk) {
        RbenvSdkData rbenvSdkAdditionalData = RbenvSdkData.from(sdk);
        return rbenvSdkAdditionalData == null ? null : rbenvSdkAdditionalData.getGemsetName();
    }

    @Nullable
    public static Sdk findRootRbenvSdk(@NotNull Sdk gemsetOrRootSdk) {
        if (gemsetOrRootSdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(53);
        }
        return RbenvGemsetManager.findRootRbenvSdk(RubySdkUtil.getAllRubySdks(), gemsetOrRootSdk);
    }

    @Nullable
    public static Sdk findRootRbenvSdk(@NotNull Collection<? extends Sdk> sdks, @NotNull Sdk gemsetOrRootSdk) {
        if (sdks == null) {
            RbenvGemsetManager.$$$reportNull$$$0(54);
        }
        if (gemsetOrRootSdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(55);
        }
        return (Sdk)ContainerUtil.find(sdks, sdk -> RbenvGemsetManager.isRbenvSdk(sdk) && !RbenvGemsetManager.isGemsetSdk(sdk) && Objects.equals(sdk.getHomePath(), gemsetOrRootSdk.getHomePath()));
    }

    @Nullable
    public static Sdk findRootRbenvSdk(@NotNull String version) {
        if (version == null) {
            RbenvGemsetManager.$$$reportNull$$$0(56);
        }
        return (Sdk)ContainerUtil.find(RubySdkUtil.getAllRubySdks(), sdk -> RbenvGemsetManager.isRbenvSdk(sdk) && !RbenvGemsetManager.isGemsetSdk(sdk) && Objects.equals(version, RbenvGemsetManager.getSdkVersion(sdk)));
    }

    public static boolean isRootRbenvSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(57);
        }
        return RubySdkUtil.equalSdks(RbenvGemsetManager.findRootRbenvSdk(sdk), sdk);
    }

    @Nullable
    public static String fetchGemGemset(@NotNull GemInfo gemInfo) {
        int gemsetsFolderIndex;
        if (gemInfo == null) {
            RbenvGemsetManager.$$$reportNull$$$0(58);
        }
        if ((gemsetsFolderIndex = gemInfo.getUrl().indexOf(RBENV_GEMSETS_DIRECTORY_NAME)) == -1) {
            return null;
        }
        String gemsetWithTail = StringUtil.substringAfter((String)gemInfo.getUrl(), (String)"gemsets/");
        if (gemsetWithTail == null) {
            return null;
        }
        return gemsetWithTail.substring(0, gemsetWithTail.indexOf("/"));
    }

    public static void refreshGemsetFolder(@NotNull Sdk rootSdk, @NotNull String gemset) {
        VirtualFile sdkHome;
        if (rootSdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(59);
        }
        if (gemset == null) {
            RbenvGemsetManager.$$$reportNull$$$0(60);
        }
        if ((sdkHome = RbenvGemsetManager.getSdkHomeDirectory(rootSdk)) == null) {
            return;
        }
        VirtualFileManager.getInstance().refreshAndFindFileByUrl(sdkHome.getUrl() + File.separator + RBENV_GEMSETS_DIRECTORY_NAME + File.separator + gemset);
    }

    public static boolean hasGemset(@NotNull Sdk rootSdk, @NotNull String gemset) {
        VirtualFile gemsetsFolder;
        if (rootSdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(61);
        }
        if (gemset == null) {
            RbenvGemsetManager.$$$reportNull$$$0(62);
        }
        return (gemsetsFolder = RbenvGemsetManager.getGemsetsFolder(rootSdk)) != null && gemsetsFolder.findChild(gemset) != null;
    }

    public static boolean hasLocalGemset(@NotNull Module module, @NotNull String gemset) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(63);
        }
        if (gemset == null) {
            RbenvGemsetManager.$$$reportNull$$$0(64);
        }
        return RbenvGemsetManager.getLocalGemsetFolder(module, gemset) != null;
    }

    @NotNull
    public static List<Sdk> getGemsetsSdk(@NotNull Sdk rootSdk) {
        String rootHomePath;
        if (rootSdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(65);
        }
        if ((rootHomePath = rootSdk.getHomePath()) == null) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                RbenvGemsetManager.$$$reportNull$$$0(66);
            }
            return list;
        }
        List list = ContainerUtil.filter(RubySdkUtil.getAllRubySdks(), it -> RbenvGemsetManager.isGemsetSdk(it) && Objects.equals(it.getHomePath(), rootHomePath));
        if (list == null) {
            RbenvGemsetManager.$$$reportNull$$$0(67);
        }
        return list;
    }

    @NotNull
    public static List<Sdk> getConfiguredGemsetSdks(@NotNull Sdk rootSdk, Collection<String> gemsets) {
        if (rootSdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(68);
        }
        List<Sdk> gemsetSdks = RbenvGemsetManager.getGemsetsSdk(rootSdk);
        List list = ContainerUtil.filter(gemsetSdks, sdk -> !ContainerUtil.filter((Collection)gemsets, configuredGemset -> configuredGemset.equals(RbenvGemsetManager.getRbenvGemset(sdk))).isEmpty());
        if (list == null) {
            RbenvGemsetManager.$$$reportNull$$$0(69);
        }
        return list;
    }

    @Nullable
    public static String getSdkVersion(@NotNull Sdk sdk) {
        VirtualFile sdkHome;
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(70);
        }
        if ((sdkHome = sdk.getHomeDirectory()) == null) {
            return null;
        }
        VirtualFile bin = sdkHome.getParent();
        if (bin == null) {
            return null;
        }
        VirtualFile version = bin.getParent();
        if (version == null) {
            return null;
        }
        return version.getName();
    }

    public static void refreshAttachedGemsetSdks(@NotNull Module module) {
        Sdk sdk;
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(71);
        }
        if (!RbenvGemsetManager.isRbenvSdk(sdk = RModuleUtil.getInstance().findRubySdkForModule(module))) {
            return;
        }
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        RubySdkGemLibraryManager.getInstance().refreshRoots(sdk, !isUnitTestMode);
        for (Sdk gemsetSdk : RbenvGemsetManager.getConfiguredGemsetSdks(sdk, RbenvGemsetManager.getRbenvConfiguredGemsets(module, sdk))) {
            RubySdkGemLibraryManager.getInstance().refreshRoots(gemsetSdk, !isUnitTestMode);
        }
    }

    @NotNull
    public static Collection<String> getGemsetGemsURLs(@NotNull Sdk sdk) {
        String gemset;
        if (sdk == null) {
            RbenvGemsetManager.$$$reportNull$$$0(72);
        }
        if ((gemset = RbenvGemsetManager.getRbenvGemset(sdk)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                RbenvGemsetManager.$$$reportNull$$$0(73);
            }
            return list;
        }
        VirtualFile gemsetDirectory = (VirtualFile)ContainerUtil.find((Object[])RbenvGemsetManager.getRbenvGemsets(sdk), file -> gemset.equals(file.getName()));
        if (gemsetDirectory == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                RbenvGemsetManager.$$$reportNull$$$0(74);
            }
            return list;
        }
        return new SmartList((Object[])new String[]{gemsetDirectory.getUrl() + File.separator + GEMS_FOLDER, gemsetDirectory.getUrl() + File.separator + BUNDLER_FOLDER + File.separator + GEMS_FOLDER});
    }

    @NotNull
    public static List<VirtualFile> getLocalGemsetFolders(@NotNull Module module, @Nullable Sdk sdk) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(75);
        }
        List<String> actualConfiguredGemsets = RbenvGemsetManager.getLocalGemsets(module, sdk);
        List list = ContainerUtil.mapNotNull(actualConfiguredGemsets, gemsetName -> {
            if (gemsetName.startsWith(DOT_PREFIX)) {
                return RbenvGemsetManager.getLocalGemsetFolder(module, gemsetName);
            }
            return null;
        });
        if (list == null) {
            RbenvGemsetManager.$$$reportNull$$$0(76);
        }
        return list;
    }

    @Nullable
    public static VirtualFile getLocalGemsetFolder(@NotNull Module module, @NotNull String localGemsetName) {
        VirtualFile file;
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(77);
        }
        if (localGemsetName == null) {
            RbenvGemsetManager.$$$reportNull$$$0(78);
        }
        if (!RbenvGemsetManager.isLocalGemset(localGemsetName)) {
            return null;
        }
        RailsApp app = RailsApp.fromModule(module);
        if (app != null && (file = app.getRailsApplicationRoot()) != null) {
            return file.findChild(localGemsetName);
        }
        if (module.isDisposed()) {
            return null;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            VirtualFile dir = root.findFileByRelativePath(localGemsetName);
            if (dir == null) continue;
            return dir;
        }
        return null;
    }

    public static void excludeLocalGemsets(@NotNull Module module) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(79);
        }
        ReadAction.nonBlocking(() -> {
            PsiFile rbenvGemsetConfig = RbenvGemsetManager.getRbenvGemsetConfig(module);
            if (rbenvGemsetConfig == null) {
                return Collections.emptyList();
            }
            Set<VirtualFile> localGemsetDirectories = RbenvGemsetManager.getLocalGemsetsFolders(module, rbenvGemsetConfig.getText());
            return ContainerUtil.mapNotNull(localGemsetDirectories, localGemsetDirectory -> {
                VirtualFile contentRoot = RbenvGemsetManager.getContentRootForGemsetDirectory(module, localGemsetDirectory);
                if (contentRoot == null) {
                    return null;
                }
                return new Pair(localGemsetDirectory, (Object)contentRoot);
            });
        }).expireWhen(() -> ((Module)module).isDisposed()).finishOnUiThread(ModalityState.defaultModalityState(), pairs -> {
            for (Pair pair : pairs) {
                VirtualFile gemsetDirectory = (VirtualFile)pair.first;
                VirtualFile contentRoot = (VirtualFile)pair.second;
                RbenvGemsetManager.excludeDirectoryFromModule(module, gemsetDirectory, contentRoot);
            }
        }).coalesceBy(new Object[]{module, RbenvGemsetManager.class}).submit((Executor)ourExecutor);
    }

    public static void excludeAndUpdateLocalGemset(@NotNull Module module, @NotNull VirtualFile gemsetDirectory) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(80);
        }
        if (gemsetDirectory == null) {
            RbenvGemsetManager.$$$reportNull$$$0(81);
        }
        ReadAction.nonBlocking(() -> RbenvGemsetManager.getContentRootForGemsetDirectory(module, gemsetDirectory)).expireWhen(() -> ((Module)module).isDisposed()).finishOnUiThread(ModalityState.defaultModalityState(), contentRoot -> {
            if (contentRoot == null) {
                return;
            }
            boolean isDirectoryExcluded = RbenvGemsetManager.excludeDirectoryFromModule(module, gemsetDirectory, contentRoot);
            if (!isDirectoryExcluded) {
                return;
            }
            RubySdkGemLibraryManager.getInstance().refresh();
        }).submit((Executor)ourExecutor);
    }

    @RequiresReadLock
    @Nullable
    private static VirtualFile getContentRootForGemsetDirectory(@NotNull Module module, @NotNull VirtualFile gemsetDirectory) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(82);
        }
        if (gemsetDirectory == null) {
            RbenvGemsetManager.$$$reportNull$$$0(83);
        }
        ThreadingAssertions.softAssertReadAccess();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        if (fileIndex.isExcluded(gemsetDirectory)) {
            return null;
        }
        return fileIndex.getContentRootForFile(gemsetDirectory);
    }

    @RequiresEdt
    private static boolean excludeDirectoryFromModule(@NotNull Module module, @NotNull VirtualFile gemsetDirectory, @NotNull VirtualFile contentRoot) {
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(84);
        }
        if (gemsetDirectory == null) {
            RbenvGemsetManager.$$$reportNull$$$0(85);
        }
        if (contentRoot == null) {
            RbenvGemsetManager.$$$reportNull$$$0(86);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return (Boolean)WriteAction.compute(() -> {
            if (module.isDisposed() || !gemsetDirectory.isValid() || !contentRoot.isValid()) {
                return false;
            }
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            try {
                for (ContentEntry entry : modifiableModel.getContentEntries()) {
                    if (!StringUtil.equals((CharSequence)contentRoot.getUrl(), (CharSequence)entry.getUrl())) continue;
                    entry.addExcludeFolder(gemsetDirectory);
                    modifiableModel.commit();
                    Boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (!modifiableModel.isDisposed()) {
                    modifiableModel.dispose();
                }
            }
            return false;
        });
    }

    public static void saveConfigFile(@NotNull Module module) {
        VirtualFile config;
        if (module == null) {
            RbenvGemsetManager.$$$reportNull$$$0(87);
        }
        if ((config = RbenvGemsetManager.getConfigVirtualFile(module)) == null) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(config);
        if (document == null) {
            return;
        }
        FileDocumentManager.getInstance().saveDocument(document);
    }

    private static boolean isRbenvGemsetsPluginEnabled() {
        return FileUtil.exists((String)OSAgnosticPathUtil.expandUserHome((String)"~/.rbenv/plugins/rbenv-gemset")) || FileUtil.exists((String)"/usr/local/bin/rbenv-gemset");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 18, 19, 24, 27, 29, 31, 32, 33, 36, 37, 38, 40, 41, 66, 67, 69, 73, 74, 76 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 4: 
            case 46: 
            case 60: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemset";
                break;
            }
            case 2: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 25: 
            case 28: 
            case 30: 
            case 35: 
            case 39: 
            case 42: 
            case 48: 
            case 50: 
            case 63: 
            case 71: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 82: 
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 9: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localGemsetName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 66: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rbenv/gemsets/RbenvGemsetManager";
                break;
            }
            case 23: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = RBENV_GEMSETS_DIRECTORY_NAME;
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 45: 
            case 59: 
            case 61: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSdk";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configText";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsetOrRootSdk";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemInfo";
                break;
            }
            case 81: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsetDirectory";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/gemsets/RbenvGemsetManager";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvGemsetNames";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvGemsets";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemsetsFolders";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLocalGemsets";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineRbenvGemsets";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentGemsetsOnly";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvCurrentGemsets";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentGemsetSdks";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvConfiguredGemsets";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsetsSdk";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredGemsetSdks";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsetGemsURLs";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemsetFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGemset";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetSdk";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetSdkVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRbenvLocalGemsetsExcludedFolders";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLocalGemset";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRbenvGemsetConfig";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isRbenvGemsetConfig";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvGemsetConfig";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConfigVirtualFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvGemsetNames";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 66: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 76: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvGemsets";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetsFolder";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSdkHomeDirectory";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSdkHomePath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemsetsFolders";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemsets";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "filterLocalGemsets";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCommandLineRbenvGemsets";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentGemsetsOnly";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentGemsetSdks";
                break;
            }
            case 39: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvConfiguredGemsets";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getConfigText";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getShimsCommandPath";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isGemsetOfSdk";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isGemsetSdk";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "applyRbenvGemsetsToConfig";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "hasGlobal";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "hasGlobalDisabled";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalGemsetSdk";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findRootRbenvSdk";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isRootRbenvSdk";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "fetchGemGemset";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "refreshGemsetFolder";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "hasGemset";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "hasLocalGemset";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetsSdk";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredGemsetSdks";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getSdkVersion";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "refreshAttachedGemsetSdks";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetGemsURLs";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemsetFolders";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemsetFolder";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "excludeLocalGemsets";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "excludeAndUpdateLocalGemset";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootForGemsetDirectory";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "excludeDirectoryFromModule";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "saveConfigFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 18, 19, 24, 27, 29, 31, 32, 33, 36, 37, 38, 40, 41, 66, 67, 69, 73, 74, 76 -> new IllegalStateException(string);
        };
    }
}

