/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rbenv;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.version.management.GemsetSupporter;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkDataBase;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvVersionManagerHandler;

public class RbenvSdkData
extends RubyVersionManagerSdkDataBase<RbenvSdkData>
implements GemsetSupporter<RbenvSdkData> {
    @OptionTag(value="gemset-name")
    @Nullable
    private String myGemsetName;

    public RbenvSdkData(@NotNull RbenvVersionManagerHandler handler) {
        if (handler == null) {
            RbenvSdkData.$$$reportNull$$$0(0);
        }
        super(handler);
    }

    @Override
    @Nullable
    public String getGemsetName() {
        return this.myGemsetName;
    }

    @Override
    @NotNull
    public RbenvSdkData withGemsetName(@Nullable String gemsetName) {
        this.assertWritable();
        this.myGemsetName = gemsetName;
        RbenvSdkData rbenvSdkData = this.self();
        if (rbenvSdkData == null) {
            RbenvSdkData.$$$reportNull$$$0(1);
        }
        return rbenvSdkData;
    }

    @Override
    @NotNull
    protected RbenvSdkData copyTo(@NotNull RbenvSdkData target) {
        if (target == null) {
            RbenvSdkData.$$$reportNull$$$0(2);
        }
        RbenvSdkData rbenvSdkData = super.copyTo(target).withGemsetName(this.getGemsetName());
        if (rbenvSdkData == null) {
            RbenvSdkData.$$$reportNull$$$0(3);
        }
        return rbenvSdkData;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = "Rbenv sdk, gemset " + this.getGemsetName();
        if (string == null) {
            RbenvSdkData.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected RbenvSdkData self() {
        RbenvSdkData rbenvSdkData = this;
        if (rbenvSdkData == null) {
            RbenvSdkData.$$$reportNull$$$0(5);
        }
        return rbenvSdkData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RbenvSdkData data = (RbenvSdkData)o;
        return !(this.myGemsetName != null ? !this.myGemsetName.equals(data.myGemsetName) : data.myGemsetName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myGemsetName != null ? this.myGemsetName.hashCode() : 0);
        return result;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static RbenvSdkData from(@Nullable Sdk sdk) {
        return (RbenvSdkData)ObjectUtils.tryCast((Object)RubyVersionManagerSdkData.from(sdk), RbenvSdkData.class);
    }

    @Contract(pure=true)
    @NotNull
    public static RbenvSdkData notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbenvSdkData.$$$reportNull$$$0(6);
        }
        RbenvSdkData rbenvSdkData = Objects.requireNonNull(RbenvSdkData.from(sdk), () -> "Failed to extract from " + String.valueOf(sdk));
        if (rbenvSdkData == null) {
            RbenvSdkData.$$$reportNull$$$0(7);
        }
        return rbenvSdkData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withGemsetName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "self";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

