/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.notification.problem;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.version.management.notification.action.ModuleAction;
import org.jetbrains.plugins.ruby.version.management.notification.action.SwitchAction;
import org.jetbrains.plugins.ruby.version.management.notification.problem.ModuleSdkProblem;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/ruby/version/management/notification/problem/SuitableSdkNotSelectedProblem;", "Lorg/jetbrains/plugins/ruby/version/management/notification/problem/ModuleSdkProblem;", "module", "Lcom/intellij/openapi/module/Module;", "currentSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "actions", "", "Lorg/jetbrains/plugins/ruby/version/management/notification/action/SwitchAction;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/util/List;)V", "getActions", "()Ljava/util/List;", "getDescription", "", "getBestAction", "Lorg/jetbrains/plugins/ruby/version/management/notification/action/ModuleAction;", "toString", "intellij.ruby.backend"})
public final class SuitableSdkNotSelectedProblem
extends ModuleSdkProblem {
    @NotNull
    private final List<SwitchAction> actions;

    public SuitableSdkNotSelectedProblem(@NotNull Module module, @Nullable Sdk currentSdk, @NotNull List<SwitchAction> actions) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        super(module, currentSdk, actions);
        this.actions = CollectionsKt.sortedWith((Iterable)actions, (arg_0, arg_1) -> SuitableSdkNotSelectedProblem.actions$lambda$1(SuitableSdkNotSelectedProblem::actions$lambda$0, arg_0, arg_1));
    }

    @NotNull
    public List<SwitchAction> getActions() {
        return this.actions;
    }

    @Override
    @NotNull
    public String getDescription() {
        String suitableSdks = CollectionsKt.joinToString$default((Iterable)this.getActions(), null, null, null, (int)0, null, SuitableSdkNotSelectedProblem::getDescription$lambda$0, (int)31, null);
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.getModule().getName(), (String)"getName(...)");
        objectArray[1] = suitableSdks;
        return this.messageWithCurrentSdk("version.managers.module.should.be.using.one.of.but.is.using", "version.managers.module.should.be.using.one.of", objectArray);
    }

    @Override
    @Nullable
    public ModuleAction getBestAction() {
        return (ModuleAction)CollectionsKt.firstOrNull(this.getActions());
    }

    @NotNull
    public String toString() {
        return "SuitableSdkNotSelectedProblem(module=" + this.getModule() + ", currentSdk=" + this.getCurrentSdk() + ", actions=" + this.getActions() + ")";
    }

    private static final int actions$lambda$0(SwitchAction a, SwitchAction b) {
        return VersionComparatorUtil.compare((String)b.getSdkConfig().distName(), (String)a.getSdkConfig().distName());
    }

    private static final int actions$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final CharSequence getDescription$lambda$0(SwitchAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.append((HtmlChunk)HtmlChunk.text((String)it.getSuggestedSdk().getName()).wrapWith("b"));
        builder2.append(HtmlChunk.text((String)(" (" + it.getSdkConfig().source() + ")")));
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

