/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.mise;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkInstaller;
import org.jetbrains.plugins.ruby.version.management.mise.MiseSdkData;
import org.jetbrains.plugins.ruby.version.management.mise.MiseVersionManagerHandlerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H\u0016J\u001e\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0014J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0014JH\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u000bH\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/ruby/version/management/mise/MiseVersionManagerHandler;", "Lorg/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandlerBase;", "Lorg/jetbrains/plugins/ruby/version/management/mise/MiseSdkData;", "<init>", "()V", "createAdditionalData", "doLoadLegacy", "Lorg/jetbrains/plugins/ruby/version/management/RubyVersionManagerSdkData;", "rootElement", "Lorg/jdom/Element;", "interpreterPath", "", "getVersionManagerExecutableName", "getAvailableDistributionsCommands", "", "runner", "Lorg/jetbrains/plugins/ruby/ruby/run/RubyRunner;", "versionManagerPath", "processAvailableDistributionsOutput", "rawOutput", "patchCommands", "rubyRunner", "distributionId", "commandsToPatch", "env", "", "getStarterScriptName", "getInstallers", "", "Lorg/jetbrains/plugins/ruby/version/management/SdkInstaller;", "intellij.ruby.backend"})
public final class MiseVersionManagerHandler
extends RubyVersionManagerHandlerBase<MiseSdkData> {
    @Override
    @NotNull
    public MiseSdkData createAdditionalData() {
        return new MiseSdkData(this);
    }

    @Override
    @Nullable
    protected RubyVersionManagerSdkData<?> doLoadLegacy(@NotNull Element rootElement, @NotNull String interpreterPath) {
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        Intrinsics.checkNotNullParameter((Object)interpreterPath, (String)"interpreterPath");
        return null;
    }

    @Override
    @NotNull
    public String getVersionManagerExecutableName() {
        return "mise";
    }

    @Override
    @NotNull
    protected List<String> getAvailableDistributionsCommands(@NotNull RubyRunner runner, @NotNull String versionManagerPath) {
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)versionManagerPath, (String)"versionManagerPath");
        Object[] objectArray = new String[]{versionManagerPath, "ls", "--json", "--installed", "ruby"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    protected List<String> processAvailableDistributionsOutput(@NotNull List<String> rawOutput) {
        Intrinsics.checkNotNullParameter(rawOutput, (String)"rawOutput");
        String jsonRawText = CollectionsKt.joinToString$default((Iterable)rawOutput, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        JsonArray availableDistributionsJson = JsonElementKt.getJsonArray((JsonElement)Json.Default.parseToJsonElement(jsonRawText));
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)availableDistributionsJson)), MiseVersionManagerHandler::processAvailableDistributionsOutput$lambda$0));
    }

    @Override
    @NotNull
    protected List<String> patchCommands(@NotNull RubyRunner rubyRunner, @NotNull String versionManagerPath, @NotNull String distributionId, @NotNull List<String> commandsToPatch, @NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter((Object)rubyRunner, (String)"rubyRunner");
        Intrinsics.checkNotNullParameter((Object)versionManagerPath, (String)"versionManagerPath");
        Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
        Intrinsics.checkNotNullParameter(commandsToPatch, (String)"commandsToPatch");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Path misePath = Paths.get(versionManagerPath, new String[0]);
        Path path = misePath.getParent();
        if (path == null) {
            throw new NullPointerException(versionManagerPath + " is not valid path for mise version manager");
        }
        Path miseHomePath = path;
        List[] listArray = new List[3];
        Object[] objectArray = new String[]{"declare", "mise_home_path=" + miseHomePath};
        listArray[0] = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"export", "PATH=$PATH:$mise_home_path"};
        listArray[1] = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{versionManagerPath, "exec", "--quiet", "ruby@" + distributionId, "--"};
        listArray[2] = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)commandsToPatch);
        List<String> list = rubyRunner.getCommandsSequence(listArray);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCommandsSequence(...)");
        return list;
    }

    @Override
    @NotNull
    protected String getStarterScriptName() {
        return "mise_starter.sh";
    }

    @Override
    @NotNull
    public Collection<SdkInstaller> getInstallers() {
        return MiseVersionManagerHandlerKt.access$getSDK_INSTALLERS$p();
    }

    private static final String processAvailableDistributionsOutput$lambda$0(JsonElement item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        JsonObject itemObject = JsonElementKt.getJsonObject((JsonElement)item);
        Object object = (JsonElement)itemObject.get((Object)"version");
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
            return null;
        }
        Object version = object;
        return version;
    }
}

