/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.mise;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherVmBase;
import org.jetbrains.plugins.ruby.version.management.mise.MiseVersionManagerHandlerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0014J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0014J \u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0018\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/ruby/version/management/mise/MiseSdkRefresher;", "Lorg/jetbrains/plugins/ruby/version/management/SdkRefresherVmBase;", "<init>", "()V", "INSTALLATIONS_ROOT_PATH", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getVersionManagerHandler", "Lorg/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandlerBase;", "getPossibleVersionManagersPaths", "", "getInstallationsRootsPathNames", "getSdkInfosForInterpreterHome", "Ljava/util/stream/Stream;", "Lorg/jetbrains/plugins/ruby/version/management/RubySdkInfo;", "versionManagerPathName", "interpreterHome", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nMiseSdkRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiseSdkRefresher.kt\norg/jetbrains/plugins/ruby/version/management/mise/MiseSdkRefresher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1#2:41\n*E\n"})
public final class MiseSdkRefresher
extends SdkRefresherVmBase {
    @NotNull
    private final String INSTALLATIONS_ROOT_PATH;

    public MiseSdkRefresher() {
        String[] stringArray = new String[]{"~", ".local", "share", "mise", "installs", "ruby"};
        String string = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        this.INSTALLATIONS_ROOT_PATH = string;
    }

    @Override
    @NotNull
    public RubyVersionManagerHandlerBase<?> getVersionManagerHandler() {
        return MiseVersionManagerHandlerKt.getMiseHandlerInstance();
    }

    @Override
    @NotNull
    protected List<String> getPossibleVersionManagersPaths() {
        return CollectionsKt.listOf((Object)MiseVersionManagerHandlerKt.getMISE_BIN_PATH());
    }

    @Override
    @NotNull
    protected List<String> getInstallationsRootsPathNames() {
        String[] it;
        String string = "installs";
        String[] stringArray = new String[]{"ruby"};
        Path path = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Object object = SdkRefresherVmBase.getPathByEnvironmentVariable("MISE_DATA_DIR", path);
        if (object != null) {
            it = object;
            boolean bl = false;
            return CollectionsKt.listOf((Object)it.toString());
        }
        string = "mise";
        it = new String[]{"installs", "ruby"};
        Path path2 = Paths.get(string, Arrays.copyOf(it, it.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        object = SdkRefresherVmBase.getPathByEnvironmentVariable("XDG_DATA_HOME", path2);
        if (object != null) {
            it = object;
            boolean bl = false;
            return CollectionsKt.listOf((Object)it.toString());
        }
        return CollectionsKt.listOf((Object)this.INSTALLATIONS_ROOT_PATH);
    }

    @Override
    @NotNull
    protected Stream<? extends RubySdkInfo> getSdkInfosForInterpreterHome(@NotNull String versionManagerPathName, @NotNull VirtualFile interpreterHome) {
        Intrinsics.checkNotNullParameter((Object)versionManagerPathName, (String)"versionManagerPathName");
        Intrinsics.checkNotNullParameter((Object)interpreterHome, (String)"interpreterHome");
        if (interpreterHome.is(VFileProperty.SYMLINK)) {
            Stream stream = Stream.empty();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"empty(...)");
            return stream;
        }
        Stream<? extends RubySdkInfo> stream = super.getSdkInfosForInterpreterHome(versionManagerPathName, interpreterHome);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"getSdkInfosForInterpreterHome(...)");
        return stream;
    }
}

