/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RubyFileSystemUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;
import org.jetbrains.plugins.ruby.version.management.AbstractSdkRefresher;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkDataBase;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherUtilKt;

public abstract class SdkRefresherVmBase
extends AbstractSdkRefresher {
    private final Set<VirtualFile> myWatchedRoots = new HashSet<VirtualFile>();
    @Nullable
    private String myUserDefinedPath = null;

    @Override
    public final boolean isManagedSdk(@Nullable Sdk sdk) {
        return RubyVersionManagerHandler.from(sdk) == this.getVersionManagerHandler() && !RubyRemoteInterpreterManager.isRemoteSdk(sdk);
    }

    @Override
    protected final void doInitialize() {
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)true, (VirtualFile[])this.getRootsToRefresh().toArray(VirtualFile.EMPTY_ARRAY));
        this.getInstallationsRoots().forEach(this::addRootToWatch);
        this.doAdditionalInitialization();
    }

    protected final synchronized void addRootToWatch(@NotNull VirtualFile root) {
        if (root == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(0);
        }
        if (this.myWatchedRoots.add(root)) {
            this.myLog.debug("Setting watcher and listener to " + String.valueOf(root));
            Disposable disposable = RubyPluginUtil.getUnloadAwareDisposable();
            RubyFileSystemUtil.addRootToWatch(root.getPath(), false, disposable);
            LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)new SdkRootsListener(root), disposable);
        }
    }

    protected void doAdditionalInitialization() {
    }

    @NotNull
    protected Set<? extends RubySdkInfo> getSdkInfos() {
        Path versionManagerPath = this.getVersionManagerPath();
        if (versionManagerPath == null) {
            this.myLog.debug("Could not find version manager path");
            Set set = Collections.emptySet();
            if (set == null) {
                SdkRefresherVmBase.$$$reportNull$$$0(1);
            }
            return set;
        }
        this.myLog.debug("Found version manager in " + String.valueOf(versionManagerPath));
        String versionManagerPathName = versionManagerPath.toString();
        Set set = this.getInstallationsRoots().stream().flatMap(it -> {
            this.myLog.debug("Looking for installations in: " + String.valueOf(it));
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{it});
            }
            return Arrays.stream(it.getChildren());
        }).filter(it -> it.isDirectory()).flatMap(it -> this.getSdkInfosForInterpreterHome(versionManagerPathName, (VirtualFile)it)).collect(Collectors.toSet());
        if (set == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    protected Stream<? extends RubySdkInfo> getSdkInfosForInterpreterHome(@NotNull String versionManagerPathName, @NotNull VirtualFile interpreterHome) {
        if (versionManagerPathName == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(3);
        }
        if (interpreterHome == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(4);
        }
        Stream<RubySdkInfo> stream = Stream.of(new RubySdkInfo(versionManagerPathName, interpreterHome, null));
        if (stream == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @Override
    protected final void doRefreshSDKs() {
        this.myLog.debug("Refreshing sdks");
        Set<? extends RubySdkInfo> sdkInfos = this.getSdkInfos();
        this.myLog.debug("Got " + sdkInfos.size() + " sdk infos");
        List<Sdk> registeredSdks = SdkRefresherUtilKt.getRegisteredRubySdks();
        this.myLog.debug("Got " + registeredSdks.size() + " ruby sdks");
        List managedSdk = ContainerUtil.filter(registeredSdks, this::isManagedSdk);
        this.myLog.debug("Got " + managedSdk.size() + " sdks managed by me");
        List toCreate = ContainerUtil.filter(sdkInfos, info -> {
            boolean result;
            boolean bl = result = info != null && info.getSdkType() != null && info.getRubyExecutable() != null && this.canBeRegistered((RubySdkInfo)info, (Collection<? extends Sdk>)registeredSdks);
            if (result) {
                this.myLog.debug("Should be created: " + String.valueOf(info));
            }
            return result;
        });
        this.myLog.debug(toCreate.size() + " sdks should be created");
        List toRemove = ContainerUtil.filter((Collection)managedSdk, sdk -> {
            assert (sdk != null);
            for (RubySdkInfo sdkInfo : sdkInfos) {
                if (!this.equal(sdkInfo, (Sdk)sdk)) continue;
                return false;
            }
            this.myLog.debug("Should be removed: " + String.valueOf(sdk));
            return true;
        });
        this.myLog.debug(toRemove.size() + " sdks should be removed");
        this.cleanUpSDKs(toRemove);
        for (RubySdkInfo sdkInfo : toCreate) {
            RubySdkType sdkType = sdkInfo.getSdkType();
            VirtualFile rubyExecutable = sdkInfo.getRubyExecutable();
            assert (rubyExecutable != null);
            assert (sdkType != null);
            this.myLog.debug("Creating new sdk: " + String.valueOf(rubyExecutable));
            sdkType.createAndAddLocalSdk(rubyExecutable, (RubyVersionManagerSdkData)this.getVersionManagerHandler().createAdditionalData(sdkInfo));
            this.runPostCreateSdkAction(sdkInfo);
        }
    }

    @Contract(pure=true)
    @NotNull
    public abstract RubyVersionManagerHandlerBase<?> getVersionManagerHandler();

    protected void runPostCreateSdkAction(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(6);
        }
    }

    private boolean canBeRegistered(@NotNull RubySdkInfo sdkInfo, @NotNull Collection<? extends Sdk> registeredSdks) {
        if (sdkInfo == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(7);
        }
        if (registeredSdks == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(8);
        }
        for (Sdk sdk : registeredSdks) {
            if (!this.equal(sdkInfo, sdk)) continue;
            this.myLog.debug("Already exists: " + String.valueOf(sdkInfo) + " => " + String.valueOf(sdk));
            return false;
        }
        return true;
    }

    private boolean equal(@NotNull RubySdkInfo sdkInfo, @NotNull Sdk sdk) {
        if (sdkInfo == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(9);
        }
        if (sdk == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(10);
        }
        return sdk.getSdkType() == sdkInfo.getSdkType() && Comparing.equal((Object)sdk.getHomeDirectory(), (Object)sdkInfo.getRubyExecutable()) && this.equalsInVersionsFramework(sdkInfo, sdk);
    }

    protected boolean equalsInVersionsFramework(@NotNull RubySdkInfo info, @NotNull Sdk sdk) {
        if (info == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(11);
        }
        if (sdk == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(12);
        }
        RubyVersionManagerHandlerBase<?> versionManagerHandler = this.getVersionManagerHandler();
        return ((RubyVersionManagerSdkDataBase)versionManagerHandler.createAdditionalData(info)).equals(RubyVersionManagerSdkData.from(sdk));
    }

    private void cleanUpSDKs(@NotNull Collection<? extends Sdk> toRemove) {
        if (toRemove == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(13);
        }
        if (toRemove.isEmpty()) {
            return;
        }
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        WriteAction.runAndWait(() -> toRemove.forEach(it -> {
            this.myLog.debug("Removing sdk: " + it.getName());
            jdkTable.removeJdk(it);
        }));
    }

    @Override
    @Nullable
    public String suggestSdkName(@NotNull String executablePath, @NotNull String distributionId, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        RubyVersionManagerHandlerBase<?> versionManagerHandler;
        if (executablePath == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(14);
        }
        if (distributionId == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(15);
        }
        if (versionManagerSdkAdditionalData == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(16);
        }
        if ((versionManagerHandler = this.getVersionManagerHandler()) != versionManagerSdkAdditionalData.getHandler()) {
            return null;
        }
        return ((RubyVersionManagerHandler)versionManagerHandler).getId() + ": " + distributionId;
    }

    @Override
    protected boolean isPermitted() {
        return super.isPermitted() && !SystemInfo.isWindows;
    }

    @Nullable
    public Path getVersionManagerPath() {
        ArrayList<String> possiblePaths = new ArrayList<String>();
        ContainerUtil.addIfNotNull(possiblePaths, (Object)this.getUserDefinedPath());
        possiblePaths.addAll(this.getVersionManagerPathsFromExistingSdks());
        possiblePaths.addAll(this.getPossibleVersionManagersPaths());
        ObjectUtils.doIfNotNull((Object)PathEnvironmentVariableUtil.findInPath((String)this.getVersionManagerHandler().getVersionManagerExecutableName()), it -> possiblePaths.add(it.getPath()));
        return possiblePaths.stream().map(it -> this.getRealPathSafe(Paths.get(OSAgnosticPathUtil.expandUserHome((String)it), new String[0]))).filter(Objects::nonNull).findFirst().orElseGet(() -> this.discoverVersionManagerByOs());
    }

    @Contract(value="null->null")
    @Nullable
    protected final Path getRealPathSafe(@Nullable Path originalPath) {
        if (originalPath == null || !originalPath.toFile().exists()) {
            return null;
        }
        try {
            Path realPath = originalPath.toRealPath(new LinkOption[0]);
            if (!realPath.equals(originalPath)) {
                this.myLog.debug("Got real path: " + String.valueOf(originalPath) + " -> " + String.valueOf(realPath));
            }
            return realPath.toFile().exists() ? realPath : null;
        }
        catch (IOException e) {
            this.myLog.warn(e.getMessage() + " while resolving " + String.valueOf(originalPath));
            return null;
        }
    }

    @Nullable
    private Path discoverVersionManagerByOs() {
        String executableName = this.getVersionManagerHandler().getVersionManagerExecutableName();
        this.myLog.debug("Attempting to discover " + executableName + " in PATH");
        File targetFile = PathEnvironmentVariableUtil.findInPath((String)executableName);
        if (targetFile == null) {
            this.myLog.debug("Not found");
            return null;
        }
        this.myLog.debug("Found " + String.valueOf(targetFile));
        return this.getRealPathSafe(targetFile.toPath());
    }

    @NotNull
    protected abstract List<String> getPossibleVersionManagersPaths();

    @NotNull
    protected final List<VirtualFile> getInstallationsRoots() {
        List<VirtualFile> list = this.getInstallationsRootsPathNames().stream().map(it -> VfsUtil.findFileByIoFile((File)new File(OSAgnosticPathUtil.expandUserHome((String)it)), (boolean)true)).filter(it -> it != null && it.exists() && it.isDirectory()).distinct().collect(Collectors.toList());
        if (list == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    protected List<String> getInstallationsRootsPathNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    protected @NotNull Collection<? extends @NotNull VirtualFile> getRootsToRefresh() {
        return this.getInstallationsRoots();
    }

    public void refreshVfsRootsAndSdks(@NotNull Runnable onRefreshed) {
        if (onRefreshed == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(19);
        }
        Application app = ApplicationManager.getApplication();
        RefreshQueue.getInstance().refresh(true, false, () -> app.executeOnPooledThread(() -> {
            this.initializeIfNecessary();
            this.refreshSDKs();
            app.invokeLater(onRefreshed);
        }), this.getRootsToRefresh());
    }

    @Nullable
    protected static Path getPathByEnvironmentVariable(@NotNull String envVar, @NotNull Path resolvePath) {
        String rootDir;
        if (envVar == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(20);
        }
        if (resolvePath == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(21);
        }
        if ((rootDir = EnvironmentUtil.getValue((String)envVar)) == null) {
            return null;
        }
        return Path.of(rootDir, new String[0]).resolve(resolvePath);
    }

    @Nullable
    public String getUserDefinedPath() {
        return this.myUserDefinedPath;
    }

    @NotNull
    protected final Set<String> getVersionManagerPathsFromExistingSdks() {
        Set<String> set = Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(this::isManagedSdk).map(RubyVersionManagerSdkData::from).filter(it -> it instanceof RubyVersionManagerSdkDataBase && ((RubyVersionManagerSdkDataBase)it).hasVersionManagerPath()).map(it -> ((RubyVersionManagerSdkDataBase)it).getVersionManagerPath()).collect(Collectors.toSet());
        if (set == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(22);
        }
        return set;
    }

    protected final void addCustomPathAndRefresh(@NotNull VirtualFile userFile) {
        if (userFile == null) {
            SdkRefresherVmBase.$$$reportNull$$$0(23);
        }
        this.myUserDefinedPath = userFile.getPath();
        this.refreshAsynchronously();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 17, 18, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 17: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/SdkRefresherVmBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPathName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterHome";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registeredSdks";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onRefreshed";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVar";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvePath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/SdkRefresherVmBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfos";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallationsRoots";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallationsRootsPathNames";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerPathsFromExistingSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRootToWatch";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 17: 
            case 18: 
            case 22: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runPostCreateSdkAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canBeRegistered";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalsInVersionsFramework";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpSDKs";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "refreshVfsRootsAndSdks";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPathByEnvironmentVariable";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addCustomPathAndRefresh";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 17, 18, 22 -> new IllegalStateException(string);
        };
    }

    private class SdkRootsListener
    implements VirtualFileListener {
        @NotNull
        private final VirtualFile myRoot;

        SdkRootsListener(VirtualFile root) {
            if (root == null) {
                SdkRootsListener.$$$reportNull$$$0(0);
            }
            this.myRoot = root;
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                SdkRootsListener.$$$reportNull$$$0(1);
            }
            this.refresh(event);
        }

        private void refresh(VirtualFileEvent event) {
            VirtualFile eventFile = event.getFile();
            if (this.myRoot.equals(eventFile.getParent())) {
                SdkRefresherVmBase.this.refreshAsynchronously();
            }
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                SdkRootsListener.$$$reportNull$$$0(2);
            }
            this.refresh(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/SdkRefresherVmBase$SdkRootsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

