/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalDataBase;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemData;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemVersionManagerHandler;

public abstract class RubyVersionManagerSdkData<Data extends RubyVersionManagerSdkData<Data>> {
    private static final Logger LOG = Logger.getInstance(RubyVersionManagerSdkData.class);
    @NonNls
    private static final String VERSION_MANAGER_KEY = "VERSION_MANAGER";
    @NonNls
    private static final String ID_KEY = "ID";
    @NotNull
    private final AtomicReference<Throwable> myCommitStackTraceRef;
    @NotNull
    private final RubyVersionManagerHandler<Data> myHandler;

    public RubyVersionManagerSdkData(@NotNull RubyVersionManagerHandler<Data> handler) {
        if (handler == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(0);
        }
        this.myCommitStackTraceRef = new AtomicReference();
        this.myHandler = handler;
    }

    @NotNull
    public final Data copy() {
        Data Data2 = this.copyTo(this.getHandler().createAdditionalData());
        if (Data2 == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(1);
        }
        return Data2;
    }

    @NotNull
    protected abstract Data copyTo(@NotNull Data var1);

    @NotNull
    public final RubyVersionManagerHandler<Data> getHandler() {
        RubyVersionManagerHandler<Data> rubyVersionManagerHandler = this.myHandler;
        if (rubyVersionManagerHandler == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(2);
        }
        return rubyVersionManagerHandler;
    }

    @NotNull
    @NlsSafe
    public String getRemoteSdkNameSuffix() {
        return "";
    }

    @NotNull
    public abstract Data withDistributionId(@NotNull String var1);

    public final void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(3);
        }
        Element versionManagerElement = new Element(VERSION_MANAGER_KEY);
        versionManagerElement.setAttribute(ID_KEY, this.getHandler().getId());
        rootElement.addContent(versionManagerElement);
        this.saveData(versionManagerElement);
    }

    protected void saveData(@NotNull Element rootElement) {
        if (rootElement == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(4);
        }
        XmlSerializer.serializeInto((Object)this, (Element)rootElement);
    }

    @NotNull
    protected Data loadData(@NotNull Element rootElement) {
        if (rootElement == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(5);
        }
        XmlSerializer.deserializeInto((Object)this, (Element)rootElement);
        Data Data2 = this.self();
        if (Data2 == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(6);
        }
        return Data2;
    }

    public abstract boolean areGemsUserLocal(@NotNull Sdk var1);

    @NotNull
    protected abstract Data self();

    @NotNull
    @NlsSafe
    public abstract String getPresentableText();

    protected boolean isMatchingVmHandler(@NotNull RubySdkConfig sdkConfig) {
        if (sdkConfig == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(7);
        }
        return this.getHandler() == sdkConfig.vmHandler();
    }

    public abstract boolean isMatching(@NotNull RubySdkConfig var1, @NotNull Sdk var2);

    protected final void assertWritable() {
        if (this.myCommitStackTraceRef.get() != null) {
            LOG.error(new Throwable("Additional sdk data can't be directly modified, see javadoc for the assertion.", this.myCommitStackTraceRef.get()));
        }
    }

    public final void markAsCommited(@NotNull Throwable throwable) {
        if (throwable == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(8);
        }
        this.assertWritable();
        this.myCommitStackTraceRef.set(throwable);
    }

    @NotNull
    public static RubyVersionManagerSdkData load(@NotNull Element rootElement, @NotNull String interpreterPath) {
        RubyVersionManagerSdkData result;
        if (rootElement == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(9);
        }
        if (interpreterPath == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(10);
        }
        if ((result = RubyVersionManagerSdkData.doLoad(rootElement, interpreterPath)) != null) {
            RubyVersionManagerSdkData rubyVersionManagerSdkData = result;
            if (rubyVersionManagerSdkData == null) {
                RubyVersionManagerSdkData.$$$reportNull$$$0(11);
            }
            return rubyVersionManagerSdkData;
        }
        LOG.warn("Unable to read version manager information from: " + rootElement.getText() + "; falling back to system manager");
        RubySystemData rubySystemData = RubySystemVersionManagerHandler.getInstance().createAdditionalData();
        if (rubySystemData == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(12);
        }
        return rubySystemData;
    }

    @Nullable
    private static RubyVersionManagerSdkData doLoad(@NotNull Element rootElement, @NotNull String interpreterPath) {
        Element versionManagerElement;
        if (rootElement == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(13);
        }
        if (interpreterPath == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(14);
        }
        if ((versionManagerElement = rootElement.getChild(VERSION_MANAGER_KEY)) == null) {
            return RubyVersionManagerHandler.loadLegacy(rootElement, interpreterPath);
        }
        String handlerId = versionManagerElement.getAttributeValue(ID_KEY);
        if (handlerId == null) {
            return null;
        }
        RubyVersionManagerHandler handler = RubyVersionManagerHandler.findHandler(h -> h.getId().equals(handlerId));
        if (handler == null) {
            return null;
        }
        return ((RubyVersionManagerSdkData)handler.createAdditionalData()).loadData(versionManagerElement);
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    protected static RubyVersionManagerSdkData from(@Nullable SdkAdditionalData sdkAdditionalData) {
        return RubySdkAdditionalDataBase.isEmpty((SdkAdditionalData)sdkAdditionalData) ? null : ((RubySdkAdditionalData)sdkAdditionalData).getVersionManagerSdkAdditionalData();
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static RubyVersionManagerSdkData from(@Nullable Sdk sdk) {
        return sdk == null ? null : RubyVersionManagerSdkData.from(sdk.getSdkAdditionalData());
    }

    @Contract(pure=true)
    @NotNull
    public static RubyVersionManagerSdkData notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(15);
        }
        RubyVersionManagerSdkData rubyVersionManagerSdkData = Objects.requireNonNull(RubyVersionManagerSdkData.from(sdk));
        if (rubyVersionManagerSdkData == null) {
            RubyVersionManagerSdkData.$$$reportNull$$$0(16);
        }
        return rubyVersionManagerSdkData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 11, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerSdkData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkConfig";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerSdkData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingVmHandler";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "markAsCommited";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doLoad";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 11, 12, 16 -> new IllegalStateException(string);
        };
    }
}

