/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMappingSettings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkDataBase;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;

public abstract class RubyVersionManagerHandlerBase<Data extends RubyVersionManagerSdkDataBase<Data>>
extends RubyVersionManagerHandler<Data> {
    private static final Logger LOG = Logger.getInstance(RubyVersionManagerHandlerBase.class);
    private static Predicate<String> ourRubyChooser = null;
    public static final String ENV_TOOL = "env";

    @Override
    @NotNull
    public String getId() {
        String string = this.getVersionManagerExecutableName();
        if (string == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected boolean isMyPath(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(1);
        }
        Path path = Paths.get(interpreterPath, new String[0]);
        if (!this.getVersionManagerExecutableName().equals(path.getFileName().toString())) {
            return false;
        }
        Path binPath = path.getParent();
        return binPath != null && "bin".equals(binPath.getFileName().toString());
    }

    @NotNull
    public abstract String getVersionManagerExecutableName();

    @Override
    @Nullable
    protected Data doCreateAdditionalData(@NotNull RubyRemoteSdkAdditionalData remoteSdkAdditionalData) throws RemoteSdkException {
        String versionManagerPath;
        if (remoteSdkAdditionalData == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(2);
        }
        if (!this.isMyPath(versionManagerPath = remoteSdkAdditionalData.getInterpreterPath())) {
            return null;
        }
        RubyRunner runner = remoteSdkAdditionalData.getRunner(null);
        String distributionId = this.chooseDistribution(runner, versionManagerPath);
        remoteSdkAdditionalData.setInterpreterPath(this.computeInterpreterPath(runner, versionManagerPath, distributionId));
        return ((RubyVersionManagerSdkDataBase)((RubyVersionManagerSdkDataBase)this.createAdditionalData()).withDistributionId(distributionId)).withVersionManagerPath(FileUtil.toSystemIndependentName((String)versionManagerPath));
    }

    @NotNull
    protected String chooseDistribution(@NotNull RubyRunner runner, @NotNull String versionManagerPath) throws RemoteSdkException {
        List<String> rubies;
        if (runner == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(3);
        }
        if (versionManagerPath == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(4);
        }
        if ((rubies = this.getAvailableDistributions(runner, versionManagerPath)).isEmpty()) {
            throw new RemoteSdkException(RBundle.message((String)"version.manager.no.rubies.installed"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (String rubyVersion : rubies) {
                if (!ourRubyChooser.test(rubyVersion)) continue;
                String string = rubyVersion;
                if (string == null) {
                    RubyVersionManagerHandlerBase.$$$reportNull$$$0(5);
                }
                return string;
            }
            throw new RuntimeException("There is no compatible Ruby in the list. Available: " + String.valueOf(rubies));
        }
        Ref selectedIndexRef = Ref.create((Object)-1);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            @NlsSafe String initialValue = (String)rubies.get(0);
            selectedIndexRef.set((Object)Messages.showChooseDialog((String)"", (String)RBundle.message((String)"version.manager.select.distribution"), (String[])ArrayUtilRt.toStringArray((Collection)rubies), (String)initialValue, null));
        });
        if ((Integer)selectedIndexRef.get() == -1) {
            throw new RemoteSdkException(RBundle.message((String)"version.manager.you.should.choose"));
        }
        String string = rubies.get((Integer)selectedIndexRef.get());
        if (string == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    public @Unmodifiable @NotNull List<String> getAvailableDistributions(@NotNull RubyRunner runner, @NotNull String versionManagerPath) throws RemoteSdkException {
        ProcessOutput processOutput;
        if (runner == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(7);
        }
        if (versionManagerPath == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(8);
        }
        try {
            processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(this.getAvailableDistributionsCommands(runner, versionManagerPath)).inSameThread(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message((String)"version.manager.fetching.distributions.list")));
        }
        catch (ExecutionException e) {
            throw new RemoteSdkException(RBundle.message((String)"version.manager.error.fetching.distributions.list"), (Throwable)e);
        }
        if (processOutput == null) {
            throw new RemoteSdkException(RBundle.message((String)"version.manager.error.fetching.distributions.list"));
        }
        if (processOutput.getExitCode() != 0) {
            LOG.warn(RBundle.message((String)"version.manager.error.fetching.distributions.list") + " " + String.valueOf(processOutput), (Throwable)new RemoteSdkException(RBundle.message((String)"version.manager.error.fetching.distributions.list")));
        }
        List<String> list = this.processAvailableDistributionsOutput(processOutput.getStdoutLines());
        if (list == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    protected abstract List<String> getAvailableDistributionsCommands(@NotNull RubyRunner var1, @NotNull String var2);

    protected @Unmodifiable @NotNull List<String> processAvailableDistributionsOutput(@NotNull List<String> rawOutput) {
        if (rawOutput == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(10);
        }
        List<String> list = rawOutput;
        if (list == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    protected String computeInterpreterPath(@NotNull RubyRunner runner, @NotNull String versionManagerPath, @NotNull String distributionId) throws RemoteSdkException {
        String string;
        if (runner == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(12);
        }
        if (versionManagerPath == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(13);
        }
        if (distributionId == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(14);
        }
        try {
            String pathToExecutable;
            HashMap<String, String> env = new HashMap<String, String>();
            List<String> patchedCommands = this.patchCommands(runner, versionManagerPath, distributionId, Arrays.asList("gem", ENV_TOOL), env);
            RubyRunnerExecutionContext executionContext = (RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(patchedCommands).withAdditionalEnvs(env)).inSameThread(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message((String)"version.manager.computing.interpreter.path"));
            ProcessOutput rawEnvOutput = runner.execute(executionContext);
            String string2 = pathToExecutable = rawEnvOutput == null ? null : RubyGemsEnvironment.parse(rawEnvOutput.getStdout()).getRubyExecutable();
            if (StringUtil.isEmpty((String)pathToExecutable)) {
                LOG.warn("Error computing interpreter path for " + versionManagerPath + " and " + distributionId);
                if (rawEnvOutput == null) {
                    LOG.warn("\tOutput is null.");
                } else {
                    LOG.warn("\tExit code: " + rawEnvOutput.getExitCode());
                    LOG.warn("\tStdout: " + rawEnvOutput.getStdout());
                    LOG.warn("\tStderr: " + rawEnvOutput.getStderr());
                }
                throw new RemoteSdkException(RBundle.message((String)"version.manager.unable.to.find.executable", (Object[])new Object[]{distributionId}));
            }
            string = pathToExecutable;
        }
        catch (ExecutionException e) {
            throw new RemoteSdkException(RBundle.message((String)"version.manager.unable.to.get.environment", (Object[])new Object[]{distributionId, e.getMessage()}), (Throwable)e);
        }
        if (string == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public void doPatchCommandLine(@NotNull RubyAbstractRunner rubyRunner, @NotNull GeneralCommandLine commandLine, @NotNull Map<String, String> envParams, @NotNull Map<String, String> customEnvVariables, @NotNull Sdk sdk, @NotNull PathMappingSettings pathMappings) throws ExecutionException {
        RubyVersionManagerSdkDataBase versionManagerSdkData;
        if (rubyRunner == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(16);
        }
        if (commandLine == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(17);
        }
        if (envParams == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(18);
        }
        if (customEnvVariables == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(19);
        }
        if (sdk == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(20);
        }
        if (pathMappings == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(21);
        }
        if (!(versionManagerSdkData = RubyVersionManagerSdkDataBase.notNullFrom(sdk)).hasVersionManagerPath()) {
            this.clarifyVersionManagerPath(sdk);
        }
        List<String> newCommands = this.patchCommands(rubyRunner, versionManagerSdkData.getVersionManagerPath(), versionManagerSdkData.getDistributionId(), commandLine.getCommandLineList(null), envParams);
        commandLine.setExePath(newCommands.remove(0));
        commandLine.getParametersList().clearAll();
        commandLine.withParameters(newCommands);
    }

    @NotNull
    protected abstract List<String> patchCommands(@NotNull RubyRunner var1, @NotNull String var2, @NotNull String var3, @NotNull List<String> var4, @NotNull Map<String, String> var5);

    @NotNull
    public Data createAdditionalData(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(22);
        }
        RubyVersionManagerSdkData rubyVersionManagerSdkData = ((RubyVersionManagerSdkDataBase)((RubyVersionManagerSdkDataBase)this.createAdditionalData()).withVersionManagerPath(sdkInfo.getPathToVersionManager())).withDistributionId(sdkInfo.getInterpreterHome().getName());
        if (rubyVersionManagerSdkData == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(23);
        }
        return (Data)rubyVersionManagerSdkData;
    }

    @NotNull
    protected List<String> getAdditionalPathsToSearch() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(24);
        }
        return list;
    }

    protected void clarifyVersionManagerPath(@NotNull Sdk sdk) throws ExecutionException {
        if (sdk == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(25);
        }
        LOG.info("Clarifying version manager path for " + String.valueOf(sdk));
        RubyRunner rubyRunner = RubyRunner.notNullFrom(sdk);
        String versionManagerExecutableName = this.getVersionManagerExecutableName();
        String capitalizedName = StringUtil.toUpperCase((String)versionManagerExecutableName);
        ExecutionModes.SameThreadMode executionMode = new ExecutionModes.SameThreadMode(false, RBundle.message((String)"version.manager.detection.path", (Object[])new Object[]{versionManagerExecutableName}), RubyRunner.DEFAULT_EXECUTION_TIMEOUT);
        executionMode.addProcessListener(RubyRunner.CLOSE_INPUT_ADAPTER);
        ProcessOutput output2 = null;
        ArrayList<String> allPaths = new ArrayList<String>(this.getAdditionalPathsToSearch());
        allPaths.add("$PATH");
        try {
            output2 = rubyRunner.execute((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(rubyRunner.wrapWithShell(true, false, "PATH=" + StringUtil.join(allPaths, (String)":") + " \\which " + versionManagerExecutableName)).withExecutionMode((ExecutionMode)executionMode)).withPty(true));
        }
        catch (ExecutionException e) {
            LOG.warn("Error looking for version manager executable: executableName: [" + versionManagerExecutableName + "]; paths: [" + String.valueOf(allPaths) + "]; runner: [" + String.valueOf(rubyRunner) + "]", (Throwable)e);
        }
        if (output2 != null && output2.getExitCode() == 0 && !output2.getStdoutLines().isEmpty()) {
            RubyVersionManagerSdkDataBase.notNullFrom(sdk).withVersionManagerPath((String)output2.getStdoutLines().get(0));
        } else {
            Ref userPathRef = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> userPathRef.set((Object)Messages.showInputDialog((String)RBundle.message((String)"version.manager.detection.dialog.message", (Object[])new Object[]{versionManagerExecutableName, sdk.toString()}), (String)RBundle.message((String)"version.manager.detection.dialog.title", (Object[])new Object[]{capitalizedName}), (Icon)Messages.getQuestionIcon())));
            if (StringUtil.isNotEmpty((String)((String)userPathRef.get()))) {
                RubyVersionManagerSdkDataBase.notNullFrom(sdk).withVersionManagerPath((String)userPathRef.get());
            } else {
                throw new ExecutionException(RBundle.message((String)"version.manager.detection.not.found", (Object[])new Object[]{capitalizedName}));
            }
        }
    }

    @Contract(pure=true)
    @NotNull
    protected static String getVersionFromInterpreterPath(@NotNull String interpreterPath) {
        Path path;
        Path binPath;
        Path distributionPath;
        if (interpreterPath == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(26);
        }
        Path path2 = distributionPath = (binPath = (path = Paths.get(interpreterPath, new String[0])).getParent()) == null ? null : binPath.getParent();
        if (distributionPath == null) {
            throw new InvalidDataException("Invalid interpreter path: " + interpreterPath);
        }
        String string = distributionPath.getFileName().toString();
        if (string == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(27);
        }
        return string;
    }

    @TestOnly
    public static void runWithChoosingRuby(@NotNull Predicate<String> rubyChooser, @NotNull Runnable runnable) {
        if (rubyChooser == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(28);
        }
        if (runnable == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(29);
        }
        ourRubyChooser = rubyChooser;
        try {
            runnable.run();
        }
        finally {
            ourRubyChooser = null;
        }
    }

    @NotNull
    @NonNls
    protected abstract String getStarterScriptName();

    @Override
    public String[] customizeTerminalExecution(@NotNull Project project, @NotNull Sdk rubySdk, @NotNull String[] command, @NotNull Map<String, String> envs) {
        String starterScriptPath;
        String starterPath;
        if (project == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(30);
        }
        if (rubySdk == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(31);
        }
        if (envs == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(32);
        }
        if (command == null) {
            RubyVersionManagerHandlerBase.$$$reportNull$$$0(33);
        }
        if ((starterPath = RubyUtil.getScriptFullPath(starterScriptPath = "rb/terminal/" + this.getStarterScriptName())) == null) {
            LOG.debug("Unable to find VM starter: " + starterScriptPath);
            return command;
        }
        RubyVersionManagerSdkDataBase<?> rvmSdkData = RubyVersionManagerSdkDataBase.from(rubySdk);
        if (rvmSdkData == null) {
            LOG.error("No sdk data in " + String.valueOf(rubySdk));
            return command;
        }
        envs.put("JEDITERM_SOURCE", starterPath);
        envs.put("RUBY_VERSION_MANAGER_PATH", rvmSdkData.getVersionManagerPath());
        envs.put("RUBY_VERSION_MANAGER_DISTRIBUTION_ID", rvmSdkData.getDistributionId());
        Path shimsPath = ShimsBasedVersionManagerHandler.shimsPathFor(rubySdk, null);
        if (shimsPath != null) {
            envs.put("RUBY_VERSION_MANAGER_SHIMS_PATH", shimsPath.toString());
        }
        return command;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 7, 8, 10, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 25, 26, 28, 29, 30, 31, 32, 33 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandlerBase";
                break;
            }
            case 1: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkAdditionalData";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawOutput";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envParams";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customEnvVariables";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyChooser";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdk";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandlerBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseDistribution";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processAvailableDistributionsOutput";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInterpreterPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalData";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPathsToSearch";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionFromInterpreterPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMyPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCreateAdditionalData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseDistribution";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDistributions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAvailableDistributionsOutput";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeInterpreterPath";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doPatchCommandLine";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "clarifyVersionManagerPath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVersionFromInterpreterPath";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "runWithChoosingRuby";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "customizeTerminalExecution";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 7, 8, 10, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 25, 26, 28, 29, 30, 31, 32, 33 -> new IllegalArgumentException(string);
        };
    }
}

