/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubyVersionAndGemsetSdkConfigFactory;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkInstaller;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;

public abstract class RubyVersionManagerHandler<Data extends RubyVersionManagerSdkData<Data>> {
    private static final Logger LOG = Logger.getInstance(RubyVersionManagerHandler.class);
    private static final ExtensionPointName<RubyVersionManagerHandler> EP = new ExtensionPointName("org.jetbrains.plugins.ruby.versionManagerHandler");
    public static final String GEM_PATH_REMOVAL_EXPERIMENT = "ruby.force.gempath.removal";
    private static final Key<Boolean> REMOVE_GEM_HOME_AND_PATH_KEY = Key.create((String)"ruby.remove.gem.home");

    @NotNull
    public static List<? extends RubyVersionManagerHandler> getVersionManagerHandlers() {
        List list = EP.getExtensionList();
        if (list == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public String getRemoteNameSuffix() {
        String string = "-" + this.getId();
        if (string == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public abstract Data createAdditionalData();

    @Nullable
    protected abstract Data doCreateAdditionalData(@NotNull RubyRemoteSdkAdditionalData var1) throws RemoteSdkException;

    @Deprecated
    @Nullable
    protected abstract RubyVersionManagerSdkData doLoadLegacy(@NotNull Element var1, @NotNull String var2);

    public abstract void doPatchCommandLine(@NotNull RubyAbstractRunner var1, @NotNull GeneralCommandLine var2, @NotNull Map<String, String> var3, @NotNull Map<String, String> var4, @NotNull Sdk var5, @NotNull PathMappingSettings var6) throws ExecutionException;

    @Contract(pure=true)
    @NotNull
    public String getAdjustedGemScriptPathForExecution(@NotNull String fullScriptPath) {
        if (fullScriptPath == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(2);
        }
        String string = ShimsBasedVersionManagerHandler.is(this) ? Paths.get(fullScriptPath, new String[0]).getFileName().toString() : fullScriptPath;
        if (string == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static RubyVersionManagerSdkData createAdditionalData(@NotNull RubyRemoteSdkAdditionalData remoteSdkAdditionalData) throws RemoteSdkException {
        if (remoteSdkAdditionalData == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(4);
        }
        for (RubyVersionManagerHandler handler : (RubyVersionManagerHandler[])EP.getExtensions()) {
            Object data = handler.doCreateAdditionalData(remoteSdkAdditionalData);
            if (data == null) continue;
            Object Data2 = data;
            if (Data2 == null) {
                RubyVersionManagerHandler.$$$reportNull$$$0(5);
            }
            return Data2;
        }
        throw new RuntimeException("RubySystemVersionManagerHandler should be registered as last and eat any path");
    }

    @Nullable
    public static RubyVersionManagerHandler findHandler(@NotNull Predicate<? super RubyVersionManagerHandler> predicate) {
        if (predicate == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(6);
        }
        return Arrays.stream((RubyVersionManagerHandler[])EP.getExtensions()).filter(predicate).findFirst().orElse(null);
    }

    @Deprecated
    @NotNull
    static RubyVersionManagerSdkData loadLegacy(@NotNull Element rootElement, @NotNull String interpreterPath) {
        if (rootElement == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(7);
        }
        if (interpreterPath == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(8);
        }
        RubyVersionManagerSdkData rubyVersionManagerSdkData = Stream.of((RubyVersionManagerHandler[])EP.getExtensions()).map(e -> e.doLoadLegacy(rootElement, interpreterPath)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new RuntimeException("RubySystemVersionManagerHandler should be registered as last and work as fallback"));
        if (rubyVersionManagerSdkData == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(9);
        }
        return rubyVersionManagerSdkData;
    }

    public static void patchCommandLine(@NotNull RubyAbstractRunner rubyRunner, @NotNull GeneralCommandLine commandLine, @NotNull Map<String, String> envParams, @NotNull Map<String, String> customEnvVariables, @NotNull Sdk sdk, @NotNull PathMappingSettings pathMappings) throws ExecutionException {
        RubyVersionManagerHandler versionManagerHandler;
        if (rubyRunner == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(10);
        }
        if (commandLine == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(11);
        }
        if (envParams == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(12);
        }
        if (customEnvVariables == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(13);
        }
        if (sdk == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(14);
        }
        if (pathMappings == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(15);
        }
        if ((versionManagerHandler = RubyVersionManagerHandler.from(sdk)) != null) {
            versionManagerHandler.doPatchCommandLine(rubyRunner, commandLine, envParams, customEnvVariables, sdk, pathMappings);
        } else {
            LOG.error("Attempt to patch command-line with non-ruby SDK: " + String.valueOf(sdk));
        }
    }

    public boolean canRunArbitraryCommand() {
        return true;
    }

    @Contract(pure=true, value="null -> null")
    @Nullable
    public static RubyVersionManagerHandler from(@Nullable Sdk sdk) {
        RubyVersionManagerSdkData versionManagerSdkAdditionalData = RubyVersionManagerSdkData.from(sdk);
        return versionManagerSdkAdditionalData == null ? null : versionManagerSdkAdditionalData.getHandler();
    }

    @Contract(pure=true)
    @NotNull
    public static RubyVersionManagerHandler notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(16);
        }
        RubyVersionManagerHandler rubyVersionManagerHandler = Objects.requireNonNull(RubyVersionManagerHandler.from(sdk), () -> "Failed to extract from " + String.valueOf(sdk));
        if (rubyVersionManagerHandler == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(17);
        }
        return rubyVersionManagerHandler;
    }

    public static void removeGemHomeAndGemPath(@NotNull Map<String, String> envParams, @NotNull GeneralCommandLine commandLine) {
        if (envParams == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(18);
        }
        if (commandLine == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(19);
        }
        if (Experiments.getInstance().isFeatureEnabled(GEM_PATH_REMOVAL_EXPERIMENT)) {
            envParams.remove("GEM_PATH");
            envParams.remove("GEM_HOME");
            REMOVE_GEM_HOME_AND_PATH_KEY.set((UserDataHolder)commandLine, (Object)true);
        }
    }

    public static boolean shouldRemoveGemHome(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(20);
        }
        return REMOVE_GEM_HOME_AND_PATH_KEY.get((UserDataHolder)commandLine) != null;
    }

    public String[] customizeTerminalExecution(@NotNull Project project, @NotNull Sdk rubySdk, @NotNull String[] command, @NotNull Map<String, String> envs) {
        if (project == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(21);
        }
        if (rubySdk == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(22);
        }
        if (envs == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(23);
        }
        if (command == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(24);
        }
        return command;
    }

    protected Collection<Class<? extends RubySdkConfig.Factory>> getSdkConfigFactories() {
        return Collections.singletonList(RubyVersionAndGemsetSdkConfigFactory.class);
    }

    @RequiresReadLock
    @Nullable
    public final RubySdkConfig readSdkConfig(@NotNull VirtualFile root) {
        if (root == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(25);
        }
        ThreadingAssertions.softAssertReadAccess();
        Collection<Class<RubySdkConfig.Factory>> preferredFactories = this.getSdkConfigFactories();
        Stream<RubySdkConfig.Factory> factoriesWithFallback = Stream.concat(preferredFactories.stream().map(it -> (RubySdkConfig.Factory)RubySdkConfig.FACTORY_EP.findExtensionOrFail(it)), RubySdkConfig.FACTORY_EP.getExtensionList().stream());
        Optional<RubySdkConfig> sdkConfig = factoriesWithFallback.map(factory -> factory.createFromRoot(root, this)).filter(Objects::nonNull).findFirst();
        return sdkConfig.orElse(null);
    }

    @RequiresReadLock
    @Nullable
    public final RubySdkConfig readSdkConfig(@NotNull Module module) {
        VirtualFile[] contentRoots;
        if (module == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(26);
        }
        ThreadingAssertions.softAssertReadAccess();
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            RubySdkConfig sdkConfig = this.readSdkConfig(root);
            if (sdkConfig == null) continue;
            return sdkConfig;
        }
        return null;
    }

    @Nullable
    public Object getConfigIgnoredRequestor() {
        return null;
    }

    @NotNull
    public Collection<? extends SdkInstaller> getInstallers() {
        List list = List.of();
        if (list == null) {
            RubyVersionManagerHandler.$$$reportNull$$$0(27);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullScriptPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkAdditionalData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 11: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envParams";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customEnvVariables";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdk";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerHandlers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteNameSuffix";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjustedGemScriptPathForExecution";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLegacy";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedGemScriptPathForExecution";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadLegacy";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeGemHomeAndGemPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldRemoveGemHome";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "customizeTerminalExecution";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "readSdkConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26 -> new IllegalArgumentException(string);
        };
    }
}

