/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.PathUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfigurationCheckFilesWatcherKt;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfigurationCheckService;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/ruby/version/management/RubySdkConfigurationCheckFilesWatcher;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "watchedFilenames", "", "", "ignoredRequestors", "", "", "isConfigFileInProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "dispose", "", "intellij.ruby.backend"})
public final class RubySdkConfigurationCheckFilesWatcher
implements AsyncFileListener,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> watchedFilenames;
    @NotNull
    private final Set<Object> ignoredRequestors;

    public RubySdkConfigurationCheckFilesWatcher(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.watchedFilenames = new LinkedHashSet();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        Set requestors = new LinkedHashSet();
        RubySdkConfig.FACTORY_EP.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RubySdkConfig.Factory>(){

            public void extensionAdded(RubySdkConfig.Factory extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                Set set = watchedFilenames;
                Collection<String> collection = extension.getSourceFilenames();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getSourceFilenames(...)");
                set.addAll(collection);
            }

            public void extensionRemoved(RubySdkConfig.Factory extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                Set set = watchedFilenames;
                Collection<String> collection = extension.getSourceFilenames();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getSourceFilenames(...)");
                set.removeAll(collection);
            }
        }, (Disposable)this);
        for (RubySdkConfig.Factory factory : RubySdkConfig.FACTORY_EP.getExtensionList()) {
            Collection<String> collection = factory.getSourceFilenames();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getSourceFilenames(...)");
            this.watchedFilenames.addAll(collection);
        }
        for (RubyVersionManagerHandler handler : RubyVersionManagerHandler.getVersionManagerHandlers()) {
            Object it;
            if (handler.getConfigIgnoredRequestor() == null) continue;
            boolean bl = false;
            requestors.add(it);
        }
        this.ignoredRequestors = requestors;
    }

    private final boolean isConfigFileInProject(VirtualFile file) {
        return file != null && VirtualFileUtil.isFile((VirtualFile)file) && this.watchedFilenames.contains(file.getName()) && ProjectFileIndex.getInstance((Project)this.project).isInProject(file);
    }

    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            boolean fileMightBeConfigAfterChange;
            Object requestor = vFileEvent.getRequestor();
            if (requestor != null && this.ignoredRequestors.contains(requestor)) continue;
            boolean fileIsConfig = this.isConfigFileInProject(vFileEvent.getFile());
            boolean bl = fileMightBeConfigAfterChange = this.watchedFilenames.contains(PathUtil.getFileName((String)vFileEvent.getPath())) || vFileEvent instanceof VFilePropertyChangeEvent && Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)vFileEvent).getPropertyName(), (Object)"name") && CollectionsKt.contains((Iterable)this.watchedFilenames, (Object)((VFilePropertyChangeEvent)vFileEvent).getNewValue());
            if (!fileIsConfig && !fileMightBeConfigAfterChange) continue;
            return new AsyncFileListener.ChangeApplier(vFileEvent, fileIsConfig, this){
                final /* synthetic */ VFileEvent $event;
                final /* synthetic */ boolean $fileIsConfig;
                final /* synthetic */ RubySdkConfigurationCheckFilesWatcher this$0;
                {
                    this.$event = $event;
                    this.$fileIsConfig = $fileIsConfig;
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public void afterVfsChange() {
                    VirtualFile fileAfterChange = this.$event.getFile();
                    if (this.$fileIsConfig || RubySdkConfigurationCheckFilesWatcher.access$isConfigFileInProject(this.this$0, fileAfterChange)) {
                        void $this$debug_u24default$iv;
                        Logger logger = RubySdkConfigurationCheckFilesWatcherKt.access$getLOG$p();
                        VFileEvent vFileEvent = this.$event;
                        RubySdkConfigurationCheckFilesWatcher rubySdkConfigurationCheckFilesWatcher = this.this$0;
                        Throwable e$iv = null;
                        boolean $i$f$debug = false;
                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                            void var8_7 = $this$debug_u24default$iv;
                            boolean bl = false;
                            var8_7.debug("It looks like " + vFileEvent.getPath() + " config file has been changed, let's update notification for the project " + RubySdkConfigurationCheckFilesWatcher.access$getProject$p(rubySdkConfigurationCheckFilesWatcher), e$iv);
                        }
                        RubySdkConfigurationCheckService.Companion.getInstance(RubySdkConfigurationCheckFilesWatcher.access$getProject$p(this.this$0)).updateProblemsNotificationInBackground();
                    }
                }
            };
        }
        return null;
    }

    public void dispose() {
    }

    public static final /* synthetic */ boolean access$isConfigFileInProject(RubySdkConfigurationCheckFilesWatcher $this, VirtualFile file) {
        return $this.isConfigFileInProject(file);
    }

    public static final /* synthetic */ Project access$getProject$p(RubySdkConfigurationCheckFilesWatcher $this) {
        return $this.project;
    }
}

