/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.ui.search.TraverseUIMode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;
import org.jetbrains.plugins.ruby.version.management.SdkRefresher;

public abstract class AbstractSdkRefresher
implements SdkRefresher {
    protected final Logger myLog = Logger.getInstance(this.getClass());
    private final NullableLazyValue<Boolean> myInitializer = NullableLazyValue.atomicLazyNullable(() -> {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            ThreadingAssertions.assertNoOwnReadAccess();
        }
        this.doInitialize();
        return null;
    });
    private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("SDK auto-refreshes", 300, true, null, RubyPluginUtil.getUnloadAwareDisposable(), null, false).setRestartTimerOnAdd(true);
    private final Semaphore mySemaphore = new Semaphore(-1, true);
    private boolean myIsRefresherTest = false;
    @Nullable
    private volatile ProgressIndicator myCurrentProgressIndicator = null;

    @Override
    public final void initializeIfNecessary() {
        this.myInitializer.getValue();
    }

    protected abstract void doInitialize();

    @Override
    public final void refreshAsynchronously() {
        this.refreshAsynchronously(ModalityState.defaultModalityState());
    }

    private void refreshAsynchronously(@NotNull ModalityState requestorModality) {
        if (requestorModality == null) {
            AbstractSdkRefresher.$$$reportNull$$$0(0);
        }
        this.myUpdateQueue.queue(Update.create((Object)requestorModality, () -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            if (this.mySemaphore.tryAcquire()) {
                this.doRefreshAndReleaseSemaphore(requestorModality);
            } else {
                this.cancelRunningIfNecessary(requestorModality);
                this.refreshAsynchronously(requestorModality);
            }
        })));
    }

    private void cancelRunningIfNecessary(@NotNull ModalityState requestorModality) {
        ProgressIndicator currentProgressIndicator;
        if (requestorModality == null) {
            AbstractSdkRefresher.$$$reportNull$$$0(1);
        }
        if ((currentProgressIndicator = this.myCurrentProgressIndicator) != null && !requestorModality.accepts(currentProgressIndicator.getModalityState())) {
            currentProgressIndicator.cancel();
        }
    }

    @Override
    @RequiresBackgroundThread
    public void refreshSDKs() {
        ThreadingAssertions.assertBackgroundThread();
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode() && app.isReadAccessAllowed()) {
            throw new RuntimeException("This method must no be invoked on EDT or under Lock");
        }
        while (!this.mySemaphore.tryAcquire()) {
            this.cancelRunningIfNecessary(ModalityState.defaultModalityState());
            TimeoutUtil.sleep((long)10L);
            ProgressManager.checkCanceled();
        }
        this.doRefreshAndReleaseSemaphore(ModalityState.defaultModalityState());
    }

    private void doRefreshAndReleaseSemaphore(final @NotNull ModalityState modalityState) {
        if (modalityState == null) {
            AbstractSdkRefresher.$$$reportNull$$$0(2);
        }
        try {
            if (!this.isPermitted()) {
                this.myLog.debug("Refresher is not permitted to work in the environment");
                return;
            }
            ProgressIndicator existingIndicator = ProgressManager.getInstance().getProgressIndicator();
            this.myCurrentProgressIndicator = existingIndicator == null ? new EmptyProgressIndicator(modalityState) : new SensitiveProgressWrapper(existingIndicator){

                @NotNull
                public ModalityState getModalityState() {
                    ModalityState modalityState2 = modalityState;
                    if (modalityState2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return modalityState2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/version/management/AbstractSdkRefresher$1", "getModalityState"));
                }
            };
            ProgressManager.getInstance().runProcess(this::doRefreshSDKs, this.myCurrentProgressIndicator);
        }
        finally {
            this.myCurrentProgressIndicator = null;
            this.mySemaphore.release();
        }
    }

    protected boolean isPermitted() {
        return !TraverseUIMode.getInstance().isActive() && (!ApplicationManager.getApplication().isUnitTestMode() || this.myIsRefresherTest);
    }

    protected abstract void doRefreshSDKs();

    @Override
    public final void enable() {
        if (this.mySemaphore.availablePermits() >= 0) {
            throw new RuntimeException("This method may be invoked only once per session.");
        }
        this.mySemaphore.release(2);
    }

    @Override
    public final boolean isEnabled() {
        return this.mySemaphore.availablePermits() > -1;
    }

    @TestOnly
    public void doWithSdkRefresherPermitted(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractSdkRefresher.$$$reportNull$$$0(3);
        }
        this.myIsRefresherTest = true;
        try {
            runnable.run();
        }
        finally {
            this.myIsRefresherTest = false;
        }
    }

    @TestOnly
    public static void doWithAllSdkRefreshersPermitted(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractSdkRefresher.$$$reportNull$$$0(4);
        }
        SdkRefresher.forEach(it -> {
            ((AbstractSdkRefresher)it).myIsRefresherTest = true;
        });
        try {
            runnable.run();
        }
        finally {
            SdkRefresher.forEach(it -> {
                ((AbstractSdkRefresher)it).myIsRefresherTest = false;
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestorModality";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/AbstractSdkRefresher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshAsynchronously";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelRunningIfNecessary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doRefreshAndReleaseSemaphore";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doWithSdkRefresherPermitted";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doWithAllSdkRefreshersPermitted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

