/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.vcs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsEnvCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.vcs.RubyVcsEnvCustomizerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J,\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/ruby/vcs/RubyVcsEnvCustomizer;", "Lcom/intellij/openapi/vcs/VcsEnvCustomizer;", "<init>", "()V", "customizeCommandAndEnvironment", "", "project", "Lcom/intellij/openapi/project/Project;", "envs", "", "", "context", "Lcom/intellij/openapi/vcs/VcsEnvCustomizer$VcsExecutableContext;", "findRubyModuleAndSdk", "Lkotlin/Pair;", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/projectRoots/Sdk;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRubyEnv", "", "module", "sdk", "sdkData", "Lorg/jetbrains/plugins/ruby/ruby/sdk/RubySdkAdditionalData;", "readRubyEnv", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nRubyVcsEnvCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyVcsEnvCustomizer.kt\norg/jetbrains/plugins/ruby/vcs/RubyVcsEnvCustomizer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,154:1\n37#2,2:155\n*S KotlinDebug\n*F\n+ 1 RubyVcsEnvCustomizer.kt\norg/jetbrains/plugins/ruby/vcs/RubyVcsEnvCustomizer\n*L\n152#1:155,2\n*E\n"})
public final class RubyVcsEnvCustomizer
extends VcsEnvCustomizer {
    public void customizeCommandAndEnvironment(@Nullable Project project, @NotNull Map<String, String> envs, @NotNull VcsEnvCustomizer.VcsExecutableContext context) {
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Registry.Companion.is("ruby.vcs.use.project.sdk", false)) {
            return;
        }
        if (project == null) {
            return;
        }
        if (context.getType() == VcsEnvCustomizer.ExecutableType.WSL) {
            return;
        }
        VirtualFile root = context.getRoot();
        if (root == null) {
            return;
        }
        Pair<Module, Sdk> pair = this.findRubyModuleAndSdk(project, root);
        Module module = (Module)pair.component1();
        Sdk sdk = (Sdk)pair.component2();
        if (module == null) {
            Object[] objectArray = new Object[]{root, ", project=", project};
            RubyVcsEnvCustomizerKt.access$getLOG$p().debug("No module found for: root=", objectArray);
            return;
        }
        if (sdk == null) {
            Object[] objectArray = new Object[]{module};
            RubyVcsEnvCustomizerKt.access$getLOG$p().debug("No ruby sdk found for module: ", objectArray);
            return;
        }
        RubySdkAdditionalData sdkData = RubySdkAdditionalData.from(sdk);
        if (sdkData == null || sdkData instanceof RubyRemoteSdkAdditionalData) {
            return;
        }
        if (RubySdkSystemAccessor.notNullFrom(sdk).isWindows()) {
            return;
        }
        Object[] objectArray = new Object[]{envs};
        RubyVcsEnvCustomizerKt.access$getLOG$p().debug("VCS env before customization: ", objectArray);
        envs.putAll(this.getRubyEnv(module, sdk, sdkData));
        objectArray = new Object[]{envs};
        RubyVcsEnvCustomizerKt.access$getLOG$p().debug("VCS env after customization: ", objectArray);
    }

    private final Pair<Module, Sdk> findRubyModuleAndSdk(Project project, VirtualFile root) {
        Object object = ReadAction.nonBlocking(() -> RubyVcsEnvCustomizer.findRubyModuleAndSdk$lambda$0(project, root)).expireWhen(() -> RubyVcsEnvCustomizer.findRubyModuleAndSdk$lambda$1(project, root)).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        return (Pair)object;
    }

    private final Map<String, String> getRubyEnv(Module module, Sdk sdk, RubySdkAdditionalData sdkData) {
        Triple cached = (Triple)module.getUserData(RubyVcsEnvCustomizerKt.access$getCACHED_VCS_RUBY_ENV_KEY$p());
        int sdkHash = sdkData.hashCode();
        if (cached != null) {
            long elapsedMs;
            Triple triple = cached;
            Map rubyEnv = (Map)triple.component1();
            long timestampMs = ((Number)triple.component2()).longValue();
            int hash = ((Number)triple.component3()).intValue();
            if (sdkHash == hash && (elapsedMs = System.currentTimeMillis() - timestampMs) < 600000L) {
                Object[] objectArray = new Object[]{timestampMs, ", elapsedMs=", elapsedMs, "rubyEnv=", rubyEnv};
                RubyVcsEnvCustomizerKt.access$getLOG$p().debug("Using cache: timestampMs=", objectArray);
                return rubyEnv;
            }
            module.putUserData(RubyVcsEnvCustomizerKt.access$getCACHED_VCS_RUBY_ENV_KEY$p(), null);
        }
        Map<String, String> rubyEnv = this.readRubyEnv(module, sdk, sdkData);
        Object[] objectArray = new Object[]{rubyEnv};
        RubyVcsEnvCustomizerKt.access$getLOG$p().debug("Ruby env: ", objectArray);
        if (!rubyEnv.isEmpty()) {
            module.putUserData(RubyVcsEnvCustomizerKt.access$getCACHED_VCS_RUBY_ENV_KEY$p(), (Object)new Triple(rubyEnv, (Object)System.currentTimeMillis(), (Object)sdkHash));
        }
        return rubyEnv;
    }

    private final Map<String, String> readRubyEnv(Module module, Sdk sdk, RubySdkAdditionalData sdkData) {
        String string = sdkData.getInterpreterPath(sdk);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInterpreterPath(...)");
        String interpreterPath = string;
        String markerId = ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis();
        String startMarker = "START_" + markerId;
        String endMarker = "END_" + markerId;
        String[] stringArray = new String[]{interpreterPath, "-e", "print %q<" + startMarker + ">;ENV.each{|k,v| print %Q<#{k}=#{v}\\0>};print %q<" + endMarker + ">;"};
        Object t = RubyRunnerExecutionContext.create(sdk, stringArray).inSameThreadCancelableUnderProgressIndicator(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message((String)"progress.title.reading.ruby.environment"));
        Intrinsics.checkNotNullExpressionValue(t, (String)"inSameThreadCancelableUnderProgressIndicator(...)");
        RubyRunnerExecutionContext context = (RubyRunnerExecutionContext)t;
        try {
            stringArray = sdkData.getRunner(module).execute(context);
        }
        catch (ExecutionException e) {
            RubyVcsEnvCustomizerKt.access$getLOG$p().warnWithDebug("Failed to read ruby env: " + e.getMessage(), (Throwable)e);
            return MapsKt.emptyMap();
        }
        String[] output2 = stringArray;
        if (output2 == null) {
            RubyVcsEnvCustomizerKt.access$getLOG$p().warn("Process output is null");
            return MapsKt.emptyMap();
        }
        if (!output2.isExitCodeSet()) {
            RubyVcsEnvCustomizerKt.access$getLOG$p().warn("Process never finished or was interrupted: " + (ProcessOutput)output2);
            return MapsKt.emptyMap();
        }
        if (output2.getExitCode() != 0) {
            RubyVcsEnvCustomizerKt.access$getLOG$p().warn("Process failed: " + (ProcessOutput)output2);
            return MapsKt.emptyMap();
        }
        String string2 = output2.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStdout(...)");
        String stdout = string2;
        int startMarkerOffset = StringsKt.indexOf$default((CharSequence)stdout, (String)startMarker, (int)0, (boolean)false, (int)6, null);
        int endMarkerOffset = StringsKt.indexOf$default((CharSequence)stdout, (String)endMarker, (int)startMarkerOffset, (boolean)false, (int)4, null);
        if (startMarkerOffset < 0 || endMarkerOffset < 0) {
            RubyVcsEnvCustomizerKt.access$getLOG$p().warn("Failed to extract raw ruby env: startMarker=" + startMarker + ", endMarker=" + endMarker + ", stdout=" + stdout);
            return MapsKt.emptyMap();
        }
        String string3 = stdout.substring(startMarkerOffset + startMarker.length(), endMarkerOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String rubyEnvRaw = string3;
        Object[] objectArray = new Object[]{rubyEnvRaw};
        RubyVcsEnvCustomizerKt.access$getLOG$p().debug("Raw ruby env: ", objectArray);
        if (((CharSequence)rubyEnvRaw).length() == 0) {
            return MapsKt.emptyMap();
        }
        char[] cArray = new char[]{'\u0000'};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)rubyEnvRaw, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Map map = EnvironmentUtil.parseEnv((String[])thisCollection$iv.toArray(new String[0]));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"parseEnv(...)");
        return map;
    }

    private static final Pair findRubyModuleAndSdk$lambda$0(Project $project, VirtualFile $root) {
        Module module = ProjectFileIndex.getInstance((Project)$project).getModuleForFile($root);
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        return TuplesKt.to((Object)module, (Object)sdk);
    }

    private static final boolean findRubyModuleAndSdk$lambda$1(Project $project, VirtualFile $root) {
        return $project.isDisposed() || !$root.isValid();
    }
}

