/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.Processor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VirtualFileUtil {
    @NonNls
    public static final char VFS_PATH_SEPARATOR = '/';

    private VirtualFileUtil() {
    }

    @Nullable
    public static VirtualFile findFileBy(@NotNull String path) {
        VirtualFile virtualFile;
        if (path == null) {
            VirtualFileUtil.$$$reportNull$$$0(0);
        }
        if ((virtualFile = LocalFileSystem.getInstance().findFileByPath(path)) != null) {
            return virtualFile;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().findFileByPath(path);
        }
        return null;
    }

    public static String constructLocalUrl(@NotNull String path) {
        if (path == null) {
            VirtualFileUtil.$$$reportNull$$$0(1);
        }
        if (path.startsWith("file://")) {
            return path;
        }
        return VfsUtilCore.pathToUrl((String)path);
    }

    @NotNull
    public static Collection<String> convertPathsToLocalUrls(@NotNull Collection<String> paths) {
        if (paths == null) {
            VirtualFileUtil.$$$reportNull$$$0(2);
        }
        if (paths.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                VirtualFileUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<String> urls = new ArrayList<String>();
        for (String path : paths) {
            urls.add(VirtualFileUtil.constructLocalUrl(path));
        }
        ArrayList<String> arrayList = urls;
        if (arrayList == null) {
            VirtualFileUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static int compareVirtualFiles(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            VirtualFileUtil.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            VirtualFileUtil.$$$reportNull$$$0(6);
        }
        String path1 = file1.getPath();
        String path2 = file2.getPath();
        return path1.compareToIgnoreCase(path2);
    }

    public static boolean isValid(@Nullable VirtualFile file) {
        return file != null && file.isValid();
    }

    @NotNull
    public static String buildUrl(@NotNull String rootUrl, @NotNull String relativePath) {
        if (rootUrl == null) {
            VirtualFileUtil.$$$reportNull$$$0(7);
        }
        if (relativePath == null) {
            VirtualFileUtil.$$$reportNull$$$0(8);
        }
        String string = rootUrl + String.valueOf(rootUrl.endsWith(String.valueOf('/')) ? "" : Character.valueOf('/')) + FileUtil.toSystemIndependentName((String)relativePath);
        if (string == null) {
            VirtualFileUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static String buildSystemIndependentPath(@NotNull String rootPath, @NotNull String relativePath) {
        String rootPathIN;
        if (rootPath == null) {
            VirtualFileUtil.$$$reportNull$$$0(10);
        }
        if (relativePath == null) {
            VirtualFileUtil.$$$reportNull$$$0(11);
        }
        return rootPathIN + String.valueOf((rootPathIN = FileUtil.toSystemIndependentName((String)rootPath)).endsWith(String.valueOf('/')) ? "" : Character.valueOf('/')) + FileUtil.toSystemIndependentName((String)relativePath);
    }

    public static boolean fileExists(@Nullable VirtualFile file) {
        return file != null && file.exists();
    }

    @Nullable
    public static String getRelativePath(@NotNull String filePathOrUrl, @NotNull String rootPathOrUrl) {
        if (filePathOrUrl == null) {
            VirtualFileUtil.$$$reportNull$$$0(12);
        }
        if (rootPathOrUrl == null) {
            VirtualFileUtil.$$$reportNull$$$0(13);
        }
        if (filePathOrUrl.length() < rootPathOrUrl.length()) {
            return null;
        }
        String path = filePathOrUrl.substring(rootPathOrUrl.length());
        if (!path.isEmpty() && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    @Nullable
    public static String getFirstFolderNameFromRelativePath(VirtualFile file, VirtualFile root) {
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
        if (StringUtil.isEmpty((String)relativePath)) {
            return null;
        }
        int firstPathComponentIndex = relativePath.indexOf(47);
        String firstFolderName = firstPathComponentIndex == -1 ? relativePath : relativePath.substring(0, firstPathComponentIndex);
        return firstFolderName;
    }

    @Nullable
    public static List<String> getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile root) {
        if (file == null) {
            VirtualFileUtil.$$$reportNull$$$0(14);
        }
        if (root == null) {
            VirtualFileUtil.$$$reportNull$$$0(15);
        }
        ArrayList<String> relativePath = new ArrayList<String>();
        for (VirtualFile currentFolder = file; currentFolder != null; currentFolder = currentFolder.getParent()) {
            if (Comparing.equal((Object)currentFolder, (Object)root)) {
                Collections.reverse(relativePath);
                return relativePath;
            }
            relativePath.add(currentFolder.getName());
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static VirtualFile getAncestorByRelativePath(@Nullable VirtualFile file, @NotNull List<String> relativePath) {
        if (relativePath == null) {
            VirtualFileUtil.$$$reportNull$$$0(16);
        }
        if (file == null) {
            return null;
        }
        boolean caseSensitive = file.isCaseSensitive();
        VirtualFile result = file;
        for (int i = relativePath.size() - 1; result != null && i >= 0; result = result.getParent(), --i) {
            String dir = relativePath.get(i);
            if (!caseSensitive ? dir.equalsIgnoreCase(result.getName()) : dir.equals(result.getName())) continue;
            return null;
        }
        return result;
    }

    public static boolean processAncestor(@NotNull VirtualFile file, @NotNull Processor<? super VirtualFile> processor, boolean strict) {
        VirtualFile ancestor;
        if (file == null) {
            VirtualFileUtil.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            VirtualFileUtil.$$$reportNull$$$0(18);
        }
        VirtualFile virtualFile = ancestor = strict ? file.getParent() : file;
        while (ancestor != null) {
            if (!processor.process((Object)ancestor)) {
                return false;
            }
            ancestor = ancestor.getParent();
        }
        return true;
    }

    @NotNull
    public static String convertToVFSPathAndNormalizeSlashes(@NotNull String path) {
        String newPath;
        if (path == null) {
            VirtualFileUtil.$$$reportNull$$$0(19);
        }
        if (!(newPath = FileUtil.toSystemIndependentName((String)path)).isEmpty() && newPath.charAt(newPath.length() - 1) == '/') {
            String string = newPath.substring(0, newPath.length() - 1);
            if (string == null) {
                VirtualFileUtil.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = newPath;
        if (string == null) {
            VirtualFileUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    public static boolean existsNewerThanTimeStamp(final @Nullable VirtualFile root, final long ts) {
        if (root == null) {
            return false;
        }
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                VirtualFileVisitor.Result result = file.getTimeStamp() > ts ? 1.skipTo((VirtualFile)root) : CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(1);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/utils/VirtualFileUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/utils/VirtualFileUtil$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        return result.skipToParent != null;
    }

    @Nullable
    public static String getRelativePath(@Nullable VirtualFile vFile, @NotNull Project project) {
        if (project == null) {
            VirtualFileUtil.$$$reportNull$$$0(22);
        }
        if (vFile != null) {
            String relativePath;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile contentRoot = fileIndex.getContentRootForFile(vFile);
            if (contentRoot == null) {
                contentRoot = fileIndex.getClassRootForFile(vFile);
            }
            if (contentRoot != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)vFile, (VirtualFile)contentRoot, (char)File.separatorChar)) != null) {
                return relativePath;
            }
        }
        return null;
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static VirtualFile findAncestorByName(@Nullable VirtualFile file, @NotNull String parentName, @NotNull Project project) {
        if (parentName == null) {
            VirtualFileUtil.$$$reportNull$$$0(23);
        }
        if (project == null) {
            VirtualFileUtil.$$$reportNull$$$0(24);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (VirtualFile parent = file; parent != null && fileIndex.isInContent(parent); parent = parent.getParent()) {
            if (!parent.isDirectory() || !parentName.equals(parent.getName())) continue;
            return parent;
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static VirtualFile getDirectAncestor(@Nullable VirtualFile file, @NotNull Project project) {
        VirtualFile parent;
        if (project == null) {
            VirtualFileUtil.$$$reportNull$$$0(25);
        }
        if (file != null && (parent = file.getParent()) != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(parent)) {
            return parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/utils/VirtualFileUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrl";
                break;
            }
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePathOrUrl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPathOrUrl";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/utils/VirtualFileUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPathsToLocalUrls";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUrl";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToVFSPathAndNormalizeSlashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileBy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "constructLocalUrl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertPathsToLocalUrls";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 20: 
            case 21: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareVirtualFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildUrl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildSystemIndependentPath";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorByRelativePath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processAncestor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertToVFSPathAndNormalizeSlashes";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorByName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDirectAncestor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 9, 20, 21 -> new IllegalStateException(string);
        };
    }

    public static class VirtualFilesComparator
    implements Comparator<VirtualFile> {
        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return VirtualFileUtil.compareVirtualFiles(file1, file2);
        }
    }
}

