/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.utils;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;

public final class RubyVirtualFileScanner {
    @NonNls
    public static final String DIRECTORY_UP_PREFIX = "../";
    @NonNls
    private static final String NAME_CHECK_PATTERN = "(_|[a-z]).*";

    private RubyVirtualFileScanner() {
    }

    public static void addRubyFiles(@Nullable VirtualFile file, final @NotNull Collection<? super VirtualFile> allFiles) {
        if (allFiles == null) {
            RubyVirtualFileScanner.$$$reportNull$$$0(0);
        }
        if (file == null) {
            return;
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (fileTypeManager.isFileIgnored(file)) {
                    return false;
                }
                if (!file.isDirectory() && RubyVirtualFileScanner.isRubyFile(file)) {
                    allFiles.add(file);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/utils/RubyVirtualFileScanner$1", "visitFile"));
            }
        });
    }

    public static boolean isRubyFile(@Nullable VirtualFile fileOrDir) {
        return fileOrDir != null && !fileOrDir.isDirectory() && fileOrDir.getFileType() instanceof RubyFileType;
    }

    public static boolean isRubyFile(@NotNull String fileName) {
        if (fileName == null) {
            RubyVirtualFileScanner.$$$reportNull$$$0(1);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return fileType instanceof RubyFileType;
    }

    public static List<VirtualFile> getRelativeFilesUnderRoot(@NotNull VirtualFile fileRoot, boolean checkName, boolean addRubyFiles, boolean addDirectories) {
        if (fileRoot == null) {
            RubyVirtualFileScanner.$$$reportNull$$$0(2);
        }
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        RubyVirtualFileScanner.getRelativeFilesUnderRootRec(fileRoot, list, checkName, addRubyFiles, addDirectories);
        return list;
    }

    private static void getRelativeFilesUnderRootRec(@NotNull VirtualFile file, final @NotNull List<? super VirtualFile> list, final boolean checkName, final boolean addRubyFiles, final boolean addDirectories) {
        if (file == null) {
            RubyVirtualFileScanner.$$$reportNull$$$0(3);
        }
        if (list == null) {
            RubyVirtualFileScanner.$$$reportNull$$$0(4);
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (fileTypeManager.isFileIgnored(file)) {
                    return false;
                }
                if (file.isDirectory()) {
                    if (checkName && !file.getName().matches(RubyVirtualFileScanner.NAME_CHECK_PATTERN)) {
                        return false;
                    }
                    if (addDirectories) {
                        list.add(file);
                    }
                } else if (RubyVirtualFileScanner.isRubyFile(file) && addRubyFiles) {
                    list.add(file);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/utils/RubyVirtualFileScanner$2", "visitFile"));
            }
        });
    }

    public static List<VirtualFile> findLibsSubDirectories(VirtualFile[] dirs) {
        ArrayList<VirtualFile> libsDirs = new ArrayList<VirtualFile>();
        for (VirtualFile dir : dirs) {
            VirtualFile lib = dir.findChild("lib");
            if (lib == null) continue;
            libsDirs.add(lib);
        }
        return libsDirs;
    }

    public static List<VirtualFile> searchFilesUnderDirectory(@Nullable Module module, @NotNull VirtualFile rootDir, boolean includeDirs, boolean includeRoot) {
        if (rootDir == null) {
            RubyVirtualFileScanner.$$$reportNull$$$0(5);
        }
        if (module == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        if (moduleFileIndex.isInContent(rootDir)) {
            if (rootDir.isDirectory()) {
                for (VirtualFile child : rootDir.getChildren()) {
                    if (!moduleFileIndex.isInContent(child) || FileTypeManager.getInstance().isFileIgnored(child) || child.isDirectory() && !includeDirs) continue;
                    files.add(child);
                }
            }
            if (includeRoot && includeDirs) {
                files.add(rootDir);
            }
        }
        return files;
    }

    public static List<String> getRelativeUrls(@NotNull VirtualFile root) {
        if (root == null) {
            RubyVirtualFileScanner.$$$reportNull$$$0(6);
        }
        assert (root.isDirectory()) : "'" + String.valueOf(root) + "' should be a directory.";
        ArrayList<String> relativeUrls = new ArrayList<String>();
        return RubyVirtualFileScanner.addRelativeUrls(root, relativeUrls);
    }

    private static List<String> addRelativeUrls(@NotNull VirtualFile rootDirectory, @NotNull List<String> relativeUrls) {
        if (rootDirectory == null) {
            RubyVirtualFileScanner.$$$reportNull$$$0(7);
        }
        if (relativeUrls == null) {
            RubyVirtualFileScanner.$$$reportNull$$$0(8);
        }
        String rootUrl = rootDirectory.getUrl() + "/";
        int length = rootUrl.length();
        HashSet list = new HashSet();
        RubyVirtualFileScanner.addRubyFiles(rootDirectory, list);
        for (VirtualFile file : list) {
            String url = file.getUrl();
            relativeUrls.add(url.substring(length));
        }
        return relativeUrls;
    }

    public static List<String> getRelativeUrlsInProject(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile directory) {
        if (fileIndex == null) {
            RubyVirtualFileScanner.$$$reportNull$$$0(9);
        }
        if (directory == null) {
            RubyVirtualFileScanner.$$$reportNull$$$0(10);
        }
        ArrayList<String> urls = new ArrayList<String>();
        Object prefix = "";
        for (VirtualFile anchor = directory; anchor != null && fileIndex.isInContent(anchor); anchor = anchor.getParent()) {
            for (String relativeUrl : RubyVirtualFileScanner.getRelativeUrls(anchor)) {
                urls.add((String)prefix + relativeUrl);
            }
            prefix = DIRECTORY_UP_PREFIX + (String)prefix;
        }
        return urls;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDirectory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeUrls";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/utils/RubyVirtualFileScanner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addRubyFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRubyFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativeFilesUnderRoot";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativeFilesUnderRootRec";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "searchFilesUnderDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativeUrls";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addRelativeUrls";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativeUrlsInProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

