/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.actions.generate.RPropertyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RubyPropertiesUtil {
    @Nullable
    public static RCall findFirstPropertyDeclaration(RClass rClass, RPropertyType type) {
        Symbol container = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
        if (container == null) {
            return null;
        }
        switch (type) {
            case READER: {
                for (Symbol reader : RubyPropertiesUtil.getReaders(rClass)) {
                    if (!RubyPropertiesUtil.isReader(reader) || !RubyPropertiesUtil.isInTheSameClassDeclaration(reader, rClass)) continue;
                    return RubyPropertiesUtil.getAccessorDeclarationCall(reader);
                }
                return null;
            }
            case WRITER: {
                for (Symbol writer : RubyPropertiesUtil.getWriters(rClass)) {
                    if (!RubyPropertiesUtil.isWriter(writer) || !RubyPropertiesUtil.isInTheSameClassDeclaration(writer, rClass)) continue;
                    return RubyPropertiesUtil.getAccessorDeclarationCall(writer);
                }
                return null;
            }
            case ACCESSOR: {
                ArrayList<Symbol> all = new ArrayList<Symbol>();
                all.addAll(RubyPropertiesUtil.getReaders(rClass));
                all.addAll(RubyPropertiesUtil.getWriters(rClass));
                for (Symbol symbol : all) {
                    if (!RubyPropertiesUtil.isAccessor(symbol) || !RubyPropertiesUtil.isInTheSameClassDeclaration(symbol, rClass)) continue;
                    return RubyPropertiesUtil.getAccessorDeclarationCall(symbol);
                }
                break;
            }
        }
        return null;
    }

    public static boolean isReader(@NotNull Symbol symbol) {
        if (symbol == null) {
            RubyPropertiesUtil.$$$reportNull$$$0(0);
        }
        return RubyPropertiesUtil.isPropertyOfType(symbol, RPropertyType.READER);
    }

    public static boolean isWriter(@NotNull Symbol symbol) {
        if (symbol == null) {
            RubyPropertiesUtil.$$$reportNull$$$0(1);
        }
        return RubyPropertiesUtil.isPropertyOfType(symbol, RPropertyType.WRITER);
    }

    public static boolean isAccessor(@NotNull Symbol symbol) {
        if (symbol == null) {
            RubyPropertiesUtil.$$$reportNull$$$0(2);
        }
        return RubyPropertiesUtil.isPropertyOfType(symbol, RPropertyType.ACCESSOR);
    }

    public static boolean isInTheSameClassDeclaration(Symbol symbol, RClass rClass) {
        PsiElement element = symbol.getPsiElement();
        return element != null && PsiTreeUtil.isAncestor((PsiElement)rClass, (PsiElement)element, (boolean)false);
    }

    private static boolean isPropertyOfType(@NotNull Symbol symbol, @NotNull RPropertyType type) {
        RCall rCall;
        if (symbol == null) {
            RubyPropertiesUtil.$$$reportNull$$$0(3);
        }
        if (type == null) {
            RubyPropertiesUtil.$$$reportNull$$$0(4);
        }
        return (rCall = RubyPropertiesUtil.getAccessorDeclarationCall(symbol)) != null && type.toString().equals(rCall.getCallType().getCommandName());
    }

    public static List<Symbol> getWriters(RClass rClass) {
        return RubyPropertiesUtil.getSymbolsByType(rClass, Type.FIELD_WRITER);
    }

    public static List<Symbol> getReaders(RClass rClass) {
        return RubyPropertiesUtil.getSymbolsByType(rClass, Type.FIELD_READER);
    }

    public static List<Symbol> getAccessors(RClass rClass) {
        Symbol container = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
        if (container == null) {
            return Collections.emptyList();
        }
        HashSet all = new HashSet();
        all.addAll(Symbol.getSymbolsByFilter((Symbol)container, (Predicate)Symbol.Filter.byType((Type)Type.FIELD_READER), (PsiElement)rClass));
        all.addAll(Symbol.getSymbolsByFilter((Symbol)container, (Predicate)Symbol.Filter.byType((Type)Type.FIELD_WRITER), (PsiElement)rClass));
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (Symbol symbol : all) {
            if (!RubyPropertiesUtil.isAccessor(symbol)) continue;
            result.add(symbol);
        }
        return result;
    }

    public static List<Symbol> getSymbolsByType(RClass rClass, Type type) {
        Symbol container = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
        if (container == null) {
            return Collections.emptyList();
        }
        return Symbol.getSymbolsByFilter((Symbol)container, (Predicate)Symbol.Filter.byType((Type)type), (PsiElement)rClass);
    }

    public static boolean removeProperty(String name, RClass rClass, RPropertyType type) {
        boolean removed = false;
        ArrayList<Symbol> all = new ArrayList<Symbol>();
        all.addAll(RubyPropertiesUtil.getReaders(rClass));
        all.addAll(RubyPropertiesUtil.getWriters(rClass));
        ArrayList<RCall> calls = new ArrayList<RCall>();
        for (Symbol symbol : all) {
            if (!name.equals(RubyPropertiesUtil.getPropertyName(symbol)) || !RubyPropertiesUtil.isPropertyOfType(symbol, type) || !RubyPropertiesUtil.isInTheSameClassDeclaration(symbol, rClass)) continue;
            calls.add(RubyPropertiesUtil.getAccessorDeclarationCall(symbol));
        }
        if (!calls.isEmpty()) {
            removed = true;
            for (RCall call : calls) {
                ArrayList<String> params = new ArrayList<String>();
                for (RPsiElement arg : call.getCallArguments().getElements()) {
                    if (arg.getText().trim().equals(":" + name)) continue;
                    params.add(arg.getText());
                }
                if (params.isEmpty()) {
                    call.delete();
                    continue;
                }
                String text = call.getCommand() + " " + StringUtil.join(params, (String)", ");
                RExpression newCall = RubyElementFactoryCore.createExpressionFromText((PsiElement)rClass, (String)text);
                call.replace((PsiElement)newCall);
            }
        }
        return removed;
    }

    @Nullable
    public static String getPropertyName(@NotNull Symbol symbol) {
        String name;
        if (symbol == null) {
            RubyPropertiesUtil.$$$reportNull$$$0(5);
        }
        return (name = symbol.getName()) == null || !name.endsWith("=") ? name : name.substring(0, name.length() - 1);
    }

    @Nullable
    private static RCall getAccessorDeclarationCall(@NotNull Symbol symbol) {
        if (symbol == null) {
            RubyPropertiesUtil.$$$reportNull$$$0(6);
        }
        return (RCall)PsiTreeUtil.getParentOfType((PsiElement)symbol.getPsiElement(), RCall.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/utils/RubyPropertiesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isReader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAccessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyOfType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAccessorDeclarationCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

