/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.utils;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public final class OSUtil {
    @NonNls
    private static final String PATH_NAME = OSUtil.getPathVariableName();
    private static final Logger LOG = Logger.getInstance(OSUtil.class);
    private static final Pattern MAC_OS_PATH_IN_PROFILE = Pattern.compile("^\\s*PATH\\s*=(.*)$", 8);
    @NonNls
    private static final String UNIX_PATH_NAME = "PATH";
    @NonNls
    private static final String WINDOWS_DEFAULT_PATH_NAME = "Path";

    private OSUtil() {
    }

    @NotNull
    public static Collection<String> findExecutableOnWindowsRootAndProgramFiles(final @NotNull String name) {
        if (name == null) {
            OSUtil.$$$reportNull$$$0(0);
        }
        final ArrayList<String> paths = new ArrayList<String>();
        Task.Modal task = new Task.Modal(null, RBundle.message((String)"sdk.searching.for", (Object[])new Object[]{name}), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (File root : File.listRoots()) {
                    File[] files;
                    if (!root.isDirectory() || (files = root.listFiles()) == null) continue;
                    for (File file : files) {
                        File rubyExe;
                        indicator.checkCanceled();
                        if (!file.isDirectory() || !file.getName().toLowerCase(Locale.getDefault()).startsWith("ruby") || !(rubyExe = new File(FileUtil.join((String[])new String[]{file.getPath(), "bin", name}))).exists()) continue;
                        paths.add(rubyExe.getPath());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/utils/OSUtil$1", "run"));
            }
        };
        Application application = ApplicationManager.getApplication();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (application != null && !application.isDispatchThread() && indicator != null) {
            task.run(indicator);
        } else {
            task.queue();
        }
        ArrayList<String> arrayList = paths;
        if (arrayList == null) {
            OSUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static String getPathVariableName() {
        if (SystemInfo.isWindows) {
            String defaultPathName = WINDOWS_DEFAULT_PATH_NAME;
            for (String key : EnvironmentUtil.getEnvironmentMap().keySet()) {
                if (!WINDOWS_DEFAULT_PATH_NAME.equalsIgnoreCase(key)) continue;
                String string = key;
                if (string == null) {
                    OSUtil.$$$reportNull$$$0(2);
                }
                return string;
            }
            return WINDOWS_DEFAULT_PATH_NAME;
        }
        return UNIX_PATH_NAME;
    }

    @NotNull
    public static String getPathEnvVariableName(@NotNull RubySdkSystemAccessor accessor) {
        if (accessor == null) {
            OSUtil.$$$reportNull$$$0(3);
        }
        if (accessor.isWindows()) {
            return WINDOWS_DEFAULT_PATH_NAME;
        }
        return UNIX_PATH_NAME;
    }

    @Nullable
    public static String getPathEnvVariableName() {
        if (SystemInfo.isWindows || SystemInfo.isUnix) {
            return PATH_NAME;
        }
        LOG.error(RBundle.message((String)"os.not.supported"));
        return null;
    }

    public static String appendToPATHenvVariable(@Nullable String path, @NotNull String additionalPath) {
        if (additionalPath == null) {
            OSUtil.$$$reportNull$$$0(4);
        }
        Object pathValue = StringUtil.isEmpty((String)path) ? additionalPath : path + File.pathSeparatorChar + additionalPath;
        return FileUtil.toSystemDependentName((String)pathValue);
    }

    public static String prependToPathEnvVariable(@Nullable String path, @NotNull String additionalPath) {
        if (additionalPath == null) {
            OSUtil.$$$reportNull$$$0(5);
        }
        Object pathValue = StringUtil.isEmpty((String)path) ? additionalPath : additionalPath + File.pathSeparatorChar + path;
        return FileUtil.toSystemDependentName((String)pathValue);
    }

    public static String prependToPathEnvVariable(@Nullable String path, @NotNull String additionalPath, @NotNull RubySdkSystemAccessor accessor) {
        if (additionalPath == null) {
            OSUtil.$$$reportNull$$$0(6);
        }
        if (accessor == null) {
            OSUtil.$$$reportNull$$$0(7);
        }
        Object pathValue = StringUtil.isEmpty((String)path) ? additionalPath : additionalPath + accessor.getPathSeparator() + path;
        return pathValue;
    }

    public static String getIdeaSystemPath() {
        return EnvironmentUtil.getValue((String)StringUtil.notNullize((String)OSUtil.getPathEnvVariableName()));
    }

    @NotNull
    public static List<String> findExecutableInMacOSProfile(@NotNull String exeName) {
        String fileText;
        File profile;
        if (exeName == null) {
            OSUtil.$$$reportNull$$$0(8);
        }
        if ((profile = OSUtil.getMacOsProfile()) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                OSUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        try {
            fileText = FileUtil.loadFile((File)profile);
        }
        catch (IOException e) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                OSUtil.$$$reportNull$$$0(10);
            }
            return list;
        }
        String additionalPath = OSUtil.extractAdditionalPathFromProfileText(fileText);
        return OSUtil.findExecutablesForNameInPathEnvValue(exeName, additionalPath);
    }

    @ApiStatus.Internal
    @Nullable
    public static String extractAdditionalPathFromProfileText(String fileText) {
        Matcher matcher = MAC_OS_PATH_IN_PROFILE.matcher(fileText);
        if (matcher.find()) {
            String path = matcher.group(1);
            return path.trim();
        }
        return null;
    }

    @Nullable
    private static File getMacOsProfile() {
        String userHomePath = SystemProperties.getUserHome();
        if (StringUtil.isEmpty((String)userHomePath)) {
            return null;
        }
        String profilePath = FileUtil.toSystemDependentName((String)(userHomePath + "/.profile"));
        File profile = new File(profilePath);
        try {
            if (profile.exists() && profile.isFile()) {
                return profile;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static List<String> findExecutablesByName(@NotNull String exeName) {
        if (exeName == null) {
            OSUtil.$$$reportNull$$$0(11);
        }
        return OSUtil.findExecutablesForNameInPathEnvValue(exeName, OSUtil.getIdeaSystemPath());
    }

    @NotNull
    private static List<String> findExecutablesForNameInPathEnvValue(@NotNull String exeName, @Nullable String pathEnvVar) {
        if (exeName == null) {
            OSUtil.$$$reportNull$$$0(12);
        }
        ArrayList<String> executables = new ArrayList<String>();
        if (pathEnvVar != null) {
            StringTokenizer st = new StringTokenizer(pathEnvVar, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String pathItem = VirtualFileUtil.convertToVFSPathAndNormalizeSlashes(st.nextToken());
                String executablePath = pathItem + "/" + exeName;
                String systemDependentExecutablePath = FileUtil.toSystemDependentName((String)executablePath);
                File possibleExecutable = new File(systemDependentExecutablePath);
                try {
                    if (!possibleExecutable.exists() || !possibleExecutable.isFile()) continue;
                    executables.add(systemDependentExecutablePath);
                }
                catch (SecurityException securityException) {}
            }
        }
        ArrayList<String> arrayList = executables;
        if (arrayList == null) {
            OSUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static String prependToRUBYLIBEnvVariable(@NotNull RubySdkSystemAccessor accessor, @Nullable String rubyLibVal, @NotNull String additionalPath) {
        if (accessor == null) {
            OSUtil.$$$reportNull$$$0(14);
        }
        if (additionalPath == null) {
            OSUtil.$$$reportNull$$$0(15);
        }
        String normalizedPath = FileUtil.toSystemIndependentName((String)additionalPath);
        String string = StringUtil.isEmpty((String)rubyLibVal) ? normalizedPath : String.join((CharSequence)accessor.getPathSeparator(), normalizedPath, rubyLibVal);
        if (string == null) {
            OSUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static void appendToEnvVariable(@NotNull String envVariableName, @NotNull String value, @NotNull Map<String, String> env, @NotNull String separator) {
        String currentValue;
        if (envVariableName == null) {
            OSUtil.$$$reportNull$$$0(17);
        }
        if (value == null) {
            OSUtil.$$$reportNull$$$0(18);
        }
        if (env == null) {
            OSUtil.$$$reportNull$$$0(19);
        }
        if (separator == null) {
            OSUtil.$$$reportNull$$$0(20);
        }
        Object newValue = StringUtil.isEmpty((String)(currentValue = env.get(envVariableName))) ? value : currentValue + separator + value;
        env.put(envVariableName, (String)newValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 9, 10, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/utils/OSUtil";
                break;
            }
            case 3: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalPath";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exeName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVariableName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/utils/OSUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findExecutableOnWindowsRootAndProgramFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathVariableName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findExecutableInMacOSProfile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findExecutablesForNameInPathEnvValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "prependToRUBYLIBEnvVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findExecutableOnWindowsRootAndProgramFiles";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 13: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPathEnvVariableName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendToPATHenvVariable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prependToPathEnvVariable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findExecutableInMacOSProfile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findExecutablesByName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findExecutablesForNameInPathEnvValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prependToRUBYLIBEnvVariable";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendToEnvVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 9, 10, 13, 16 -> new IllegalStateException(string);
        };
    }
}

