/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.structure;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyFileStructureViewProvider;
import org.jetbrains.plugins.ruby.testing.shoulda.ShouldaUtil;
import org.jetbrains.plugins.ruby.testing.shoulda.structure.ShouldaStructureViewModel;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;
import org.jetbrains.plugins.ruby.testing.testunit.structure.RTUnitStructureViewModel;

public final class RTUnitOrShouldaStructureViewProvider
implements RubyFileStructureViewProvider {
    @Override
    @Nullable
    public StructureViewBuilder createStructureViewBuilder(final @NotNull RFile file) {
        if (file == null) {
            RTUnitOrShouldaStructureViewProvider.$$$reportNull$$$0(0);
        }
        if (RTUnitOrShouldaStructureViewProvider.isInTestUnitFile(file)) {
            Sdk moduleSdk;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            Sdk sdk = moduleSdk = module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null;
            if (RTUnitOrShouldaStructureViewProvider.canShouldaBeAvailableIn(module, moduleSdk)) {
                return new TreeBasedStructureViewBuilder(this){

                    @NotNull
                    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                        return new ShouldaStructureViewModel(file, editor);
                    }

                    public boolean isRootNodeShown() {
                        return false;
                    }
                };
            }
            final boolean allowTestClosureSyntax = RTUnitOrShouldaStructureViewProvider.canActiveSupportBeAvailableIn(module, moduleSdk);
            return new TreeBasedStructureViewBuilder(this){

                @NotNull
                public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                    return new RTUnitStructureViewModel(file, editor, allowTestClosureSyntax);
                }

                public boolean isRootNodeShown() {
                    return false;
                }
            };
        }
        return null;
    }

    private static boolean canShouldaBeAvailableIn(@Nullable Module module, @Nullable Sdk moduleSdk) {
        if (moduleSdk != null) {
            boolean gemInstalled = false;
            for (String gemName : ShouldaUtil.SHOULDA_GEM_NAMES) {
                GemInfo shouldaGem = RubyGemSearchUtil.findGem(module, moduleSdk, gemName);
                if (shouldaGem == null) continue;
                gemInstalled = true;
                break;
            }
            if (!gemInstalled) {
                return false;
            }
        }
        return true;
    }

    private static boolean canActiveSupportBeAvailableIn(@Nullable Module module, @Nullable Sdk moduleSdk) {
        GemInfo activesupportGem;
        return moduleSdk == null || (activesupportGem = RubyGemSearchUtil.findGem(module, moduleSdk, "activesupport")) != null;
    }

    private static boolean isInTestUnitFile(@NotNull RFile file) {
        if (file == null) {
            RTUnitOrShouldaStructureViewProvider.$$$reportNull$$$0(1);
        }
        return TestUnitUtil.isFileWithValidTestUnitFileName(file.getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/structure/RTUnitOrShouldaStructureViewProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createStructureViewBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInTestUnitFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

