/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.runConfigurations;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RNamespace;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RStringLiteralBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.testing.BddTestsUtil;

public final class TestUnitUtil {
    @NonNls
    private static final String UNIT_TEST_METHOD_PREFIX = "test_";
    public static final String TEST_UNIT_TEST_CLOSURE_SHORT_NAME = "test";
    public static final String ACTIVE_SUPPORT_TEST_CLOSURE_SHORT_NAME = "test";
    public static final String ACTIVE_SUPPORT_TEST_SETUP_SHORT_NAME = "setup";
    public static final String ACTIVE_SUPPORT_TEST_TEARDOWN_SHORT_NAME = "teardown";
    @NonNls
    private static final Set<String> TEST_DEF_CALL_SHORT_NAMES = new HashSet<String>(Collections.singletonList("test"));
    public static final Set<String> TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES = new HashSet<String>();
    public static final String MINITEST_TEST_NAME_PREFIX = "test_\\d+_";
    private static final String TEST_FOLDER = "test";
    @NonNls
    public static final Set<String> MINITEST_SPEC_GROUP_CALL_SHORT_NAMES;
    @NonNls
    public static final Set<String> MINITEST_SPEC_EXAMPLE_CALL_SHORT_NAMES;
    @NonNls
    public static final Set<String> MINITEST_SPEC_SETUP_TEARDOWN_CALL_SHORT_NAMES;
    public static final Set<String> MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES;
    public static final Set<String> MINITEST_SPEC_CONTAINERS;
    public static final String TUNIT_TEST_FILE_PREFIX = "test_";
    public static final String TEST_UNIT_GEM_NAME = "test-unit";
    public static final String MINITEST_GEM_NAME = "minitest";
    private static final String[] TEST_UNIT_GEM_NAMES;
    public static final String GENERATORS_R30_PREFIX = "test_unit:";
    @NonNls
    private static final String TEST_UNIT_PREFIX = "test: ";

    private TestUnitUtil() {
    }

    public static boolean isInActiveSupportTestClosureBlock(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.$$$reportNull$$$0(0);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, TEST_DEF_CALL_SHORT_NAMES, null) != null;
    }

    public static boolean isInActiveSupportTestClosureRegion(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.$$$reportNull$$$0(1);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, TEST_DEF_CALL_SHORT_NAMES, null);
    }

    public static boolean isInTestClosureRegion(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.$$$reportNull$$$0(2);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, Set.of("test"), null);
    }

    public static boolean isInMinitestSpecExampleOrGroupRegion(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.$$$reportNull$$$0(3);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, MINITEST_SPEC_CONTAINERS, null);
    }

    public static boolean isTestUnitFile(Project project, @Nullable VirtualFile file) {
        if (!TestUnitUtil.isFileWithValidTestUnitFileName(file)) {
            return false;
        }
        return TestUnitUtil.isTestUnitSupportLoaded(project);
    }

    public static boolean isTestUnitSupportLoaded(Project project) {
        return SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.of((String)"Test::Unit::TestCase"), null) != null;
    }

    @Nullable
    public static Pair<String, String> determineMinitestSpecConfigurationNameAndFilter(@NotNull Module module, @NotNull PsiElement context) {
        Object runConfigurationName;
        Pair<String, String> groupAndTestName;
        if (module == null) {
            TestUnitUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TestUnitUtil.$$$reportNull$$$0(5);
        }
        if ((groupAndTestName = TestUnitUtil.determineMinitestSpecGroupAndName(context)) == null) {
            return null;
        }
        String groups = (String)groupAndTestName.first;
        String testName = (String)groupAndTestName.second;
        String namespace = TestUnitUtil.determineTestNamespace(context);
        String minitestVersion = TestUnitUtil.getMinitestVersion(module);
        if (minitestVersion != null && VersionComparatorUtil.compare((String)minitestVersion, (String)"3.1.0") < 0) {
            groups = null;
        }
        if (testName != null) {
            runConfigurationName = (String)groupAndTestName.getSecond();
            if (groups != null) {
                runConfigurationName = (String)runConfigurationName + RBundle.message((String)"ruby.test.test.name.group.delimiter") + groups;
            }
        } else {
            runConfigurationName = groups;
        }
        String methodFilterName = TestUnitUtil.createTestMethodFilterForMethodName(namespace, groups, testName);
        return new Pair(runConfigurationName, (Object)methodFilterName);
    }

    @Nullable
    public static String determineTestNamespace(@NotNull PsiElement context) {
        if (context == null) {
            TestUnitUtil.$$$reportNull$$$0(6);
        }
        ArrayList<String> namespaces = new ArrayList<String>();
        PsiElement element = context;
        while (element != null) {
            RModule moduleParent;
            String name;
            RClass classParent;
            RNamespace namespace = (RNamespace)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{RClass.class, RModule.class});
            if (namespace instanceof RClass && (classParent = (RClass)namespace).getClassName() != null) {
                name = classParent.getClassName().getName();
                if (name != null) {
                    namespaces.add(0, name);
                }
                element = classParent;
                continue;
            }
            if (namespace instanceof RModule && (moduleParent = (RModule)namespace).getModuleName() != null) {
                name = moduleParent.getModuleName().getName();
                if (name != null) {
                    namespaces.add(0, name);
                }
                element = moduleParent;
                continue;
            }
            element = null;
        }
        return namespaces.isEmpty() ? null : StringUtil.join(namespaces, (String)"::");
    }

    @Nullable
    private static Pair<String, String> determineMinitestSpecGroupAndName(@NotNull PsiElement context) {
        if (context == null) {
            TestUnitUtil.$$$reportNull$$$0(7);
        }
        ArrayList<String> groups = new ArrayList<String>();
        String testName = null;
        PsiElement element = context;
        while (element != null) {
            RPsiElement argument;
            String blockName;
            RDoBlockCall possibleCall = (RDoBlockCall)PsiTreeUtil.getParentOfType((PsiElement)element, RDoBlockCall.class);
            if (possibleCall != null && !possibleCall.getArguments().isEmpty() && (blockName = (argument = (RPsiElement)possibleCall.getArguments().get(0)) instanceof RStringLiteralBase ? ((RStringLiteralBase)argument).getContent() : (argument instanceof RConstant ? argument.getName() : (argument instanceof RColonReference ? String.join((CharSequence)"::", ContainerUtil.map((Collection)((RColonReference)argument).getConstantList(), constant -> constant.getName())) : (argument instanceof RSymbol ? ((RSymbol)argument).getValue() : null)))) != null) {
                String command = StringUtil.notNullize((String)possibleCall.getCommand());
                if (MINITEST_SPEC_GROUP_CALL_SHORT_NAMES.contains(command)) {
                    groups.add(0, blockName);
                }
                if (MINITEST_SPEC_EXAMPLE_CALL_SHORT_NAMES.contains(command)) {
                    testName = blockName;
                }
            }
            element = possibleCall;
        }
        if (!groups.isEmpty() || testName != null) {
            return new Pair((Object)(groups.isEmpty() ? null : StringUtil.join(groups, (String)"::")), testName);
        }
        return null;
    }

    @Nullable
    private static String getMinitestVersion(@NotNull Module module) {
        GemInfo gemInfo;
        if (module == null) {
            TestUnitUtil.$$$reportNull$$$0(8);
        }
        if ((gemInfo = RubyProjectGemSearchService.Companion.findGem(module, MINITEST_GEM_NAME)) != null) {
            return gemInfo.getVersion();
        }
        return null;
    }

    @Nullable
    public static String determineCurrentTestNameByRailsTestClosure(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.$$$reportNull$$$0(9);
        }
        return TestUnitUtil.determineCurrentTestNameByTestClosure(psiElement, name -> "test_" + name.replaceAll("\\s+", "_"), "test");
    }

    @Nullable
    public static String determineCurrentTestNameByTestUnitTestClosure(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.$$$reportNull$$$0(10);
        }
        return TestUnitUtil.determineCurrentTestNameByTestClosure(psiElement, name -> TEST_UNIT_PREFIX + name, "test");
    }

    @Nullable
    public static String unmangleTestUnitName(@Nullable String testUnitName) {
        if (testUnitName == null) {
            return null;
        }
        return StringUtil.trimStart((String)testUnitName, (String)TEST_UNIT_PREFIX);
    }

    @Nullable
    private static String determineCurrentTestNameByTestClosure(@NotNull PsiElement psiElement, final @NotNull Function<String, String> testNameGenerator, @NotNull String testClosureName) {
        if (psiElement == null) {
            TestUnitUtil.$$$reportNull$$$0(11);
        }
        if (testNameGenerator == null) {
            TestUnitUtil.$$$reportNull$$$0(12);
        }
        if (testClosureName == null) {
            TestUnitUtil.$$$reportNull$$$0(13);
        }
        final Ref testNameRef = new Ref();
        PsiCallable testNameBuilder = new PsiCallable(){

            @Override
            public void processCall(RCallArguments arguments) {
                String firstArg = arguments.evaluateArgument(0);
                if (firstArg != null) {
                    testNameRef.set((Object)((String)testNameGenerator.apply(firstArg)));
                }
            }
        };
        TestUnitUtil.processTestClosuresInPath(psiElement, testNameBuilder, testClosureName);
        return (String)testNameRef.get();
    }

    @NotNull
    public static String getRailsTestFolderPathOrUrl(@NotNull String railsAppRootPathOrUlr) {
        if (railsAppRootPathOrUlr == null) {
            TestUnitUtil.$$$reportNull$$$0(14);
        }
        String string = railsAppRootPathOrUlr + "/test";
        if (string == null) {
            TestUnitUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static void processTestClosuresInPath(@Nullable PsiElement psiElement, PsiCallable testNameBuilder, String ... closureShortNames) {
        RPsiElement element;
        RPsiElement rPsiElement = element = psiElement instanceof RPsiElement ? (RPsiElement)psiElement : (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RPsiElement.class);
        if (element == null) {
            return;
        }
        RubyPsiInterpreter interpreter = new RubyPsiInterpreter(true);
        interpreter.registerCallable(testNameBuilder, closureShortNames);
        interpreter.interpretCallsTreePath((PsiElement)element, null);
    }

    public static boolean isTestClosureCall(@NotNull RPossibleCall call) {
        if (call == null) {
            TestUnitUtil.$$$reportNull$$$0(16);
        }
        return "test".equals(call.getCommand());
    }

    public static boolean isMinitestExampleGroupCall(@NotNull RPossibleCall call) {
        if (call == null) {
            TestUnitUtil.$$$reportNull$$$0(17);
        }
        return MINITEST_SPEC_GROUP_CALL_SHORT_NAMES.contains(StringUtil.notNullize((String)call.getCommand()));
    }

    public static boolean isUnitTestMethod(@NotNull RMethod rMethod) {
        if (rMethod == null) {
            TestUnitUtil.$$$reportNull$$$0(18);
        }
        return rMethod.getName().startsWith("test_");
    }

    public static boolean isTestClosureSetupTeardownCall(@NotNull RPossibleCall call) {
        String name;
        if (call == null) {
            TestUnitUtil.$$$reportNull$$$0(19);
        }
        return ACTIVE_SUPPORT_TEST_SETUP_SHORT_NAME.equals(name = call.getCommand()) || ACTIVE_SUPPORT_TEST_TEARDOWN_SHORT_NAME.equals(name);
    }

    @Nullable
    public static RPsiElement findValidTestClosure(@NotNull String name, @NotNull RClass rClass) {
        if (name == null) {
            TestUnitUtil.$$$reportNull$$$0(20);
        }
        if (rClass == null) {
            TestUnitUtil.$$$reportNull$$$0(21);
        }
        List<RPsiElement> testClosures = TestUnitUtil.collectAllTestClosuresFrom(rClass);
        for (RPsiElement testClosure : testClosures) {
            String testName = TestUnitUtil.determineCurrentTestNameByRailsTestClosure((PsiElement)testClosure);
            if (!name.equals(testName)) continue;
            return testClosure;
        }
        return null;
    }

    @NotNull
    public static List<RPsiElement> collectAllTestClosuresFrom(@NotNull RClass rClass) {
        if (rClass == null) {
            TestUnitUtil.$$$reportNull$$$0(22);
        }
        ArrayList<RPsiElement> testClosureBlocks = new ArrayList<RPsiElement>();
        TestUnitUtil.collectAllTestClosuresFrom(rClass, testClosureBlocks);
        List<Object> list = !testClosureBlocks.isEmpty() ? testClosureBlocks : Collections.emptyList();
        if (list == null) {
            TestUnitUtil.$$$reportNull$$$0(23);
        }
        return list;
    }

    private static void collectAllTestClosuresFrom(RClass rClass, List<RPsiElement> exampleLikeElements) {
        List statements = rClass.getStatements();
        for (RPsiElement statement : statements) {
            RPossibleCall possibleCall;
            if (!(statement instanceof RPossibleCall) || !TestUnitUtil.isTestClosureCall(possibleCall = (RPossibleCall)statement)) continue;
            exampleLikeElements.add(statement);
        }
    }

    public static boolean isFileWithValidTestUnitFileName(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            TestUnitUtil.$$$reportNull$$$0(24);
        }
        return TestUnitUtil.isFileWithValidTestUnitFileName(psiFile, null, true);
    }

    public static boolean isFileWithValidTestUnitFileName(@Nullable VirtualFile file) {
        return TestUnitUtil.isFileWithValidTestUnitFileName(null, file, true);
    }

    public static boolean isFileWithValidMinitestFileName(@Nullable VirtualFile file) {
        return TestUnitUtil.isFileWithValidTestUnitFileName(file) || BddTestsUtil.isFileWithSpecTestFileName(file);
    }

    public static boolean isFileWithValidMinitestFileName(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            TestUnitUtil.$$$reportNull$$$0(25);
        }
        return TestUnitUtil.isFileWithValidMinitestFileName(psiFile.getVirtualFile());
    }

    public static boolean isFileWithValidTestUnitFileName(@Nullable VirtualFile file, boolean checkTestPrefixConvention) {
        return TestUnitUtil.isFileWithValidTestUnitFileName(null, file, checkTestPrefixConvention);
    }

    public static boolean isFileWithValidTestUnitFileName(@Nullable PsiFile psiFile, @Nullable VirtualFile file, boolean checkTestPrefixConvention) {
        if (psiFile != null && file == null) {
            file = psiFile.getVirtualFile();
        }
        if (file == null || file.isDirectory()) {
            return false;
        }
        if (!"rb".equals(file.getExtension())) {
            return false;
        }
        String fileNameWithoutExt = file.getNameWithoutExtension();
        if (fileNameWithoutExt.endsWith("_test") || fileNameWithoutExt.endsWith("Test")) {
            return true;
        }
        if (BddTestsUtil.isFileWithSpecTestFileName(file)) {
            return true;
        }
        return checkTestPrefixConvention && fileNameWithoutExt.startsWith("test_");
    }

    public static boolean isTestUnitSupportEnabled(@NotNull Module module) {
        if (module == null) {
            TestUnitUtil.$$$reportNull$$$0(26);
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        return TestUnitUtil.isTestUnitSupportEnabled(module, sdk);
    }

    public static boolean isTestUnitSupportEnabled(Module module, Sdk sdk) {
        if (sdk != null && !RubySdkUtil.isRuby18(sdk)) {
            return TestUnitUtil.isTestUnitGemAttached(module);
        }
        return true;
    }

    public static boolean isTestUnitGemAttached(@NotNull Module module) {
        if (module == null) {
            TestUnitUtil.$$$reportNull$$$0(27);
        }
        return GemUtil.isGemOrRailsPluginSupportEnabled(module, TEST_UNIT_GEM_NAMES, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    @Nullable
    public static RBlockCall getSimpleCoveringExampleOrBeforeAfterScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.$$$reportNull$$$0(28);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES, MINITEST_SPEC_GROUP_CALL_SHORT_NAMES);
    }

    @Nullable
    public static RBlockCall getSimpleCoveringExampleGroupScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestUnitUtil.$$$reportNull$$$0(29);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, MINITEST_SPEC_GROUP_CALL_SHORT_NAMES, MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES);
    }

    @NotNull
    public static String createTestMethodFilterForMethodName(@Nullable String namespace, @Nullable String group, @Nullable String testName) {
        String escapedGroup = (String)ObjectUtils.doIfNotNull((Object)group, it -> RubyTextUtil.escapeRegexSpecialCharacters((String)it, (Character[])new Character[]{Character.valueOf(' ')}));
        Object namespaceAndGroup = namespace != null && escapedGroup != null ? "(" + namespace + "::)?" + escapedGroup : (String)ObjectUtils.chooseNotNull((Object)namespace, (Object)escapedGroup);
        if (testName == null) {
            return TestUnitUtil.wrapWithRegexpStart((String)namespaceAndGroup + "(#|::)");
        }
        if (namespaceAndGroup == null) {
            String string = MINITEST_TEST_NAME_PREFIX + TestUnitUtil.getAlphaNumericFromSpecName(testName);
            if (string == null) {
                TestUnitUtil.$$$reportNull$$$0(30);
            }
            return string;
        }
        return TestUnitUtil.wrapWithRegexpStartEnd((String)namespaceAndGroup + "#test_\\d+_" + RubyTextUtil.escapeRegexSpecialCharacters((String)testName, (Character[])new Character[]{Character.valueOf(' ')}));
    }

    @NotNull
    public static String createTestFilterForNamespace(@NotNull String namespace) {
        if (namespace == null) {
            TestUnitUtil.$$$reportNull$$$0(31);
        }
        return TestUnitUtil.wrapWithRegexpStart(namespace + "(#|::)");
    }

    @NotNull
    public static String wrapWithRegexpStartEnd(@NotNull String string) {
        if (string == null) {
            TestUnitUtil.$$$reportNull$$$0(32);
        }
        String string2 = "^" + string + "$";
        if (string2 == null) {
            TestUnitUtil.$$$reportNull$$$0(33);
        }
        return string2;
    }

    @NotNull
    public static String wrapWithRegexpStart(@NotNull String string) {
        if (string == null) {
            TestUnitUtil.$$$reportNull$$$0(34);
        }
        String string2 = "^" + string;
        if (string2 == null) {
            TestUnitUtil.$$$reportNull$$$0(35);
        }
        return string2;
    }

    @NotNull
    private static String getAlphaNumericFromSpecName(@NotNull String specName) {
        if (specName == null) {
            TestUnitUtil.$$$reportNull$$$0(36);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < specName.length(); ++i) {
            char c = specName.charAt(i);
            if (Character.isWhitespace(c)) {
                c = '_';
            }
            if (!Character.isAlphabetic(c) && !Character.isDigit(c) && c != 95) break;
            result.append(c);
        }
        String string = result.toString();
        if (string == null) {
            TestUnitUtil.$$$reportNull$$$0(37);
        }
        return string;
    }

    public static boolean isMinitestExampleGroupBlockCall(@Nullable RPsiElement element) {
        RBlockCall blockCall;
        return element instanceof RBlockCall && MINITEST_SPEC_GROUP_CALL_SHORT_NAMES.contains(StringUtil.notNullize((String)(blockCall = (RBlockCall)element).getCommand()));
    }

    public static boolean isMinitestExampleBlockCall(@Nullable RPsiElement element) {
        RBlockCall blockCall;
        return element instanceof RBlockCall && MINITEST_SPEC_EXAMPLE_CALL_SHORT_NAMES.contains(StringUtil.notNullize((String)(blockCall = (RBlockCall)element).getCommand()));
    }

    public static boolean isMinitestBeforeAfterBlockCall(@Nullable RPsiElement element) {
        RBlockCall blockCall;
        return element instanceof RBlockCall && MINITEST_SPEC_SETUP_TEARDOWN_CALL_SHORT_NAMES.contains(StringUtil.notNullize((String)(blockCall = (RBlockCall)element).getCommand()));
    }

    static {
        TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES.addAll(TEST_DEF_CALL_SHORT_NAMES);
        TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES.add(ACTIVE_SUPPORT_TEST_SETUP_SHORT_NAME);
        TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES.add(ACTIVE_SUPPORT_TEST_TEARDOWN_SHORT_NAME);
        MINITEST_SPEC_GROUP_CALL_SHORT_NAMES = Set.of("describe");
        MINITEST_SPEC_EXAMPLE_CALL_SHORT_NAMES = Set.of("it", "specify");
        MINITEST_SPEC_SETUP_TEARDOWN_CALL_SHORT_NAMES = Set.of("before", "after");
        MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES = new HashSet<String>();
        MINITEST_SPEC_CONTAINERS = new HashSet<String>();
        MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES.addAll(MINITEST_SPEC_EXAMPLE_CALL_SHORT_NAMES);
        MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES.addAll(MINITEST_SPEC_SETUP_TEARDOWN_CALL_SHORT_NAMES);
        MINITEST_SPEC_CONTAINERS.addAll(MINITEST_SPEC_GROUP_CALL_SHORT_NAMES);
        MINITEST_SPEC_CONTAINERS.addAll(MINITEST_SPEC_EXAMPLE_CALL_SHORT_NAMES);
        TEST_UNIT_GEM_NAMES = new String[]{TEST_UNIT_GEM_NAME};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 23, 30, 33, 35, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 8: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNameGenerator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClosureName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsAppRootPathOrUlr";
                break;
            }
            case 15: 
            case 23: 
            case 30: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/TestUnitUtil";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rMethod";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/TestUnitUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRailsTestFolderPathOrUrl";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllTestClosuresFrom";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestMethodFilterForMethodName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithRegexpStartEnd";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithRegexpStart";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlphaNumericFromSpecName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInActiveSupportTestClosureBlock";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInActiveSupportTestClosureRegion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInTestClosureRegion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInMinitestSpecExampleOrGroupRegion";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "determineMinitestSpecConfigurationNameAndFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "determineTestNamespace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "determineMinitestSpecGroupAndName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMinitestVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentTestNameByRailsTestClosure";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentTestNameByTestUnitTestClosure";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentTestNameByTestClosure";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRailsTestFolderPathOrUrl";
                break;
            }
            case 15: 
            case 23: 
            case 30: 
            case 33: 
            case 35: 
            case 37: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTestClosureCall";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isMinitestExampleGroupCall";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isUnitTestMethod";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isTestClosureSetupTeardownCall";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findValidTestClosure";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectAllTestClosuresFrom";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isFileWithValidTestUnitFileName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isFileWithValidMinitestFileName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isTestUnitSupportEnabled";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isTestUnitGemAttached";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleOrBeforeAfterScope";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleGroupScope";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTestFilterForNamespace";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithRegexpStartEnd";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithRegexpStart";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAlphaNumericFromSpecName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 23, 30, 33, 35, 37 -> new IllegalStateException(string);
        };
    }
}

