/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.runConfigurations;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchService;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class TC_RubySdkUtil {
    private static final Logger LOG = Logger.getInstance(TC_RubySdkUtil.class);
    public static final String TEST_UNIT_SCRIPT_PATH = "test/unit.rb";

    private TC_RubySdkUtil() {
    }

    @Nullable
    public static String getSdkTestUnitScriptPath(@NotNull Sdk rubySdk, @Nullable Module module) throws ExecutionException {
        if (rubySdk == null) {
            TC_RubySdkUtil.$$$reportNull$$$0(0);
        }
        return TC_RubySdkUtil.getSdkTestUnitScript(rubySdk, module, TEST_UNIT_SCRIPT_PATH, true);
    }

    @Nullable
    private static String getSdkTestUnitScript(Sdk rubySdk, @Nullable Module module, String scriptPath, boolean allowMinitestFramework) throws ExecutionException {
        boolean requiresOrUsesGem;
        GemInfo testUnitGem;
        boolean isRuby18 = RubySdkUtil.isRuby18(rubySdk);
        if (module == null) {
            testUnitGem = rubySdk != null ? (GemInfo)ContainerUtil.getFirstItem(RubyGemSearchService.getInstance().findGems(rubySdk, "test-unit")) : null;
            requiresOrUsesGem = testUnitGem != null;
        } else {
            RFile bundlerFile;
            testUnitGem = RubyProjectGemSearchService.Companion.findGem(module, "test-unit");
            if (testUnitGem == null) {
                testUnitGem = RubyGemSearchUtil.findGem(module, rubySdk, "test-unit");
            }
            requiresOrUsesGem = isRuby18 ? ((bundlerFile = BundlerUtil.getGemfilePsiFile(module)) == null ? testUnitGem != null : TC_RubySdkUtil.isTestUnitGemRequired(bundlerFile, rubySdk)) : true;
        }
        if (requiresOrUsesGem) {
            if (testUnitGem == null) {
                String fullScriptPath;
                if (JRubySdkUtil.isJRubySDK(rubySdk) && FileUtil.exists((String)(fullScriptPath = FileUtil.join((String[])new String[]{JRubySdkUtil.getLibPath(rubySdk), JRubySdkUtil.isJRubyGreaterEqual19(rubySdk) ? "ruby/stdlib" : "ruby/1.8", scriptPath})))) {
                    return fullScriptPath;
                }
                if (!isRuby18 && allowMinitestFramework) {
                    return null;
                }
                throw new ExecutionException(RBundle.message((String)"ruby.test.runner.sdk.test-unit.gem.not.attached", (Object[])new Object[]{ModuleGemInfrastructure.getInstance(module).getMissingGemMessage()}));
            }
            VirtualFile libFolder = testUnitGem.getLibFolder();
            if (libFolder == null) {
                LOG.warn("Unable to find gem lib folder: " + String.valueOf(testUnitGem) + "; " + testUnitGem.getUrl());
                throw new ExecutionException(RBundle.message((String)"ruby.test.runner.sdk.gem.lib.not.found", (Object[])new Object[]{rubySdk.getHomePath()}));
            }
            VirtualFile scriptFile = libFolder.findFileByRelativePath(scriptPath);
            if (scriptFile != null) {
                return scriptFile.getPath();
            }
            LOG.warn(String.format("File '%s' not found in '%s' gem of Ruby SDK with interpreter: '%s'(%s)", scriptPath, "test-unit", rubySdk.getHomePath(), RubySdkUtil.getRubySdkAdditionalData(rubySdk).getLanguageLevel()));
            return null;
        }
        assert (isRuby18);
        return TC_RubySdkUtil.findScriptInRubySdkRoots(rubySdk, scriptPath, false);
    }

    @Nullable
    private static String findScriptInRubySdkRoots(@NotNull Sdk rubySdk, @NotNull String scriptRelativePath, boolean suppressError) throws ExecutionException {
        VirtualFile[] loadPathFiles;
        if (rubySdk == null) {
            TC_RubySdkUtil.$$$reportNull$$$0(1);
        }
        if (scriptRelativePath == null) {
            TC_RubySdkUtil.$$$reportNull$$$0(2);
        }
        for (VirtualFile file : loadPathFiles = RubySdkUtil.getSdkRoots(rubySdk)) {
            VirtualFile scriptFile = file.findFileByRelativePath(scriptRelativePath);
            if (scriptFile == null) continue;
            return scriptFile.getPath();
        }
        if (suppressError) {
            return null;
        }
        throw new ExecutionException(RBundle.message((String)"ruby.test.runner.sdk.script.not.found", (Object[])new Object[]{scriptRelativePath, rubySdk.getHomePath()}));
    }

    private static boolean isTestUnitGemRequired(@NotNull RFile environmentConfigFile, @NotNull Sdk sdk) {
        if (environmentConfigFile == null) {
            TC_RubySdkUtil.$$$reportNull$$$0(3);
        }
        if (sdk == null) {
            TC_RubySdkUtil.$$$reportNull$$$0(4);
        }
        return BundlerUtil.isGemMentioned(environmentConfigFile, sdk, "test-unit");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptRelativePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentConfigFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/TC_RubySdkUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSdkTestUnitScriptPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findScriptInRubySdkRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestUnitGemRequired";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

