/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.runConfigurations;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.testing.RubyQualifiedNameUrlProvider;

public class RubySmtRunnerConsoleProperties
extends SMTRunnerConsoleProperties
implements SMCustomMessagesParsing {
    public RubySmtRunnerConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor) {
        if (config == null) {
            RubySmtRunnerConsoleProperties.$$$reportNull$$$0(0);
        }
        if (testFrameworkName == null) {
            RubySmtRunnerConsoleProperties.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            RubySmtRunnerConsoleProperties.$$$reportNull$$$0(2);
        }
        super(config, testFrameworkName, executor);
    }

    @NotNull
    public SMTestLocator getTestLocator() {
        RubyQualifiedNameUrlProvider rubyQualifiedNameUrlProvider = RubyQualifiedNameUrlProvider.INSTANCE;
        if (rubyQualifiedNameUrlProvider == null) {
            RubySmtRunnerConsoleProperties.$$$reportNull$$$0(3);
        }
        return rubyQualifiedNameUrlProvider;
    }

    @NotNull
    public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        if (testFrameworkName == null) {
            RubySmtRunnerConsoleProperties.$$$reportNull$$$0(4);
        }
        if (consoleProperties == null) {
            RubySmtRunnerConsoleProperties.$$$reportNull$$$0(5);
        }
        return !SystemInfo.isWindows ? new OutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties) : new OutputToGeneralTestEventsConverter(this, testFrameworkName, consoleProperties){
            @NotNull
            final Map<Key<?>, MySMBuffer> myType2Buffer = new ConcurrentHashMap();

            public void process(@NotNull String text, @NotNull Key outputType) {
                ProcessOutputType type;
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((type = (ProcessOutputType)ObjectUtils.doIfCast((Object)outputType, ProcessOutputType.class, ProcessOutputType::getBaseOutputType)) == null) {
                    super.process(text, outputType);
                    return;
                }
                StringUtil.split((String)text, (String)"\n", (boolean)false).forEach(line -> this.processOneLine((String)line, outputType, type));
            }

            private void processOneLine(@NotNull String text, @NotNull Key outputType, @NotNull ProcessOutputType type) {
                MySMBuffer buffer;
                if (text == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((buffer = this.myType2Buffer.computeIfAbsent((Key<?>)type, (Function<Key<?>, MySMBuffer>)((Function<Key, MySMBuffer>)k -> new MySMBuffer())).append(text)).getBracketBalance() > 0 || !buffer.isComplete()) {
                    return;
                }
                this.myType2Buffer.remove(type);
                if (buffer.getBracketBalance() == 0) {
                    super.process(buffer.toString(), outputType);
                    return;
                }
                for (String s : buffer) {
                    super.process(s, outputType);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RubySmtRunnerConsoleProperties$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processOneLine";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RubySmtRunnerConsoleProperties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RubySmtRunnerConsoleProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestLocator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTestEventsConverter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class MySMBuffer
    extends ArrayList<String> {
        private int myBracketBalance = 0;
        private char myLastChar = '\u0000';
        private boolean myIsComplete = false;

        private MySMBuffer() {
        }

        private int getBracketBalance() {
            return this.myBracketBalance;
        }

        private boolean isComplete() {
            return this.myIsComplete;
        }

        @NotNull
        private MySMBuffer append(@NotNull String s) {
            int i;
            if (s == null) {
                MySMBuffer.$$$reportNull$$$0(0);
            }
            this.myIsComplete = s.endsWith("\n");
            if (this.myIsComplete) {
                s = RubyTextUtil.removeEOL((String)s);
            }
            if (s.isEmpty()) {
                MySMBuffer mySMBuffer = this;
                if (mySMBuffer == null) {
                    MySMBuffer.$$$reportNull$$$0(1);
                }
                return mySMBuffer;
            }
            this.add(s);
            int n = i = this.myLastChar == '|' ? 1 : 0;
            while (i < s.length()) {
                switch (s.charAt(i)) {
                    case '|': {
                        ++i;
                        break;
                    }
                    case '[': {
                        ++this.myBracketBalance;
                        break;
                    }
                    case ']': {
                        --this.myBracketBalance;
                    }
                }
                ++i;
            }
            this.myLastChar = s.charAt(s.length() - 1);
            MySMBuffer mySMBuffer = this;
            if (mySMBuffer == null) {
                MySMBuffer.$$$reportNull$$$0(2);
            }
            return mySMBuffer;
        }

        @Override
        @NotNull
        public String toString() {
            String string = Strings.join((Collection)this, (String)"") + "\n";
            if (string == null) {
                MySMBuffer.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RubySmtRunnerConsoleProperties$MySMBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RubySmtRunnerConsoleProperties$MySMBuffer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "append";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

