/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.runConfigurations;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.names.RNameNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.testing.RubyRunLineMarkerContributor;
import org.jetbrains.plugins.ruby.testing.shoulda.ShouldaUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunConfiguration;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitRunConfigurationProducer;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitRunConfigurationType;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public final class RTestUnitRunLineMarkerContributor
extends RubyRunLineMarkerContributor {
    private static final String DESCRIBE = "describe";
    private static final String IT = "it";

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        ConfigurationContext context;
        ConfigurationFactory factory;
        RTestUnitRunConfiguration templateConfiguration;
        boolean isGroup;
        if (element == null) {
            RTestUnitRunLineMarkerContributor.$$$reportNull$$$0(0);
        }
        if (!(element instanceof LeafPsiElement)) {
            return null;
        }
        RPsiElement rPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)element);
        if (rPsiElement == null) {
            return null;
        }
        Project project = element.getProject();
        if (RTestUnitRunLineMarkerContributor.isNotInTestFile(element)) {
            return null;
        }
        RCall call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)rPsiElement, RCall.class);
        boolean isTestClass = RTestUnitRunLineMarkerContributor.checkTestClass(element);
        boolean bl = isGroup = call != null && TestUnitUtil.isMinitestExampleGroupCall((RPossibleCall)call);
        if (!(RTestUnitRunLineMarkerContributor.checkTest(element) || isTestClass || RTestUnitRunLineMarkerContributor.isDescribeOrItCall(element) || RTestUnitRunLineMarkerContributor.isShouldaTestCall(element))) {
            return null;
        }
        TestUnitRunConfigurationProducer producer = (TestUnitRunConfigurationProducer)RunConfigurationProducer.getInstance(TestUnitRunConfigurationProducer.class);
        if (!producer.setupConfigurationFromContext(templateConfiguration = (RTestUnitRunConfiguration)(factory = TestUnitRunConfigurationType.getInstance().getConfigurationFactories()[0]).createTemplateConfiguration(project), context = ConfigurationContext.createEmptyContextForLocation((Location)PsiLocation.fromPsiElement((PsiElement)element)), (Ref<PsiElement>)Ref.create((Object)element))) {
            return null;
        }
        String[] possibleUrls = (String[])ArrayUtil.append((Object[])RTestUnitRunLineMarkerContributor.getLocationUrls(rPsiElement), (Object)RTestUnitRunLineMarkerContributor.getLineBasedLocationURL((PsiElement)rPsiElement));
        return RTestUnitRunLineMarkerContributor.getInfo(element, possibleUrls, isTestClass || isGroup, 2);
    }

    private static boolean isDescribeOrItCall(@NotNull PsiElement element) {
        PsiElement identifier;
        if (element == null) {
            RTestUnitRunLineMarkerContributor.$$$reportNull$$$0(1);
        }
        if (!((identifier = element.getParent()) instanceof RIdentifier)) {
            return false;
        }
        String name = ((RIdentifier)identifier).getName();
        if (!DESCRIBE.equals(name) && !IT.equals(name)) {
            return false;
        }
        return identifier.getParent() instanceof RPossibleCall;
    }

    private static boolean isShouldaTestCall(@NotNull PsiElement element) {
        if (element == null) {
            RTestUnitRunLineMarkerContributor.$$$reportNull$$$0(2);
        }
        if (!ShouldaUtil.isShouldaTestFile(element.getContainingFile().getVirtualFile(), ModuleUtilCore.findModuleForPsiElement((PsiElement)element))) {
            return false;
        }
        RPossibleCall call = (RPossibleCall)ObjectUtils.tryCast((Object)element, RPossibleCall.class);
        return call != null && (ShouldaUtil.isExampleCall(call) || ShouldaUtil.isExampleGroupCall(call));
    }

    private static boolean isNotInTestFile(@NotNull PsiElement element) {
        if (element == null) {
            RTestUnitRunLineMarkerContributor.$$$reportNull$$$0(3);
        }
        return !TestUnitUtil.isFileWithValidMinitestFileName(element.getContainingFile().getVirtualFile());
    }

    private static String @NotNull [] getLocationUrls(@NotNull RPsiElement rPsiElement) {
        RContainer currentContainer;
        if (rPsiElement == null) {
            RTestUnitRunLineMarkerContributor.$$$reportNull$$$0(4);
        }
        RContainer rContainer = currentContainer = rPsiElement instanceof RContainer ? (RContainer)rPsiElement : rPsiElement.getParentContainer();
        if (currentContainer == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                RTestUnitRunLineMarkerContributor.$$$reportNull$$$0(5);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        RClass aClass = RubyPsiUtil.getContainingUpperRClass(currentContainer);
        String minitestName = TestUnitUtil.determineCurrentTestNameByRailsTestClosure((PsiElement)rPsiElement);
        String testUnitName = TestUnitUtil.unmangleTestUnitName(TestUnitUtil.determineCurrentTestNameByTestUnitTestClosure((PsiElement)rPsiElement));
        if (aClass == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                RTestUnitRunLineMarkerContributor.$$$reportNull$$$0(6);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String minitestURL = "ruby_minitest_qn://" + RubyClassResolveUtil.getQualifiedName(aClass);
        String testUnitURL = "ruby_qn://" + RubyClassResolveUtil.getQualifiedName(aClass);
        if (minitestName == null && testUnitName == null) {
            String[] stringArray = (String[])ContainerUtil.ar((Object[])new String[]{minitestURL, testUnitURL});
            if (stringArray == null) {
                RTestUnitRunLineMarkerContributor.$$$reportNull$$$0(7);
            }
            return stringArray;
        }
        String minitestFullName = minitestURL + (String)(minitestName == null ? "" : "." + minitestName);
        String testUnitFullName = testUnitURL + (String)(testUnitName == null ? "" : "." + testUnitName);
        String[] stringArray = (String[])ContainerUtil.ar((Object[])new String[]{minitestFullName, testUnitFullName});
        if (stringArray == null) {
            RTestUnitRunLineMarkerContributor.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    private static boolean checkTest(@NotNull PsiElement element) {
        PsiElement name;
        if (element == null) {
            RTestUnitRunLineMarkerContributor.$$$reportNull$$$0(9);
        }
        if ((name = element.getParent()) instanceof RFName) {
            PsiElement parent = name.getParent();
            if (!(parent instanceof RName)) {
                return false;
            }
            PsiElement method = parent.getParent();
            return method instanceof RMethod && TestUnitUtil.isUnitTestMethod((RMethod)method);
        }
        if (name instanceof RIdentifier) {
            PsiElement psiElement;
            PsiElement parent = name.getParent();
            if (parent == null || !((psiElement = parent.getParent()) instanceof RBlockCall)) {
                return false;
            }
            RBlockCall call = (RBlockCall)psiElement;
            return TestUnitUtil.isTestClosureCall((RPossibleCall)call) || ShouldaUtil.isExampleCall((RPossibleCall)call) || ShouldaUtil.isExampleGroupCall((RPossibleCall)call);
        }
        return false;
    }

    private static boolean checkTestClass(@NotNull PsiElement element) {
        PsiElement name;
        if (element == null) {
            RTestUnitRunLineMarkerContributor.$$$reportNull$$$0(10);
        }
        if (!((name = element.getParent()) instanceof RConstant)) {
            return false;
        }
        RName rName = RNameNavigator.getRName((PsiElement)name);
        if (rName == null) {
            return false;
        }
        return rName.getParent() instanceof RClass && !(rName instanceof RSuperClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPsiElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RTestUnitRunLineMarkerContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RTestUnitRunLineMarkerContributor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDescribeOrItCall";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isShouldaTestCall";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNotInTestFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocationUrls";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkTest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkTestClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

