/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.runConfigurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationUtil;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RAbstractTestsCommandLineState;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunConfiguration;

public class RTestUnitRunCommandLineState
extends RAbstractTestsCommandLineState {
    @NonNls
    public static final String ENV_KEY_IDEA_TUNIT_DRB_RUNNER_PATH = "INTELLIJ_IDEA_TUNIT_DRB_RUNNER_PATH";
    @NonNls
    public static final String TESTS_CHOOSE_METHOD_PARAMETER = "--name";
    @NonNls
    private static final String TESTOPTS_METHOD_FILTER = "TESTOPTS=\"--name=%s\"";
    @NonNls
    private static final String TUNIT_IN_FOLDER_RUNNER_SCRIPT = "rb/testing/runner/tunit_or_minitest_in_folder_runner.rb";
    @NonNls
    private static final String MINITEST_RUNNER = "rb/testing/runner/minitest_runner.rb";
    private static final List<SupportedTestFramework> ATTACHED_FRAMEWORKS = Arrays.asList(SupportedTestFramework.TEST_UNIT, SupportedTestFramework.SHOULDA);
    @NonNls
    private static final String TEST_UNIT_RUNNER_PARAMS_GROUP_ID = "ruby.tests.testunit.runner";
    @NonNls
    static final String[] CUSTOM_RUNNER_OPTIONS = new String[]{"-r", "--runner", "--console", "--fox", "--gtk"};
    @NonNls
    private static final String RAILS_BIN_STUB = "rails";
    @NonNls
    private static final String BIN_RAILS_BIN_STUB = "bin/rails";
    @NonNls
    private static final String TEST_COMMAND = "test";

    public RTestUnitRunCommandLineState(RTestUnitRunConfiguration config, ExecutionEnvironment environment) {
        super(config, environment);
    }

    @Override
    public RTestUnitRunConfiguration getConfig() {
        return (RTestUnitRunConfiguration)super.getConfig();
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        Module module;
        boolean isRakeTestTask;
        String preLoaderExecutablePath;
        ParamsGroup runnerGroup;
        List<String> testScriptsPaths;
        RubySdkAdditionalData additionalData;
        AbstractRubyTestsRunConfigurationParams.TestType testType;
        Sdk sdk;
        Map envMap;
        RubyRunner runner;
        RubyCommandLine commandLine;
        RubyCommandLineData data;
        RTestUnitRunConfiguration config;
        block31: {
            block30: {
                config = this.getConfig();
                String runnerId = this.getRunnerId();
                data = RTestUnitRunCommandLineState.createDefaultCommandLine(config, runnerId);
                commandLine = data.getCommandLine();
                runner = (RubyRunner)data.getUserData(RubyCommandLineData.RUNNER_KEY);
                LOG.assertTrue(runner != null);
                envMap = commandLine.getEnvironment();
                sdk = config.getSdk();
                LOG.assertTrue(sdk != null);
                testType = config.getTestType();
                additionalData = RubySdkUtil.getRubySdkAdditionalData(sdk);
                testScriptsPaths = config.getTestScriptsPaths();
                runnerGroup = null;
                preLoaderExecutablePath = null;
                isRakeTestTask = false;
                module = config.getModule();
                if (!this.preLoaderAllowed()) break block30;
                switch (config.getPreloadServer()) {
                    case Spring: {
                        preLoaderExecutablePath = SpringUtil.getSpringExecutable(module, sdk);
                        if (preLoaderExecutablePath != null && testType != AbstractRubyTestsRunConfigurationParams.TestType.ALL_IN_FOLDER) {
                            boolean shouldUseRailsExecutable = RailsUtil.isRails5OrHigher(module);
                            if (shouldUseRailsExecutable) {
                                runnerGroup = commandLine.getParametersList().addParamsGroup(new ParamsGroup(TEST_UNIT_RUNNER_PARAMS_GROUP_ID));
                                String railsScriptPath = null;
                                if (module != null) {
                                    railsScriptPath = RailsUtil.getRailsScriptExecutablePath(module, RAILS_BIN_STUB);
                                }
                                railsScriptPath = railsScriptPath == null ? BIN_RAILS_BIN_STUB : RubySdkUtil.convertToRemote(sdk, module, railsScriptPath);
                                runnerGroup.addParameters(new String[]{railsScriptPath, TEST_COMMAND});
                                break;
                            }
                            isRakeTestTask = RTestUnitRunCommandLineState.canUseRakeTest(config);
                            runnerGroup = commandLine.getParametersList().addParamsGroup(new ParamsGroup(TEST_UNIT_RUNNER_PARAMS_GROUP_ID));
                            if (RTestUnitRunCommandLineState.isExplicitSpringEnabled(runnerId)) {
                                runnerGroup.addParameters(new String[]{RubySdkUtil.convertToRemote(sdk, module, preLoaderExecutablePath)});
                                if (isRakeTestTask) {
                                    runnerGroup.addParameters(new String[]{"rake", TEST_COMMAND});
                                    break;
                                }
                                runnerGroup.addParameter("testunit");
                                break;
                            }
                            if (isRakeTestTask) {
                                String rakePath = StringUtil.notNullize((String)RubyGemExecutionContext.getScriptPath(sdk, module, "rake"), (String)"rake");
                                runnerGroup.addParameters(new String[]{rakePath, TEST_COMMAND});
                                break;
                            }
                            String testUnitPath = StringUtil.notNullize((String)RubyGemExecutionContext.getScriptPath(sdk, module, "testunit", "test-unit"), (String)"testunit");
                            runnerGroup.addParameter(testUnitPath);
                            break;
                        }
                        break block31;
                    }
                    case Zeus: {
                        preLoaderExecutablePath = ZeusUtil.getZeusExecutable(module, sdk);
                        if (preLoaderExecutablePath != null) {
                            if (testType != AbstractRubyTestsRunConfigurationParams.TestType.ALL_IN_FOLDER) {
                                runnerGroup = this.addExecutionScriptGroup(TEST_UNIT_RUNNER_PARAMS_GROUP_ID, data, commandLine, RubySdkUtil.convertToRemote(sdk, module, preLoaderExecutablePath));
                                runnerGroup.addParameter(TEST_COMMAND);
                            }
                            envMap.remove("RAILS_ENV");
                            break;
                        }
                        break block31;
                    }
                    case DRb: {
                        preLoaderExecutablePath = this.determineTUnitSporkDrbRunnerScriptPath();
                        if (preLoaderExecutablePath == null) {
                            throw new ExecutionException(RBundle.message((String)"execution.error.testunit.spork.script.not.found"));
                        }
                        if (testType != AbstractRubyTestsRunConfigurationParams.TestType.ALL_IN_FOLDER) {
                            runnerGroup = this.addExecutionScriptGroup(TEST_UNIT_RUNNER_PARAMS_GROUP_ID, data, commandLine, RubySdkUtil.convertToRemote(sdk, module, preLoaderExecutablePath));
                            break;
                        }
                        break block31;
                    }
                }
                break block31;
            }
            PreLoadUtil.showDebuggingInfo(config.getProject(), config.getPreloadServer());
        }
        switch (testType) {
            case ALL_IN_FOLDER: {
                String railsVersion;
                envMap.put("INTELLIJ_IDEA_RUN_CONF_FOLDER_PATH", RubySdkUtil.convertToRemote(sdk, module, config.getTestsFolderPath()));
                envMap.put("INTELLIJ_IDEA_RUN_CONF_SEARCH_MASK", config.getTestFileMask());
                if (module != null && (railsVersion = RailsUtil.getRailsVersion(module)) != null) {
                    envMap.put("INTELLIJ_IDEA_RUN_CONF_RAILS_VERSION", railsVersion);
                }
                RTestUnitRunCommandLineState.addWorkDirParameter(envMap, RubySdkUtil.convertToRemote(sdk, module, config.getWorkingDirectory()));
                if (preLoaderExecutablePath != null) {
                    envMap.put(ENV_KEY_IDEA_TUNIT_DRB_RUNNER_PATH, RubySdkUtil.convertToRemote(sdk, module, preLoaderExecutablePath));
                    RubyCommandLineData runCmdLineData = RTestUnitRunCommandLineState.createDefaultRunCommandLine(config, commandLine.getEnvironment(), runner, sdk);
                    RubyCommandLine runCmdLine = runCmdLineData.getCommandLine();
                    RunConfigurationUtil.writeLauncherArgsToEnv(additionalData.getSdkSystemAccessor(), envMap, runCmdLine);
                }
                String allInFolderScriptPath = RubyUtil.getScriptFullPath(TUNIT_IN_FOLDER_RUNNER_SCRIPT);
                assert (allInFolderScriptPath != null);
                runnerGroup = this.addExecutionScriptGroup(TEST_UNIT_RUNNER_PARAMS_GROUP_ID, data, commandLine, allInFolderScriptPath);
                break;
            }
            case TEST_METHOD: {
                String testMethodRunnerPath = RTestUnitRunCommandLineState.getMinitestRunnerFullPath();
                assert (testMethodRunnerPath != null);
                testMethodRunnerPath = RubySdkUtil.convertToRemote(sdk, module, testMethodRunnerPath);
                if (runnerGroup != null) {
                    runnerGroup.addParameter(RTestUnitRunCommandLineState.getTestScriptPathParameter(isRakeTestTask, testMethodRunnerPath));
                } else {
                    runnerGroup = this.addExecutionScriptGroup(TEST_UNIT_RUNNER_PARAMS_GROUP_ID, data, commandLine, testMethodRunnerPath);
                }
                testScriptsPaths = RubySdkUtil.convertToRemote(sdk, module, testScriptsPaths);
                LOG.info(String.format("Run test method from file %s", StringUtil.join(testScriptsPaths, (String)",")));
                envMap.put("INTELLIJ_IDEA_RUN_CONF_TEST_FILE_PATH", RunConfigurationUIUtil.joinFilenames(testScriptsPaths));
                envMap.put("INTELLIJ_IDEA_RUN_CONF_SEARCH_MASK", config.getTestFileMask());
                String methodName = config.getTestMethodFilter();
                String methodRegex = "/" + methodName + "/";
                if (isRakeTestTask) {
                    runnerGroup.addParameter(String.format(TESTOPTS_METHOD_FILTER, methodRegex));
                    break;
                }
                runnerGroup.addParameters(new String[]{TESTS_CHOOSE_METHOD_PARAMETER, methodRegex});
                break;
            }
            case TEST_SCRIPT: 
            case CUSTOM_SET_OF_FILES: {
                String testScriptRunnerPath = RTestUnitRunCommandLineState.getMinitestRunnerFullPath();
                assert (testScriptRunnerPath != null);
                testScriptRunnerPath = RubySdkUtil.convertToRemote(sdk, module, testScriptRunnerPath);
                if (runnerGroup != null) {
                    runnerGroup.addParameter(RTestUnitRunCommandLineState.getTestScriptPathParameter(isRakeTestTask, testScriptRunnerPath));
                } else {
                    runnerGroup = this.addExecutionScriptGroup(TEST_UNIT_RUNNER_PARAMS_GROUP_ID, data, commandLine, testScriptRunnerPath);
                }
                testScriptsPaths = RubySdkUtil.convertToRemote(sdk, module, testScriptsPaths);
                LOG.info(String.format("Run test from files: %s", StringUtil.join(testScriptsPaths, (String)",")));
                envMap.put("INTELLIJ_IDEA_RUN_CONF_TEST_FILE_PATH", RunConfigurationUIUtil.joinFilenames(testScriptsPaths));
            }
        }
        RTestUnitRunCommandLineState.addParams(runnerGroup, config.getRunnerOptions());
        return data;
    }

    @Nullable
    private static String getMinitestRunnerFullPath() {
        return RubyUtil.getScriptFullPath(MINITEST_RUNNER);
    }

    private static boolean canUseRakeTest(@NotNull RTestUnitRunConfiguration config) {
        if (config == null) {
            RTestUnitRunCommandLineState.$$$reportNull$$$0(0);
        }
        return RailsUtil.isRails40OrHigher(config.getModule());
    }

    @NotNull
    private static String getTestScriptPathParameter(boolean isRakeTestTask, @NotNull String convertedPath) {
        if (convertedPath == null) {
            RTestUnitRunCommandLineState.$$$reportNull$$$0(1);
        }
        Object object = isRakeTestTask ? "TEST=" + convertedPath : convertedPath;
        if (object == null) {
            RTestUnitRunCommandLineState.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Nullable
    private String determineTUnitSporkDrbRunnerScriptPath() {
        RTestUnitRunConfiguration config = this.getConfig();
        Sdk alternativeSdk = config.getAlternativeSdk();
        return PreLoadUtil.determinePreferredTUnitSporkDrbRunnerExecutablePath(config.getModule(), (Sdk)(config.shouldUseAlternativeSdk() ? alternativeSdk : null));
    }

    public static void configureTestFrameworkSupport(@NotNull Map<String, String> envMap, @NotNull Sdk sdk, @Nullable Module module) throws ExecutionException {
        if (envMap == null) {
            RTestUnitRunCommandLineState.$$$reportNull$$$0(3);
        }
        if (sdk == null) {
            RTestUnitRunCommandLineState.$$$reportNull$$$0(4);
        }
        RakeRunConfigurationUtil.configureTestFrameworksSupport(envMap, sdk, module, ATTACHED_FRAMEWORKS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertedPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RTestUnitRunCommandLineState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RTestUnitRunCommandLineState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestScriptPathParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canUseRakeTest";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTestScriptPathParameter";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureTestFrameworkSupport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

