/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.runConfigurations;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractTestRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyProgramRunner;
import org.jetbrains.plugins.ruby.testing.RubyRerunFailedTestsProvider;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public abstract class RAbstractTestsCommandLineState
extends RubyAbstractCommandLineState {
    @NonNls
    public static final String ENV_KEY_FOLDER_PATH = "INTELLIJ_IDEA_RUN_CONF_FOLDER_PATH";
    @NonNls
    public static final String ENV_KEY_SEARCH_MASK = "INTELLIJ_IDEA_RUN_CONF_SEARCH_MASK";
    @NonNls
    public static final String ENV_KEY_TEST_FILE_PATH = "INTELLIJ_IDEA_RUN_CONF_TEST_FILE_PATH";
    @NonNls
    public static final String ENV_KEY_WORK_DIR = "INTELLIJ_IDEA_RUN_CONF_WORKING_DIR";
    @NonNls
    public static final String ENV_KEY_IDEA_LAUNCHER_CMDLINE = "INTELLIJ_IDEA_RUN_CONF_LAUNCHER_CMDLINE";
    @NonNls
    public static final String ENV_KEY_RAILS_VERSION = "INTELLIJ_IDEA_RUN_CONF_RAILS_VERSION";
    @NonNls
    private static final String TEAMCITY_VERSION = "TEAMCITY_VERSION";

    protected RAbstractTestsCommandLineState(AbstractTestRunConfiguration config, ExecutionEnvironment environment) {
        super(config, environment, false);
    }

    @Override
    @NotNull
    protected ProcessHandler createOSProcessHandler(@NotNull RubyRunner runner, @NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (runner == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            commandLine.getEnvironment().put(TEAMCITY_VERSION, "");
        }
        ProcessHandler processHandler = super.createOSProcessHandler(runner, commandLine);
        if (processHandler == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(2);
        }
        return processHandler;
    }

    public AbstractTestRunConfiguration<?> getConfig() {
        return (AbstractTestRunConfiguration)super.getConfig();
    }

    protected static boolean isExplicitSpringEnabled(@NotNull String runnerId) {
        RubyProgramRunner rubyProgramRunner;
        if (runnerId == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(3);
        }
        if (!SpringUtil.isExplicitSpringEnabled()) {
            return false;
        }
        ProgramRunner<?> programRunner = RAbstractTestsCommandLineState.getRunner(runnerId);
        return programRunner instanceof RubyProgramRunner && (rubyProgramRunner = (RubyProgramRunner)programRunner).isExplicitSpringAllowed();
    }

    @Override
    @NotNull
    public ConsoleView createAndAttachConsole(@NotNull Project project, @NotNull ProcessHandler processHandler, @NotNull Executor executor) throws ExecutionException {
        ConsoleView testRunnerConsole;
        AbstractRubyRunConfiguration config;
        if (project == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(4);
        }
        if (processHandler == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(5);
        }
        if (executor == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(6);
        }
        if (!((AbstractTestRunConfiguration)(config = this.getConfig())).shouldAttachTestRunnerConsole()) {
            testRunnerConsole = super.createAndAttachConsole(project, processHandler, executor);
        } else {
            SupportedTestFramework framework = ((AbstractTestRunConfiguration)config).getTestFramework();
            String testFrameworkName = framework.getFrameworkName();
            SMTRunnerConsoleProperties consoleProperties = ((AbstractTestRunConfiguration)config).createTestConsoleProperties(executor);
            testRunnerConsole = SMTestRunnerConnectionUtil.createAndAttachConsole((String)testFrameworkName, (ProcessHandler)processHandler, (TestConsoleProperties)((TestConsoleProperties)Objects.requireNonNull(consoleProperties)));
        }
        this.addFiltersToConsole(testRunnerConsole);
        ConsoleView consoleView = testRunnerConsole;
        if (consoleView == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(7);
        }
        return consoleView;
    }

    @NotNull
    public DefaultExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner, @NotNull ProcessHandler processHandler) throws ExecutionException {
        if (executor == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(8);
        }
        if (runner == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(9);
        }
        if (processHandler == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(10);
        }
        DefaultExecutionResult executionResult = super.execute(executor, runner, processHandler);
        ExecutionConsole console = executionResult.getExecutionConsole();
        if (runner instanceof RubyProgramRunner) {
            executionResult.setRestartActions(new AnAction[]{new ToggleAutoTestAction()});
        }
        AbstractRerunFailedTestsAction rerunFailedTestsAction = RubyRerunFailedTestsProvider.createAction(console, ((AbstractTestRunConfiguration)this.getConfig()).getTestFramework());
        if (console instanceof SMTRunnerConsoleView && rerunFailedTestsAction != null) {
            rerunFailedTestsAction.init(((SMTRunnerConsoleView)console).getProperties());
            rerunFailedTestsAction.setModelProvider(() -> ((SMTRunnerConsoleView)console).getResultsViewer());
            executionResult.setRestartActions(new AnAction[]{rerunFailedTestsAction, new ToggleAutoTestAction()});
        }
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(11);
        }
        return defaultExecutionResult;
    }

    @Override
    public List<Filter> createConsoleMessageFilters() {
        AbstractRubyRunConfiguration runConfiguration = this.getConfig();
        List<Filter> filters = super.createConsoleMessageFilters();
        filters.addAll(RAbstractTestsCommandLineState.commonTestsFilters(runConfiguration.getProject(), runConfiguration.getModule(), runConfiguration.getSdk(), runConfiguration, null));
        return filters.stream().distinct().collect(Collectors.toList());
    }

    private void addFiltersToConsole(ConsoleView testRunnerConsole) {
        List<Filter> filters = this.createConsoleMessageFilters();
        for (Filter filter : filters) {
            testRunnerConsole.addMessageFilter(filter);
        }
    }

    public static List<Filter> commonTestsFilters(@NotNull Project project, @Nullable Module module, @Nullable Sdk sdk, @NotNull AbstractRubyRunConfigurationParams configParams, @Nullable String customWorkDirForLinksFilter) {
        if (project == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(12);
        }
        if (configParams == null) {
            RAbstractTestsCommandLineState.$$$reportNull$$$0(13);
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        RAbstractTestsCommandLineState.addConsoleFilters(filters, project, sdk, configParams.getWorkingDirectory());
        filters.add(new RStackTraceFilter(module, customWorkDirForLinksFilter));
        return filters;
    }

    protected static void addWorkDirParameter(Map<String, String> envMap, String workingDirectory) {
        if (!StringUtil.isEmpty((String)workingDirectory)) {
            envMap.put(ENV_KEY_WORK_DIR, workingDirectory);
        }
    }

    protected static String asGemVersionCmdlineArgument(String runnerVersionRequirement) {
        return "_" + runnerVersionRequirement + "_";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RAbstractTestsCommandLineState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RAbstractTestsCommandLineState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createOSProcessHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOSProcessHandler";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExplicitSpringEnabled";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAndAttachConsole";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "commonTestsFilters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 11 -> new IllegalStateException(string);
        };
    }
}

