/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.codeinsight;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.testing.testunit.RTestUnitUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public final class MinitestSymbolProvider
implements RubySymbolProvider {
    private static final String DEFAULT_EXAMPLE_GROUP_CLASS_FQN_PRE50 = "MiniTest::Spec";
    private static final String DEFAULT_EXAMPLE_GROUP_CLASS_FQN = "Minitest::Spec";
    private static final String DEFAULT_RAILS_EXAMPLE_GROUP_CLASS_FQN = "MiniTest::Spec::Rails";

    @Override
    public ContextImpl getAccessContext(@NotNull PsiElement element) {
        RClass rClass;
        Module module;
        RPsiElement rPsiElement;
        if (element == null) {
            MinitestSymbolProvider.$$$reportNull$$$0(0);
        }
        if ((rPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)element)) == null || !MinitestSymbolProvider.shouldUseMinitestSupportFor(rPsiElement)) {
            return null;
        }
        if (TestUnitUtil.getSimpleCoveringExampleOrBeforeAfterScope(element) != null) {
            return ContextImpl.INSTANCE_PRIVATE;
        }
        RBlockCall exampleGroupScope = TestUnitUtil.getSimpleCoveringExampleGroupScope(element);
        if (exampleGroupScope != null) {
            RMethod method = RubyPsiUtil.getContainingRMethod(element);
            RElementWithFQN contextContainer = SymbolUtil.getContextContainer(element);
            if ((method == null || PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)exampleGroupScope, (boolean)false)) && PsiTreeUtil.isAncestor((PsiElement)contextContainer, (PsiElement)exampleGroupScope, (boolean)false)) {
                return ContextImpl.CLASS_PRIVATE;
            }
        }
        if (RailsUtil.isRails40OrHigher(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) && TestUnitUtil.isInActiveSupportTestClosureBlock(element) && (rClass = RubyPsiUtil.getContainingRClass(element)) != null && RTestUnitUtil.isMinitestCaseDescendant(rClass)) {
            return ContextImpl.INSTANCE_PRIVATE;
        }
        return null;
    }

    @Override
    public Symbol getSymbolScope(@NotNull PsiElement element) {
        RPsiElement rPsiElement;
        if (element == null) {
            MinitestSymbolProvider.$$$reportNull$$$0(1);
        }
        if ((rPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)element)) == null || !MinitestSymbolProvider.shouldUseMinitestSupportFor(rPsiElement)) {
            return null;
        }
        VirtualFile file = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rPsiElement);
        assert (file != null);
        RElementWithFQN contextContainer = SymbolUtil.getContextContainer(element);
        RBlockCall exampleBlock = TestUnitUtil.getSimpleCoveringExampleOrBeforeAfterScope(element);
        if (exampleBlock != null && PsiTreeUtil.isAncestor((PsiElement)contextContainer, (PsiElement)exampleBlock, (boolean)false)) {
            return MinitestSymbolProvider.findCorrespondingExampleGroup(file, rPsiElement);
        }
        RBlockCall exampleGroupBlock = TestUnitUtil.getSimpleCoveringExampleGroupScope(element);
        if (exampleGroupBlock != null && PsiTreeUtil.isAncestor((PsiElement)contextContainer, (PsiElement)exampleGroupBlock, (boolean)false)) {
            return MinitestSymbolProvider.findCorrespondingExampleGroup(file, rPsiElement);
        }
        return null;
    }

    @Nullable
    private static Symbol findCorrespondingExampleGroup(@NotNull VirtualFile file, @NotNull RPsiElement rPsiElement) {
        VirtualFile testsRoot;
        if (file == null) {
            MinitestSymbolProvider.$$$reportNull$$$0(2);
        }
        if (rPsiElement == null) {
            MinitestSymbolProvider.$$$reportNull$$$0(3);
        }
        Project project = rPsiElement.getProject();
        RClass containingRClass = RubyPsiUtil.getContainingRClass((PsiElement)rPsiElement);
        if (containingRClass != null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rPsiElement);
        RailsApp app = module != null ? RailsApp.fromModule(module) : null;
        VirtualFile virtualFile = testsRoot = app != null ? app.getUTestsRoot() : null;
        if (testsRoot == null || !VfsUtilCore.isAncestor((VirtualFile)testsRoot, (VirtualFile)file, (boolean)false)) {
            return MinitestSymbolProvider.createDefaultExampleGroupContext(project, (PsiElement)rPsiElement);
        }
        Symbol context = MinitestSymbolProvider.createRailsDefaultExampleGroupContext(project, (PsiElement)rPsiElement);
        return context != null ? context : MinitestSymbolProvider.createDefaultExampleGroupContext(project, (PsiElement)rPsiElement);
    }

    public static boolean shouldUseMinitestSupportFor(@NotNull RPsiElement rPsiElement) {
        VirtualFile file;
        if (rPsiElement == null) {
            MinitestSymbolProvider.$$$reportNull$$$0(4);
        }
        return (file = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rPsiElement)) != null && TestUnitUtil.isFileWithValidMinitestFileName(file);
    }

    @Nullable
    public static Symbol createRailsDefaultExampleGroupContext(@NotNull Project project, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            MinitestSymbolProvider.$$$reportNull$$$0(5);
        }
        return SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.of((String)DEFAULT_RAILS_EXAMPLE_GROUP_CLASS_FQN), invocationPoint);
    }

    @Nullable
    public static Symbol createDefaultExampleGroupContext(@NotNull Project project, @Nullable PsiElement invocationPoint) {
        Symbol baseClass;
        if (project == null) {
            MinitestSymbolProvider.$$$reportNull$$$0(6);
        }
        if ((baseClass = SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.of((String)DEFAULT_EXAMPLE_GROUP_CLASS_FQN), invocationPoint)) != null) {
            return baseClass;
        }
        return SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.of((String)DEFAULT_EXAMPLE_GROUP_CLASS_FQN_PRE50), invocationPoint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPsiElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/codeinsight/MinitestSymbolProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAccessContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSymbolScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findCorrespondingExampleGroup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldUseMinitestSupportFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createRailsDefaultExampleGroupContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createDefaultExampleGroupContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

