/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.codeinsight;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyEvalCallType;

final class InflectAnAssertionCallType
extends RubyEvalCallType {
    @NonNls
    static final String EXPECTATIONS_MODULE_SHORT_NAME = "Expectations";
    @NonNls
    private static final String EXPECTATIONS_MODULE_FQN = "MiniTest::Expectations";
    @NonNls
    private static final String EXPECTATIONS_5_0_MODULE_FQN = "Minitest::Expectations";
    private static final String CALL_SHORT_NAME = "infect_an_assertion";
    private static final String OBJECT_INFLECT_AN_ASSERTION = "Object.infect_an_assertion";

    InflectAnAssertionCallType() {
        super(CALL_SHORT_NAME);
    }

    @Override
    public boolean process(@NotNull Processor<? super Symbol> processor, @NotNull Symbol symbol, @NotNull RCall call, PsiElement invocationPoint) {
        boolean inflectAssertionCall;
        if (processor == null) {
            InflectAnAssertionCallType.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            InflectAnAssertionCallType.$$$reportNull$$$0(1);
        }
        if (call == null) {
            InflectAnAssertionCallType.$$$reportNull$$$0(2);
        }
        return !(inflectAssertionCall = InflectAnAssertionCallType.isInflectAssertionCall(call.getCommand())) || this.processDynamicMatcherRegistrationMethod(processor, call);
    }

    private boolean processDynamicMatcherRegistrationMethod(@NotNull Processor<? super Symbol> processor, @NotNull RCall call) {
        List callArguments;
        String matcher_name;
        if (processor == null) {
            InflectAnAssertionCallType.$$$reportNull$$$0(3);
        }
        if (call == null) {
            InflectAnAssertionCallType.$$$reportNull$$$0(4);
        }
        if ((matcher_name = InflectAnAssertionCallType.getMatcherName(callArguments = (List)call.getData(new RubyCallType[]{this}))) == null) {
            return true;
        }
        Project project = call.getProject();
        Symbol expectationsModule = InflectAnAssertionCallType.getExpectationsModule(project);
        if (expectationsModule != null) {
            return processor.process(new PsiElementSymbol<RCall>(call, matcher_name, Type.INSTANCE_METHOD, expectationsModule));
        }
        return true;
    }

    private static boolean isInflectAssertionCall(@NotNull String command) {
        if (command == null) {
            InflectAnAssertionCallType.$$$reportNull$$$0(5);
        }
        if (CALL_SHORT_NAME.equals(command)) {
            return true;
        }
        if (OBJECT_INFLECT_AN_ASSERTION.equals(command)) {
            return true;
        }
        int methodName = command.indexOf(CALL_SHORT_NAME);
        if (methodName != -1) {
            String refName = command.substring(0, methodName - 1);
            return TextUtil.isCIDOrColonQualifiedReference((String)refName);
        }
        return false;
    }

    @Nullable
    static String getMatcherName(@NotNull List<String> callArguments) {
        if (callArguments == null) {
            InflectAnAssertionCallType.$$$reportNull$$$0(6);
        }
        if (callArguments.size() < 2) {
            return null;
        }
        String matcher_name = callArguments.get(1);
        if (TextUtil.isMethodName((String)matcher_name)) {
            return matcher_name;
        }
        return null;
    }

    @Nullable
    private static Symbol getExpectationsModule(@NotNull Project project) {
        Symbol expectationsModule;
        if (project == null) {
            InflectAnAssertionCallType.$$$reportNull$$$0(7);
        }
        if ((expectationsModule = SymbolUtil.findConstantByFQN(project, Type.MODULE, EXPECTATIONS_5_0_MODULE_FQN, null)) != null) {
            return expectationsModule;
        }
        return SymbolUtil.findConstantByFQN(project, Type.MODULE, EXPECTATIONS_MODULE_FQN, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArguments";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/codeinsight/InflectAnAssertionCallType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processDynamicMatcherRegistrationMethod";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isInflectAssertionCall";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getMatcherName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpectationsModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

