/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.shoulda.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewElement;
import org.jetbrains.plugins.ruby.testing.shoulda.ShouldaUtil;
import org.jetbrains.plugins.ruby.testing.testunit.structure.RTUnitStructureViewElement;

public class ShouldaStructureViewElement
extends RTUnitStructureViewElement {
    private static final Logger LOG = Logger.getInstance(ShouldaStructureViewElement.class);

    public ShouldaStructureViewElement(@Nullable RPsiElement element, boolean inherited) {
        super(element, inherited);
    }

    @Override
    protected boolean canElementHaveChildren() {
        return super.canElementHaveChildren() || this.getElement() instanceof RBlockCall;
    }

    @Override
    protected List<? extends RPsiElement> getElementPsiChildren() {
        RPsiElement element = (RPsiElement)this.getElement();
        if (element instanceof RContainer) {
            return ((RContainer)element).getStatements();
        }
        if (element instanceof RBlockCall) {
            RCodeBlock codeBlock = ((RBlockCall)element).getBlock();
            RCompoundStatement codeBlockCompoundStatement = codeBlock.getCompoundStatement();
            return codeBlockCompoundStatement.getStatements();
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean processPsiChild(@NotNull RPsiElement child, @NotNull Collection<RPsiElement> elements) {
        if (child == null) {
            ShouldaStructureViewElement.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ShouldaStructureViewElement.$$$reportNull$$$0(1);
        }
        if (super.processPsiChild(child, elements)) {
            return true;
        }
        if (child instanceof RCall || child instanceof RBlockCall) {
            RPossibleCall possibleCall = (RPossibleCall)child;
            if (ShouldaUtil.isExampleCall(possibleCall) || ShouldaUtil.isExampleGroupCall(possibleCall) || ShouldaUtil.isContextBeforeAfterCall(possibleCall)) {
                elements.add(child);
                return true;
            }
            if (ShouldaStructureViewElement.canBeShouldaMacros(child)) {
                elements.add(child);
            }
        }
        return false;
    }

    private static boolean canBeShouldaMacros(RPsiElement psiElement) {
        String cmd;
        return psiElement instanceof RCall && (cmd = ((RCall)psiElement).getCommand()).startsWith("should_");
    }

    @Override
    @NotNull
    protected RubyStructureViewElement createTreeElement(@NotNull RPsiElement psiElement, boolean inherited) {
        if (psiElement == null) {
            ShouldaStructureViewElement.$$$reportNull$$$0(2);
        }
        return new ShouldaStructureViewElement(psiElement, inherited);
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        RPsiElement element = (RPsiElement)this.getElement();
        if (element instanceof RPossibleCall) {
            RPossibleCall possibleCall = (RPossibleCall)element;
            if (ShouldaUtil.isExampleCall(possibleCall) || ShouldaStructureViewElement.canBeShouldaMacros((RPsiElement)possibleCall)) {
                ItemPresentation itemPresentation = ShouldaStructureViewElement.getUpdatedPresentation(element, AllIcons.Nodes.Test);
                if (itemPresentation == null) {
                    ShouldaStructureViewElement.$$$reportNull$$$0(3);
                }
                return itemPresentation;
            }
            if (ShouldaUtil.isExampleGroupCall(possibleCall)) {
                ItemPresentation itemPresentation = ShouldaStructureViewElement.getUpdatedPresentation(element, AllIcons.Nodes.TestGroup);
                if (itemPresentation == null) {
                    ShouldaStructureViewElement.$$$reportNull$$$0(4);
                }
                return itemPresentation;
            }
            if (ShouldaUtil.isContextBeforeAfterCall(possibleCall)) {
                ItemPresentation itemPresentation = ShouldaStructureViewElement.getUpdatedPresentation(element, AllIcons.Nodes.Method);
                if (itemPresentation == null) {
                    ShouldaStructureViewElement.$$$reportNull$$$0(5);
                }
                return itemPresentation;
            }
        }
        ItemPresentation itemPresentation = super.getPresentation();
        if (itemPresentation == null) {
            ShouldaStructureViewElement.$$$reportNull$$$0(6);
        }
        return itemPresentation;
    }

    private static ItemPresentation getUpdatedPresentation(@NotNull RPsiElement value, @NotNull Icon newIcon) {
        ItemPresentation presentation;
        if (value == null) {
            ShouldaStructureViewElement.$$$reportNull$$$0(7);
        }
        if (newIcon == null) {
            ShouldaStructureViewElement.$$$reportNull$$$0(8);
        }
        if ((presentation = value.getPresentation()) == null) {
            LOG.error("Presentation isn't defined for " + value.getClass().getName() + ".\n" + value.getText());
        }
        return new PresentationData(presentation.getPresentableText(), null, newIcon, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/shoulda/structure/ShouldaStructureViewElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/shoulda/structure/ShouldaStructureViewElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processPsiChild";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTreeElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

