/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.shoulda.codeInsight;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbolWithMixins;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.testing.shoulda.ShouldaUtil;
import org.jetbrains.plugins.ruby.testing.shoulda.codeInsight.ShouldaContext;

public final class ShouldaSymbolProvider
implements RubySymbolProvider {
    @Override
    public ContextImpl getAccessContext(@NotNull PsiElement element) {
        RPsiElement rPsiElement;
        if (element == null) {
            ShouldaSymbolProvider.$$$reportNull$$$0(0);
        }
        if ((rPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)element)) == null) {
            return null;
        }
        RClass testClass = RubyPsiUtil.getContainingRClass((PsiElement)rPsiElement);
        if (testClass == null) {
            return null;
        }
        VirtualFile file = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rPsiElement);
        if (!ShouldaUtil.isShouldaTestFile(file, ModuleUtilCore.findModuleForPsiElement((PsiElement)testClass))) {
            return null;
        }
        if (ShouldaUtil.getSimpleCoveringExampleOrSetupTeardownScope(element) != null) {
            return ContextImpl.INSTANCE_PRIVATE;
        }
        if (ShouldaUtil.getSimpleCoveringExampleGroupScope(element) != null) {
            return ShouldaContext.getInstance();
        }
        return null;
    }

    @Override
    public Symbol getSymbolScope(@NotNull PsiElement element) {
        Module module;
        RPsiElement rPsiElement;
        if (element == null) {
            ShouldaSymbolProvider.$$$reportNull$$$0(1);
        }
        if ((rPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)element)) == null) {
            return null;
        }
        RClass testClass = RubyPsiUtil.getContainingRClass((PsiElement)rPsiElement);
        if (testClass == null) {
            return null;
        }
        VirtualFile file = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rPsiElement);
        if (!ShouldaUtil.isShouldaTestFile(file, module = ModuleUtilCore.findModuleForPsiElement((PsiElement)testClass))) {
            return null;
        }
        RPossibleCall exampleBlock = ShouldaUtil.getSimpleCoveringExampleOrSetupTeardownScope(element);
        if (exampleBlock != null) {
            return SymbolUtil.getSymbolByContainer(SymbolUtil.getContextContainer((PsiElement)rPsiElement));
        }
        RBlockCall contextBlock = ShouldaUtil.getSimpleCoveringExampleGroupScope(element);
        if (contextBlock == null) {
            return null;
        }
        Symbol shouldContextClassSymbol = SymbolUtil.findConstantByFQN(rPsiElement.getProject(), Type.CLASS, ShouldaUtil.getShouldContextClass(module), null);
        Symbol testClassSymbol = SymbolUtil.getSymbolByContainer(SymbolUtil.getContextContainer((PsiElement)rPsiElement));
        if (shouldContextClassSymbol == null) {
            return null;
        }
        if (testClassSymbol == null) {
            return shouldContextClassSymbol;
        }
        PsiElement declaration = shouldContextClassSymbol.getPsiElement();
        if (!(declaration instanceof RContainer)) {
            return null;
        }
        return new ClassModuleSymbolWithMixins((RContainer)declaration, null, Collections.singletonList(testClassSymbol.getSingletonClassSymbol()), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public Symbol createSymbolByContainer(@NotNull RContainer container, @NotNull FQN fqnPath, @Nullable Symbol parent) {
        if (container == null) {
            ShouldaSymbolProvider.$$$reportNull$$$0(2);
        }
        if (fqnPath == null) {
            ShouldaSymbolProvider.$$$reportNull$$$0(3);
        }
        if (!(container instanceof RClass) && !(container instanceof RModule)) {
            return null;
        }
        if (FQN.same((FQN)fqnPath, (String)"MiniTest::Spec") || FQN.same((FQN)fqnPath, (String)"Minitest::Spec") || FQN.same((FQN)fqnPath, (String)"Test::Unit::TestCase")) {
            Symbol contextLoadable = SymbolUtil.findConstantByFQN(container.getProject(), Type.MODULE, "ShouldaContextLoadable", null);
            if (contextLoadable == null) {
                contextLoadable = SymbolUtil.findConstantByFQN(container.getProject(), Type.MODULE, FQN.of((String)"Shoulda::Context::DSL"), null);
            }
            if (contextLoadable != null) {
                return new ClassModuleSymbolWithMixins(container, parent, Collections.singletonList(contextLoadable), Collections.emptyList(), Collections.emptyList());
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqnPath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/shoulda/codeInsight/ShouldaSymbolProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAccessContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSymbolScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createSymbolByContainer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

