/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.testing.RubyTestFrameworkDetector;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecFilter;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfiguration;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfigurationType;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecSharedGroupOnFirstRunCustomizer;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public final class RSpecScriptTestsConfigurationProducer
extends LazyRunConfigurationProducer<RSpecRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(RSpecScriptTestsConfigurationProducer.class);
    public static final Pattern EXAMPLE_LOCATION_MESSAGE_PATTERN = Pattern.compile(".*example at .+:\\d+");

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = RSpecRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    public boolean isConfigurationFromContext(@NotNull RSpecRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Module locationModule;
        String filter;
        Location location;
        if (configuration == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((location = context.getLocation()) == null || context.containsMultipleSelection()) {
            return false;
        }
        PsiElement locationElement = location.getPsiElement();
        VirtualFile file = RSpecScriptTestsConfigurationProducer.getRSpecScriptFile(locationElement, location.getVirtualFile());
        if (file == null) {
            return false;
        }
        String scriptPath = file.getPath();
        NotNullLazyValue exampleNameFilter = NotNullLazyValue.lazy(() -> StringUtil.notNullize((String)RSpecScriptTestsConfigurationProducer.determineExampleFilterString(context)));
        if (configuration.getTestType() != AbstractRubyTestsRunConfigurationParams.TestType.TEST_SCRIPT) {
            return false;
        }
        if (!scriptPath.equals(configuration.getTestScriptPath())) {
            return false;
        }
        String candidateElementNameFilter = configuration.getExampleNamesFilter();
        if (!candidateElementNameFilter.equals(filter = (String)exampleNameFilter.getValue())) {
            return false;
        }
        Module module = configuration.getModule();
        return Objects.equals(module, locationModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)locationElement));
    }

    protected boolean setupConfigurationFromContext(@NotNull RSpecRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Module module;
        if (configuration == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (sourceElement == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(5);
        }
        LOG.debug("Attempting to set up ocnfiguration from context: configuration=", new Object[]{configuration, "; context=", context, "; sourceElement=", sourceElement});
        Location location = context.getLocation();
        if (location == null || context.containsMultipleSelection()) {
            LOG.debug("Context is null or ambiguous: location=", new Object[]{location, "; multipleSelection=", context.containsMultipleSelection()});
            return false;
        }
        PsiElement locationElement = location.getPsiElement();
        Project project = location.getProject();
        VirtualFile file = RSpecScriptTestsConfigurationProducer.getRSpecScriptFile(locationElement, location.getVirtualFile());
        Module module2 = module = file != null ? ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project) : null;
        if (file == null || module != null && !RSpecUtil.isRSpecSupportEnabled(module)) {
            LOG.debug("File not found or rspec is not enabled: file=", new Object[]{file, "; module=", module});
            return false;
        }
        RFile psiFile = (RFile)ObjectUtils.tryCast((Object)locationElement.getContainingFile(), RFile.class);
        if (psiFile != null && RubyTestFrameworkDetector.detectFrameworkForFile(psiFile) == RubyTestFrameworkDetector.Result.MINITEST) {
            LOG.debug("Wrong test framework detected: ", new Object[]{RubyTestFrameworkDetector.detectFrameworkForFile(psiFile)});
            return false;
        }
        if (RSpecUtil.isProbablyInDisabledCallScope(locationElement)) {
            LOG.debug("Disabled call scope");
            return false;
        }
        String exampleName = null;
        String exampleFilter = null;
        boolean containsRegex = false;
        SMTRunnerTestTreeView testTree = (SMTRunnerTestTreeView)context.getDataContext().getData(SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW);
        if (testTree != null) {
            exampleFilter = exampleName = RSpecScriptTestsConfigurationProducer.buildExampleFilterFromTestTree(testTree.getSelectedTest(), project);
        }
        if (exampleName == null) {
            exampleName = RSpecScriptTestsConfigurationProducer.determineExampleName(context);
            RSpecFilter filter = RSpecScriptTestsConfigurationProducer.determineExampleFilter(context);
            exampleFilter = (String)ObjectUtils.doIfNotNull((Object)filter, RSpecFilter::getFilter);
            containsRegex = filter != null && filter.containsRegex();
        }
        return RSpecScriptTestsConfigurationProducer.createRunRSpecScriptTestsConf(project, file, location, configuration, exampleName, exampleFilter, containsRegex);
    }

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        if (configuration == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (context == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (startRunnable == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (RSpecSharedGroupOnFirstRunCustomizer.customizeAndRun(configuration, context, startRunnable)) {
            return;
        }
        super.onFirstRun(configuration, context, startRunnable);
    }

    @Nullable
    private static VirtualFile getRSpecScriptFile(PsiElement locationElement, VirtualFile file) {
        RFile containingFile = RubyPsiUtil.getRFile(locationElement);
        if (containingFile == null || file == null) {
            return null;
        }
        if (!RubyVirtualFileScanner.isRubyFile(file)) {
            return null;
        }
        if (!RSpecUtil.isFileWithRSpecTestFileName(file)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)locationElement);
        if (module == null) {
            return null;
        }
        return file;
    }

    @Nullable
    public static String determineExampleName(@NotNull ConfigurationContext context) {
        PsiElement locationElement;
        if (context == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(9);
        }
        if ((locationElement = RSpecScriptTestsConfigurationProducer.getTestLocationElement(context)) == null) {
            return null;
        }
        return RSpecUtil.getCurrentExampleName(locationElement);
    }

    @Nullable
    public static String determineExampleFilterString(@NotNull ConfigurationContext context) {
        if (context == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(10);
        }
        return (String)ObjectUtils.doIfNotNull((Object)RSpecScriptTestsConfigurationProducer.determineExampleFilter(context), RSpecFilter::getFilter);
    }

    @Nullable
    public static RSpecFilter determineExampleFilter(@NotNull ConfigurationContext context) {
        PsiElement locationElement;
        if (context == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(11);
        }
        if ((locationElement = RSpecScriptTestsConfigurationProducer.getTestLocationElement(context)) == null) {
            return null;
        }
        return RSpecUtil.determineCurrentExampleFilter(locationElement);
    }

    @Nullable
    private static PsiElement getTestLocationElement(@NotNull ConfigurationContext context) {
        PsiElement locationElement;
        if (context == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(12);
        }
        if ((locationElement = context.getPsiLocation()) == null) {
            return null;
        }
        boolean focusedTestIsAvailable = RSpecUtil.isProbablyInExampleScope(locationElement) || RSpecUtil.isProbablyInExampleGroupScope(locationElement) || RSpecUtil.isProbablyInSharedExampleGroupScope(locationElement);
        return focusedTestIsAvailable ? locationElement : null;
    }

    @Nullable
    public static String buildExampleFilterFromTestTree(@Nullable AbstractTestProxy test, @Nullable Project project) {
        List<AbstractTestProxy> testToRoot = Stream.iterate(test, Objects::nonNull, AbstractTestProxy::getParent).filter(it -> !RSpecScriptTestsConfigurationProducer.isRootTestNode(it) && !RSpecScriptTestsConfigurationProducer.isAnonymousTestLeaf(it)).toList();
        List rootToTest = ContainerUtil.reverse(testToRoot);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < testToRoot.size(); ++i) {
            AbstractTestProxy previous;
            Location location;
            PsiElement element;
            RBlockCall exampleGroup;
            AbstractTestProxy current = (AbstractTestProxy)rootToTest.get(i);
            String name = StringUtil.notNullize((String)current.getName());
            if (i == 0) {
                stringBuilder.append(name);
                continue;
            }
            if (name.startsWith("#") && project != null && i != testToRoot.size() - 1 && (exampleGroup = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)(element = (location = (previous = (AbstractTestProxy)rootToTest.get(i - 1)).getLocation(project, GlobalSearchScope.projectScope((Project)project))).getPsiElement()), RBlockCall.class)) != null) {
                RPsiElement describedElement = (RPsiElement)ContainerUtil.getOnlyItem((Collection)exampleGroup.getArguments());
                if (describedElement == null) {
                    return null;
                }
                if (RSpecUtil.isMethodDescriptionAfterModule(name, describedElement)) {
                    stringBuilder.append(name);
                    continue;
                }
            }
            stringBuilder.append(" ");
            stringBuilder.append(name);
        }
        return stringBuilder.toString();
    }

    private static boolean isRootTestNode(AbstractTestProxy it) {
        return it.getParent() == null && "[root]".equals(it.getName());
    }

    private static boolean isAnonymousTestLeaf(AbstractTestProxy it) {
        return it.isLeaf() && EXAMPLE_LOCATION_MESSAGE_PATTERN.matcher(it.getName()).matches();
    }

    private static boolean createRunRSpecScriptTestsConf(@NotNull Project project, @NotNull VirtualFile file, @NotNull Location location, @NotNull RSpecRunConfiguration configuration, @Nullable String exampleOrGroupPresentableName, @Nullable String exampleOrGroupNameFilter, boolean containsRegex) {
        Module module;
        if (project == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (file == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(14);
        }
        if (location == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(15);
        }
        if (configuration == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(16);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null) {
            LOG.debug("Module not found for ", new Object[]{file, " in ", project});
            return false;
        }
        configuration.setGeneratedName(RSpecScriptTestsConfigurationProducer.createConfName(file, exampleOrGroupPresentableName));
        configuration.setModule(module);
        RunConfigurationUtil.setRspecWorkingDirectoryIfNecessary(configuration, file, project, module);
        configuration.setTestType(AbstractRubyTestsRunConfigurationParams.TestType.TEST_SCRIPT);
        configuration.setTestScriptPath(file.getPath());
        RSpecUtil.setCommonRunConfParams(configuration, exampleOrGroupNameFilter, module, location, containsRegex);
        return true;
    }

    private static String createConfName(@NotNull VirtualFile file, @Nullable String exampleOrGroupPresentableName) {
        if (file == null) {
            RSpecScriptTestsConfigurationProducer.$$$reportNull$$$0(17);
        }
        if (StringUtil.isNotEmpty((String)exampleOrGroupPresentableName)) {
            return exampleOrGroupPresentableName;
        }
        return file.getNameWithoutExtension();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecScriptTestsConfigurationProducer";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRunnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecScriptTestsConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onFirstRun";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "determineExampleName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "determineExampleFilterString";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "determineExampleFilter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocationElement";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRunRSpecScriptTestsConf";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createConfName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

