/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.run;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfiguration;

public class RSpecRunConfigurationExternalizer
extends SettingsExternalizer {
    private static final RSpecRunConfigurationExternalizer myInstance = new RSpecRunConfigurationExternalizer();
    @NonNls
    public static final String RSPEC_RUN_CONFIG_SETTINGS_ID = "RSPEC_RUN_CONFIG_SETTINGS_ID";
    @NonNls
    private static final String SPEC_ARGS = "SPEC_ARGS";
    @NonNls
    private static final String TESTS_FOLDER_PATH = "TESTS_FOLDER_PATH";
    @NonNls
    private static final String TEST_SCRIPT_PATH = "TEST_SCRIPT_PATH";
    @NonNls
    private static final String TEST_SCRIPTS_PATHS = "TEST_SCRIPT_PATHS";
    @NonNls
    private static final String SPEC_RUNNER_PATH = "SPEC_RUNNER_PATH";
    @NonNls
    private static final String RUNNER_VERSION = "RUNNER_VERSION";
    @NonNls
    private static final String TEST_FILE_MASK = "TEST_FILE_MASK";
    @NonNls
    private static final String SPEC_EXAMPLE_NAME = "SPEC_EXAMPLE_NAME";
    @NonNls
    private static final String LINE_NUMBER_EXAMPLE_IDS = "LINE_NUMBER_EXAMPLE_IDS";
    @NonNls
    private static final String TEST_TEST_TYPE = "TEST_TEST_TYPE";
    @NonNls
    private static final String USE_CUSTOM_SPEC_RUNNER = "USE_CUSTOM_SPEC_RUNNER";
    @NonNls
    private static final String DRB = "DRB";
    @NonNls
    private static final String ZEUS = "ZEUS";
    @NonNls
    private static final String SPRING = "SPRING";
    @NonNls
    private static final String FULL_BACKTRACE = "FULL_BACKTRACE";
    @NonNls
    private static final String USE_EXAMPLE_MATCHES = "USE_EXAMPLE_MATCHES";

    public void writeExternal(RSpecRunConfiguration config, Element elem) {
        this.writeOption(TESTS_FOLDER_PATH, config.getTestsFolderPath(), elem);
        this.writeOption(TEST_SCRIPT_PATH, config.getTestScriptPath(), elem);
        this.writeOption(TEST_SCRIPTS_PATHS, StringUtil.join(config.getTestScriptsPaths(), (String)"||"), elem);
        this.writeOption(SPEC_RUNNER_PATH, config.getCustomSpecsRunnerPath(), elem);
        this.writeOption(TEST_FILE_MASK, config.getTestFileMask(), elem);
        this.writeOption(SPEC_EXAMPLE_NAME, config.getExampleNamesFilter(), elem);
        this.writeOption(USE_EXAMPLE_MATCHES, String.valueOf(config.getUseExampleMatches()), elem);
        this.writeOption(LINE_NUMBER_EXAMPLE_IDS, config.getLineNumberOrExampleIDs(), elem);
        this.writeOption(TEST_TEST_TYPE, config.getTestType().toString(), elem);
        this.writeOption(SPEC_ARGS, config.getRunnerOptions(), elem);
        this.writeOption(RUNNER_VERSION, config.getRunnerGemVersion(), elem);
        this.writeOption(USE_CUSTOM_SPEC_RUNNER, String.valueOf(config.shouldUseCustomSpecRunner()), elem);
        this.writeOption(DRB, String.valueOf(config.getPreloadServer() == PreLoadUtil.PreLoadServer.DRb), elem);
        this.writeOption(ZEUS, String.valueOf(config.getPreloadServer() == PreLoadUtil.PreLoadServer.Zeus), elem);
        this.writeOption(SPRING, String.valueOf(config.getPreloadServer() == PreLoadUtil.PreLoadServer.Spring), elem);
        this.writeOption(FULL_BACKTRACE, String.valueOf(config.isBacktraceEnabled()), elem);
    }

    public void readExternal(RSpecRunConfiguration config, Element elem) {
        Map<String, String> optionsByName = this.buildOptionsByElement(elem);
        config.setRunnerOptions(optionsByName.get(SPEC_ARGS));
        config.setRunnerGemVersion(optionsByName.get(RUNNER_VERSION));
        config.setTestsFolderPath(optionsByName.get(TESTS_FOLDER_PATH));
        config.setTestScriptPath(optionsByName.get(TEST_SCRIPT_PATH));
        String scripts = optionsByName.get(TEST_SCRIPTS_PATHS);
        config.setTestScriptsPaths(scripts == null ? List.of() : StringUtil.split((String)scripts, (String)"||"));
        config.setCustomSpecsRunnerPath(optionsByName.get(SPEC_RUNNER_PATH));
        config.setTestFileMask(optionsByName.get(TEST_FILE_MASK));
        config.setExampleNamesFilter(optionsByName.get(SPEC_EXAMPLE_NAME));
        config.setUseExampleMatches(Boolean.parseBoolean(optionsByName.get(USE_EXAMPLE_MATCHES)));
        config.setLineNumberOrExampleIDs(optionsByName.get(LINE_NUMBER_EXAMPLE_IDS));
        String type_value = optionsByName.get(TEST_TEST_TYPE);
        if (type_value != null) {
            config.setTestType(Enum.valueOf(AbstractRubyTestsRunConfigurationParams.TestType.class, type_value));
        }
        config.setShouldUseCustomSpecRunner(Boolean.valueOf(optionsByName.get(USE_CUSTOM_SPEC_RUNNER)));
        if (Boolean.valueOf(optionsByName.get(DRB)).booleanValue()) {
            config.setPreloadServer(PreLoadUtil.PreLoadServer.DRb);
        } else if (Boolean.parseBoolean(optionsByName.get(ZEUS))) {
            config.setPreloadServer(PreLoadUtil.PreLoadServer.Zeus);
        } else if (Boolean.valueOf(optionsByName.get(SPRING)).booleanValue()) {
            config.setPreloadServer(PreLoadUtil.PreLoadServer.Spring);
        }
        config.setBacktraceEnabled(Boolean.valueOf(optionsByName.get(FULL_BACKTRACE)));
    }

    public static RSpecRunConfigurationExternalizer getInstance() {
        return myInstance;
    }

    @Override
    @NotNull
    public String getID() {
        return RSPEC_RUN_CONFIG_SETTINGS_ID;
    }
}

