/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.run;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.GemRunnerBasedParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfiguration;
import org.jetbrains.plugins.ruby.testing.rspec.runConfigurations.RSpecRunConfigurationParams;

public class RSpecRunConfigurationEditor
extends SettingsEditor<RSpecRunConfiguration>
implements RSpecRunConfigurationParams,
PanelWithAnchor {
    private JPanel myConfigurationPanel;
    private JRadioButton myAllInFolderRB;
    private JRadioButton myTestScriptRB;
    private JRadioButton myCustomSetRB;
    private JBLabel myTestTypeComponent;
    private LabeledComponent mySpecsFolderComponent;
    private LabeledComponent mySpecsScriptComponent;
    private LabeledComponent mySpecsFileMaskComponent;
    private LabeledComponent myFilenamesComponent;
    private LabeledComponent myRunnerOptionsComponent;
    private LabeledComponent mySpecsExampleNameComponent;
    private LabeledComponent myPreloadServerComponent;
    private JCheckBox myCBUseCustomSpecRunner;
    private TextFieldWithBrowseButton mySpecsFolderTextField;
    private TextFieldWithBrowseButton mySpecsScriptTextField;
    private TextFieldWithBrowseButton myCustomSpecsRunnerTextField;
    private TextFieldWithBrowseButton myFilenamesTextField;
    private JTextField mySpecsFileMaskTextField;
    private ExpandableTextField mySpecsExampleNameTextField;
    private ExpandableTextField myLineNumberExampleIDTextField;
    private RawCommandLineEditor myRunnerOptionsEditor;
    private final Project myProject;
    private JCheckBox myCBFullBacktrace;
    private JPanel myCommonOptionsPanel;
    private JPanel myGemRunnerParamsPanel;
    private LabeledComponent<ExpandableTextField> myLineNumberExampleIDsComponent;
    private JComboBox myPreloadServer;
    private final RubyCommonRunParamsEditor myCommonEditor;
    private final GemRunnerBasedParamsEditor myGemRunnerParamsEditor;
    private JComponent myAnchor;

    public RSpecRunConfigurationEditor(Project project, RSpecRunConfiguration configuration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonEditor = RunConfigurationUIUtil.createRubyCommonRunParamsEditor(configuration, "rspec", this.myCommonOptionsPanel);
        ArrayList<String> gemNameList = new ArrayList<String>();
        gemNameList.add("rspec");
        gemNameList.add("rspec-core");
        HashMap<String, GemRunnerBasedParamsEditor.Filter> gems2FilterTable = new HashMap<String, GemRunnerBasedParamsEditor.Filter>();
        gems2FilterTable.put("rspec", new GemRunnerBasedParamsEditor.Filter(this){

            @Override
            public boolean accept(@NotNull GemInfo gem) {
                if (gem == null) {
                    1.$$$reportNull$$$0(0);
                }
                return VersionComparatorUtil.compare((String)gem.getVersion(), (String)"2.0") < 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gem", "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecRunConfigurationEditor$1", "accept"));
            }
        });
        this.myGemRunnerParamsEditor = RunConfigurationUIUtil.createGemRunnerBasedParamsEditor(this.myGemRunnerParamsPanel, gemNameList, gems2FilterTable, this.myCommonEditor);
        this.initComponents();
        this.setupAnchor();
    }

    private void initComponents() {
        String title = RBundle.message((String)"run.configuration.messages.select.folder.path");
        RunConfigurationUIUtil.addFolderChooser(title, this.mySpecsFolderTextField, this.myProject);
        title = RBundle.message((String)"run.configuration.messages.select.ruby.script.path");
        RunConfigurationUIUtil.addFileChooser(title, this.mySpecsScriptTextField, this.myProject);
        title = RBundle.message((String)"rspec.run.configuration.tests.dialog.components.select.spec.custom.runner");
        RunConfigurationUIUtil.addFileChooser(title, this.myCustomSpecsRunnerTextField, this.myProject);
        ActionListener testTypeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RSpecRunConfigurationEditor.this.setTestType(RSpecRunConfigurationEditor.this.getTestType());
            }
        };
        this.myAllInFolderRB.addActionListener(testTypeListener);
        this.myTestScriptRB.addActionListener(testTypeListener);
        this.myCustomSetRB.addActionListener(testTypeListener);
        this.myCBUseCustomSpecRunner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean useCustomRunner = RSpecRunConfigurationEditor.this.shouldUseCustomSpecRunner();
                RSpecRunConfigurationEditor.this.myCustomSpecsRunnerTextField.setEnabled(useCustomRunner);
            }
        });
        this.setShouldUseCustomSpecRunner(false);
        this.myPreloadServer.setModel(new EnumComboBoxModel(PreLoadUtil.PreLoadServer.class));
    }

    private void createUIComponents() {
        Ref runnerOptionsEditorRef = new Ref();
        this.myRunnerOptionsComponent = RunConfigurationUIUtil.createRunnerOptionsComponent((Ref<? super RawCommandLineEditor>)runnerOptionsEditorRef);
        this.myRunnerOptionsEditor = (RawCommandLineEditor)runnerOptionsEditorRef.get();
        Ref testsFolderTextFieldWrapper = new Ref();
        this.mySpecsFolderComponent = RunConfigurationUIUtil.createTestFolderComponent((Ref<? super TextFieldWithBrowseButton>)testsFolderTextFieldWrapper);
        this.mySpecsFolderTextField = (TextFieldWithBrowseButton)testsFolderTextFieldWrapper.get();
        Ref testScriptTextFieldWrapper = new Ref();
        String specFileTitle = RBundle.message((String)"rspec.run.configuration.messages.script.path");
        this.mySpecsScriptComponent = RunConfigurationUIUtil.createScriptPathComponent((Ref<? super TextFieldWithBrowseButton>)testScriptTextFieldWrapper, specFileTitle);
        this.mySpecsScriptTextField = (TextFieldWithBrowseButton)testScriptTextFieldWrapper.get();
        Ref specExampleNameTextFieldWrapper = new Ref();
        this.mySpecsExampleNameComponent = RunConfigurationUIUtil.createRSpecExamplesComponent((Ref<? super ExpandableTextField>)specExampleNameTextFieldWrapper);
        this.mySpecsExampleNameTextField = (ExpandableTextField)specExampleNameTextFieldWrapper.get();
        Ref lineNumberTextFieldWrapper = new Ref();
        this.myLineNumberExampleIDsComponent = RunConfigurationUIUtil.createRSpecLineNumberExampleIDsComponent((Ref<? super ExpandableTextField>)lineNumberTextFieldWrapper);
        this.myLineNumberExampleIDTextField = (ExpandableTextField)lineNumberTextFieldWrapper.get();
        Ref testFileMaskTextFieldWrapper = new Ref();
        String text = RBundle.message((String)"rspec.run.configuration.tests.dialog.components.search.mask");
        this.mySpecsFileMaskComponent = RunConfigurationUIUtil.createTextFieldLabeledComponent((Ref<? super JTextField>)testFileMaskTextFieldWrapper, text);
        this.mySpecsFileMaskTextField = (JTextField)testFileMaskTextFieldWrapper.get();
        Ref filenamesTextFieldWrapper = new Ref();
        this.myFilenamesComponent = RunConfigurationUIUtil.createMultiFileChooserTextField((Ref<? super TextFieldWithBrowseButton>)filenamesTextFieldWrapper, RBundle.message((String)"rspec.run.configuration.tests.dialog.components.filenames"), this.myProject, (FileType)RubyFileType.RUBY, (Condition<? super VirtualFile>)((Condition)file -> RSpecUtil.isFileWithRSpecTestFileName(file)));
        this.myFilenamesTextField = (TextFieldWithBrowseButton)filenamesTextFieldWrapper.get();
        this.myPreloadServer = new ComboBox();
        this.myPreloadServerComponent = LabeledComponent.create((JComponent)this.myPreloadServer, (String)RBundle.message((String)"preload.use.server"));
    }

    public JComponent getPanel() {
        return this.myConfigurationPanel;
    }

    public String getPath() {
        return FileUtil.toSystemIndependentName((String)this.mySpecsFolderTextField.getText().trim());
    }

    @Override
    public boolean shouldUseCustomSpecRunner() {
        return this.myCBUseCustomSpecRunner.isSelected();
    }

    @Override
    public void setShouldUseCustomSpecRunner(boolean shouldUse) {
        this.myCBUseCustomSpecRunner.setSelected(shouldUse);
        this.myCustomSpecsRunnerTextField.setEnabled(shouldUse);
    }

    @Override
    public String getTestsFolderPath() {
        return FileUtil.toSystemIndependentName((String)this.mySpecsFolderTextField.getText().trim());
    }

    @Override
    public String getTestScriptPath() {
        return FileUtil.toSystemIndependentName((String)this.mySpecsScriptTextField.getText().trim());
    }

    @Override
    @NotNull
    public List<String> getTestScriptsPaths() {
        if (this.getTestType() == AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES) {
            List<String> list = List.of(this.myFilenamesTextField.getText().split("\\|\\|"));
            if (list == null) {
                RSpecRunConfigurationEditor.$$$reportNull$$$0(0);
            }
            return list;
        }
        String path = this.getTestScriptPath();
        List<Object> list = path.isEmpty() ? List.of() : List.of(path);
        if (list == null) {
            RSpecRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setTestScriptsPaths(@NotNull List<String> paths) {
        if (paths == null) {
            RSpecRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        this.myFilenamesTextField.setText(StringUtil.join(paths, (String)"||"));
    }

    @Override
    public String getExampleNamesFilter() {
        return this.mySpecsExampleNameTextField.getText();
    }

    @Override
    public String getLineNumberOrExampleIDs() {
        return this.myLineNumberExampleIDTextField.getText();
    }

    @Override
    public boolean getUseExampleMatches() {
        return false;
    }

    @Override
    public String getCustomSpecsRunnerPath() {
        String path = this.myCustomSpecsRunnerTextField.getText().trim();
        if (RSpecRunConfigurationEditor.getDefaultCustomSpecRunner().equals(path)) {
            return "";
        }
        return FileUtil.toSystemIndependentName((String)path);
    }

    @Override
    public String getTestFileMask() {
        return this.mySpecsFileMaskTextField.getText();
    }

    public void setPath(String value) {
        this.mySpecsFolderTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)value)));
    }

    @Override
    public void setTestsFolderPath(String path) {
        this.mySpecsFolderTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)path)));
    }

    @Override
    public void setTestScriptPath(String path) {
        this.mySpecsScriptTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)path)));
    }

    @Override
    public void setExampleNamesFilter(String name) {
        this.mySpecsExampleNameTextField.setText(StringUtil.notNullize((String)name));
    }

    @Override
    public void setLineNumberOrExampleIDs(@NotNull String lineNumberOrExampleIDs) {
        if (lineNumberOrExampleIDs == null) {
            RSpecRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        this.myLineNumberExampleIDTextField.setText(lineNumberOrExampleIDs);
    }

    @Override
    public void setUseExampleMatches(boolean exampleMatches) {
    }

    @Override
    public void setCustomSpecsRunnerPath(String path) {
        if (StringUtil.isEmpty((String)path)) {
            this.myCustomSpecsRunnerTextField.setText(RSpecRunConfigurationEditor.getDefaultCustomSpecRunner());
        } else {
            this.myCustomSpecsRunnerTextField.setText(FileUtil.toSystemDependentName((String)path));
        }
    }

    @Override
    public void setTestFileMask(String name) {
        this.mySpecsFileMaskTextField.setText(name);
    }

    @Override
    public AbstractRubyTestsRunConfigurationParams.TestType getTestType() {
        if (this.myAllInFolderRB.isSelected()) {
            return AbstractRubyTestsRunConfigurationParams.TestType.ALL_IN_FOLDER;
        }
        if (this.myCustomSetRB.isSelected()) {
            return AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES;
        }
        return AbstractRubyTestsRunConfigurationParams.TestType.TEST_SCRIPT;
    }

    @Override
    public boolean isBacktraceEnabled() {
        return this.myCBFullBacktrace.isSelected();
    }

    @Override
    public void setBacktraceEnabled(boolean isEnabled) {
        this.myCBFullBacktrace.setSelected(isEnabled);
    }

    @Override
    @NotNull
    public PreLoadUtil.PreLoadServer getPreloadServer() {
        PreLoadUtil.PreLoadServer preLoadServer = (PreLoadUtil.PreLoadServer)((Object)this.myPreloadServer.getSelectedItem());
        if (preLoadServer == null) {
            RSpecRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return preLoadServer;
    }

    @Override
    public void setPreloadServer(@NotNull PreLoadUtil.PreLoadServer server) {
        if (server == null) {
            RSpecRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        this.myPreloadServer.setSelectedItem((Object)server);
    }

    @Override
    public void setTestType(@NotNull AbstractRubyTestsRunConfigurationParams.TestType testType) {
        if (testType == null) {
            RSpecRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        this.clearTestTypeSettings(testType);
        this.mySpecsScriptComponent.setEnabled(true);
        switch (testType) {
            case ALL_IN_FOLDER: {
                this.myAllInFolderRB.setSelected(true);
                this.mySpecsFolderComponent.setVisible(true);
                this.mySpecsFileMaskComponent.setVisible(true);
                this.mySpecsScriptComponent.setVisible(false);
                this.mySpecsExampleNameComponent.setVisible(false);
                this.myLineNumberExampleIDsComponent.setVisible(false);
                this.myFilenamesComponent.setVisible(false);
                break;
            }
            case TEST_SCRIPT: {
                this.myTestScriptRB.setSelected(true);
                this.mySpecsFolderComponent.setVisible(false);
                this.mySpecsFileMaskComponent.setVisible(false);
                this.mySpecsScriptComponent.setVisible(true);
                this.mySpecsExampleNameComponent.setVisible(true);
                this.myLineNumberExampleIDsComponent.setVisible(true);
                this.myFilenamesComponent.setVisible(false);
                break;
            }
            case TEST_METHOD: {
                break;
            }
            case CUSTOM_SET_OF_FILES: {
                this.myCustomSetRB.setSelected(true);
                this.mySpecsFolderComponent.setVisible(false);
                this.mySpecsFileMaskComponent.setVisible(false);
                this.mySpecsScriptComponent.setVisible(false);
                this.mySpecsExampleNameComponent.setVisible(true);
                this.myLineNumberExampleIDsComponent.setVisible(false);
                this.myFilenamesComponent.setVisible(true);
            }
        }
    }

    private void clearTestTypeSettings(AbstractRubyTestsRunConfigurationParams.TestType testType) {
        this.setTestsFolderPath("");
        this.setTestScriptPath("");
        String value = testType == AbstractRubyTestsRunConfigurationParams.TestType.ALL_IN_FOLDER ? RSpecRunConfiguration.DEFAULT_TESTS_SEARCH_MASK : "";
        this.setTestFileMask(value);
    }

    @Override
    public String getRunnerGemVersion() {
        return this.myGemRunnerParamsEditor.getRunnerGemVersion();
    }

    @Override
    public void setRunnerGemVersion(@Nullable String gemVersion) {
        this.myGemRunnerParamsEditor.setRunnerGemVersion(gemVersion);
    }

    @Override
    public void setRunnerOptions(String specArgs) {
        this.myRunnerOptionsEditor.setText(specArgs);
    }

    @Override
    public String getRunnerOptions() {
        return this.myRunnerOptionsEditor.getText().trim();
    }

    protected void resetEditorFrom(@NotNull RSpecRunConfiguration config) {
        if (config == null) {
            RSpecRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        RSpecRunConfiguration.copyParams(config, this);
        this.myCommonEditor.resetEditorFrom(config);
        this.myGemRunnerParamsEditor.resetEditorFrom(config, config.getSdk(), config.getModule());
    }

    protected void applyEditorTo(@NotNull RSpecRunConfiguration config) throws ConfigurationException {
        if (config == null) {
            RSpecRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        RSpecRunConfiguration.copyParams(this, config);
        this.myCommonEditor.applyEditorTo(config);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myConfigurationPanel;
        if (jPanel == null) {
            RSpecRunConfigurationEditor.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myTestTypeComponent.setAnchor(anchor);
        this.myRunnerOptionsComponent.setAnchor(anchor);
        this.myGemRunnerParamsEditor.setAnchor(anchor);
        this.mySpecsExampleNameComponent.setAnchor(anchor);
        this.myLineNumberExampleIDsComponent.setAnchor(anchor);
        this.mySpecsFileMaskComponent.setAnchor(anchor);
        this.mySpecsScriptComponent.setAnchor(anchor);
        this.mySpecsFolderComponent.setAnchor(anchor);
        this.myCommonEditor.setAnchor(anchor);
        this.myPreloadServerComponent.setAnchor(anchor);
        this.myFilenamesComponent.setAnchor(anchor);
    }

    private void setupAnchor() {
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myCommonEditor, this.myRunnerOptionsComponent, this.myGemRunnerParamsEditor, this.mySpecsExampleNameComponent, this.myLineNumberExampleIDsComponent, this.mySpecsFileMaskComponent, this.mySpecsScriptComponent, this.mySpecsFolderComponent, this.myPreloadServerComponent, this.myFilenamesComponent});
        this.myTestTypeComponent.setAnchor(this.myAnchor);
    }

    @Nls
    private static String getDefaultCustomSpecRunner() {
        return RBundle.message((String)"run.configuration.messages.not.specified");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineNumberOrExampleIDs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testType";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestScriptsPaths";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecRunConfigurationEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreloadServer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTestScriptsPaths";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setLineNumberOrExampleIDs";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPreloadServer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTestType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JBLabel jBLabel;
        JRadioButton jRadioButton3;
        JPanel jPanel3;
        this.createUIComponents();
        this.myConfigurationPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAllInFolderRB = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.tests.dialog.rb.allInFolder"));
        jPanel4.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTestTypeComponent = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.tests.form.testtype.title"));
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestScriptRB = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.tests.dialog.rb.file"));
        jPanel4.add((Component)jRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCustomSetRB = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.tests.dialog.rb.custom"));
        jPanel4.add((Component)jRadioButton, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(10, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LabeledComponent labeledComponent = this.mySpecsFolderComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.tests.dialog.components.folder"));
        jPanel5.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent2 = this.mySpecsScriptComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.messages.script.path"));
        jPanel5.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent3 = this.mySpecsFileMaskComponent;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.tests.dialog.components.search.mask"));
        jPanel5.add((Component)labeledComponent3, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent4 = this.mySpecsExampleNameComponent;
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setText(DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.tests.dialog.components.example.name"));
        jPanel5.add((Component)labeledComponent4, new GridConstraints(4, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        LabeledComponent<ExpandableTextField> labeledComponent5 = this.myLineNumberExampleIDsComponent;
        labeledComponent5.setLabelLocation("West");
        labeledComponent5.setText(DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.tests.dialog.components.line.number.example.id"));
        jPanel5.add((Component)labeledComponent5, new GridConstraints(5, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(9, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myCBFullBacktrace = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.tests.backtrace.checkbox"));
        jPanel6.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        LabeledComponent labeledComponent6 = this.myPreloadServerComponent;
        labeledComponent6.setLabelLocation("West");
        labeledComponent6.setText(DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("preload.use.server"));
        jPanel6.add((Component)labeledComponent6, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myGemRunnerParamsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        LabeledComponent labeledComponent7 = this.myRunnerOptionsComponent;
        labeledComponent7.setLabelLocation("West");
        labeledComponent7.setText(DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("run.configuration.messages.runner.options"));
        jPanel5.add((Component)labeledComponent7, new GridConstraints(6, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(8, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myCBUseCustomSpecRunner = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(1, 1, 0, 1));
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.tests.dialog.components.spec.custom.use"));
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomSpecsRunnerTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEnabled(true);
        textFieldWithBrowseButton.setText("");
        jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null, 2));
        LabeledComponent labeledComponent8 = this.myFilenamesComponent;
        labeledComponent8.setLabelLocation("West");
        labeledComponent8.setText(DynamicBundle.getBundle((String)"messages/RBundle", RSpecRunConfigurationEditor.class).getString("rspec.run.configuration.tests.dialog.components.filenames"));
        jPanel5.add((Component)labeledComponent8, new GridConstraints(3, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        this.myCommonOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel3.add((Component)jSeparator, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 7, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myConfigurationPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

