/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusUtil;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationUtil;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfiguration;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RAbstractTestsCommandLineState;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TC_RubySdkUtil;

public class RSpecRunCommandLineState
extends RAbstractTestsCommandLineState {
    @NonNls
    public static final String RSPEC_RUNNER_OPTIONS_FORMATTER_SHORT_KEY = "-f";
    @NonNls
    public static final String RSPEC_RUNNER_OPTIONS_REQUIRE_KEY = "--require";
    @NonNls
    public static final String RSPEC_RUNNER_OPTIONS_FORMATTER_PATH = "teamcity/spec/runner/formatter/teamcity/formatter";
    @NonNls
    public static final String RSPEC_RUNNER_OPTIONS_FORMATTER_KEY = "--format";
    @NonNls
    public static final String RSPEC_RUNNER_OPTIONS_FORMATTER_CLASS = "Spec::Runner::Formatter::TeamcityFormatter";
    @NonNls
    public static final String RSPEC_EXAMPLE_NAME_KEY = "--example";
    @NonNls
    public static final String RSPEC_EXAMPLE_REGEX_KEY = "--example-matches";
    @NonNls
    public static final String RSPEC_DRB_KEY = "--drb";
    @NonNls
    public static final String RSPEC_FULL_BACKTRACE_KEY = "--backtrace";
    @NonNls
    private static final String RSPEC_FILE_PATTERN_KEY = "--pattern";
    @NonNls
    private static final String RSPEC_RUNNER_PARAMS_GROUP_ID = "ruby.tests.rspec.runner";

    public RSpecRunCommandLineState(RSpecRunConfiguration config, ExecutionEnvironment env) {
        super(config, env);
    }

    @Override
    public RSpecRunConfiguration getConfig() {
        return (RSpecRunConfiguration)super.getConfig();
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        ParamsGroup runnerParamsGroup;
        String springExecutable;
        Module module;
        String rspecRunnerScriptPath;
        RSpecRunConfiguration config = this.getConfig();
        AbstractRubyTestsRunConfigurationParams.TestType runConfTyp = config.getTestType();
        String runnerId = this.getRunnerId();
        RubyCommandLineData data = RSpecRunCommandLineState.createDefaultCommandLine(config, runnerId);
        RubyCommandLine commandLine = data.getCommandLine();
        Sdk sdk = config.getSdk();
        LOG.assertTrue(sdk != null);
        RubySdkAdditionalData additionalData = RubySdkAdditionalData.notNullFrom(sdk);
        if (config.isGUIRunnerEnabled()) {
            RSpecRunCommandLineState.configureTestFrameworkSupport(commandLine.getEnvironment(), sdk, config.getModule());
        }
        LOG.assertTrue((rspecRunnerScriptPath = this.determineRSpecRunnerScriptPath(module = config.getModule())) != null);
        String runnerVersion = config.getRunnerGemVersion();
        String testUnitScriptPath = TC_RubySdkUtil.getSdkTestUnitScriptPath(sdk, module);
        if (testUnitScriptPath != null) {
            commandLine.getEnvironment().put("TEAMCIY_RAKE_TU_PATH", RubySdkUtil.convertToRemote(sdk, module, testUnitScriptPath));
        }
        if (config.getPreloadServer() == PreLoadUtil.PreLoadServer.Zeus && this.preLoaderAllowed()) {
            String zeusExecutable = ZeusUtil.getZeusExecutable(module, sdk);
            if (zeusExecutable != null) {
                commandLine.addParameter(RubySdkUtil.convertToRemote(sdk, module, zeusExecutable));
                rspecRunnerScriptPath = "rspec";
                commandLine.getEnvironment().remove("RAILS_ENV");
            }
        } else if (config.getPreloadServer() == PreLoadUtil.PreLoadServer.Spring && RSpecRunCommandLineState.isExplicitSpringEnabled(runnerId) && this.preLoaderAllowed() && (springExecutable = SpringUtil.getSpringExecutable(module, sdk)) != null) {
            commandLine.addParameter(RubySdkUtil.convertToRemote(sdk, module, springExecutable));
            rspecRunnerScriptPath = "rspec";
        }
        switch (runConfTyp) {
            case ALL_IN_FOLDER: {
                runnerParamsGroup = this.addExecutionScriptGroup(RSPEC_RUNNER_PARAMS_GROUP_ID, data, commandLine, rspecRunnerScriptPath);
                if (!StringUtil.isEmpty((String)runnerVersion)) {
                    runnerParamsGroup.addParameter(RSpecRunCommandLineState.asGemVersionCmdlineArgument(runnerVersion));
                }
                runnerParamsGroup.addParameter(RubySdkUtil.convertToRemote(sdk, module, config.getTestsFolderPath()));
                if (config.isGUIRunnerEnabled()) {
                    RSpecRunCommandLineState.addFormatter(runnerParamsGroup);
                }
                RSpecRunCommandLineState.addMaskParam(config, runnerParamsGroup, rspecRunnerScriptPath, additionalData.getSdkSystemAccessor().isWindows(), RubyRemoteInterpreterManager.isRemoteSdk(sdk));
                break;
            }
            case TEST_SCRIPT: {
                runnerParamsGroup = this.addExecutionScriptGroup(RSPEC_RUNNER_PARAMS_GROUP_ID, data, commandLine, rspecRunnerScriptPath);
                if (StringUtil.isNotEmpty((String)runnerVersion)) {
                    runnerParamsGroup.addParameter(RSpecRunCommandLineState.asGemVersionCmdlineArgument(runnerVersion));
                }
                runnerParamsGroup.addParameter(RubySdkUtil.convertToRemote(sdk, module, RSpecRunCommandLineState.getTestScriptPath(config)));
                if (config.isGUIRunnerEnabled()) {
                    RSpecRunCommandLineState.addFormatter(runnerParamsGroup);
                }
                RSpecRunCommandLineState.addExamples(config, runnerParamsGroup);
                break;
            }
            case CUSTOM_SET_OF_FILES: {
                runnerParamsGroup = this.addExecutionScriptGroup(RSPEC_RUNNER_PARAMS_GROUP_ID, data, commandLine, rspecRunnerScriptPath);
                if (StringUtil.isNotEmpty((String)runnerVersion)) {
                    runnerParamsGroup.addParameter(RSpecRunCommandLineState.asGemVersionCmdlineArgument(runnerVersion));
                }
                runnerParamsGroup.addParameters(RubySdkUtil.convertToRemote(sdk, module, config.getTestScriptsPaths()));
                if (config.isGUIRunnerEnabled()) {
                    RSpecRunCommandLineState.addFormatter(runnerParamsGroup);
                }
                RSpecRunCommandLineState.addExamples(config, runnerParamsGroup);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not implemented");
            }
        }
        if (config.getPreloadServer() == PreLoadUtil.PreLoadServer.DRb && this.preLoaderAllowed()) {
            runnerParamsGroup.addParameter(RSPEC_DRB_KEY);
        }
        if (!this.preLoaderAllowed()) {
            PreLoadUtil.showDebuggingInfo(config.getProject(), config.getPreloadServer());
        }
        if (config.isBacktraceEnabled()) {
            runnerParamsGroup.addParameter(RSPEC_FULL_BACKTRACE_KEY);
        }
        String specArgs = config.getRunnerOptions();
        RSpecRunCommandLineState.addParams(runnerParamsGroup, specArgs);
        return data;
    }

    private static void addExamples(@NotNull RSpecRunConfiguration config, @NotNull ParamsGroup runnerParamsGroup) {
        String examplesName;
        if (config == null) {
            RSpecRunCommandLineState.$$$reportNull$$$0(0);
        }
        if (runnerParamsGroup == null) {
            RSpecRunCommandLineState.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)(examplesName = config.getExampleNamesFilter()))) {
            for (String example : StringUtil.filterEmptyStrings((String[])examplesName.split("\\|\\|"))) {
                if (config.getUseExampleMatches()) {
                    runnerParamsGroup.addParameter(RSPEC_EXAMPLE_REGEX_KEY);
                } else {
                    runnerParamsGroup.addParameter(RSPEC_EXAMPLE_NAME_KEY);
                }
                runnerParamsGroup.addParameter(example.trim());
            }
        }
    }

    private static void addMaskParam(@NotNull RSpecRunConfiguration config, @NotNull ParamsGroup runnerParamsGroup, @NotNull String rspecRunnerScriptPath, boolean isWindows, boolean isRemoteSdk) {
        String fileMask;
        if (config == null) {
            RSpecRunCommandLineState.$$$reportNull$$$0(2);
        }
        if (runnerParamsGroup == null) {
            RSpecRunCommandLineState.$$$reportNull$$$0(3);
        }
        if (rspecRunnerScriptPath == null) {
            RSpecRunCommandLineState.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)(fileMask = config.getTestFileMask()))) {
            fileMask = RSpecRunCommandLineState.processQuotedFileMask(fileMask);
            runnerParamsGroup.addParameter(RSPEC_FILE_PATTERN_KEY);
            Object mask = fileMask;
            if (isWindows && !RSpecRunCommandLineState.isRspec1Runner(rspecRunnerScriptPath)) {
                mask = FileUtil.toSystemIndependentName((String)config.getTestsFolderPath()) + "/" + fileMask;
            }
            if (isRemoteSdk) {
                mask = ((String)mask).replaceAll("\\*", "*");
            }
            runnerParamsGroup.addParameter((String)mask);
        }
    }

    private static String processQuotedFileMask(String fileMask) {
        if (fileMask.equals("'" + RSpecRunConfiguration.DEFAULT_TESTS_SEARCH_MASK + "'")) {
            fileMask = RSpecRunConfiguration.DEFAULT_TESTS_SEARCH_MASK;
        }
        return fileMask;
    }

    private static void addFormatter(@NotNull ParamsGroup runnerParamsGroup) {
        if (runnerParamsGroup == null) {
            RSpecRunCommandLineState.$$$reportNull$$$0(5);
        }
        runnerParamsGroup.addParameter(RSPEC_RUNNER_OPTIONS_REQUIRE_KEY);
        runnerParamsGroup.addParameter(RSPEC_RUNNER_OPTIONS_FORMATTER_PATH);
        runnerParamsGroup.addParameter(RSPEC_RUNNER_OPTIONS_FORMATTER_KEY);
        runnerParamsGroup.addParameter(RSPEC_RUNNER_OPTIONS_FORMATTER_CLASS);
    }

    private static boolean isRspec1Runner(@NotNull String rspecRunnerScriptPath) {
        if (rspecRunnerScriptPath == null) {
            RSpecRunCommandLineState.$$$reportNull$$$0(6);
        }
        return FileUtil.toSystemIndependentName((String)rspecRunnerScriptPath).endsWith("/spec");
    }

    public static void configureTestFrameworkSupport(@NotNull Map<String, String> envMap, @NotNull Sdk sdk, @Nullable Module module) throws ExecutionException {
        if (envMap == null) {
            RSpecRunCommandLineState.$$$reportNull$$$0(7);
        }
        if (sdk == null) {
            RSpecRunCommandLineState.$$$reportNull$$$0(8);
        }
        RakeRunConfigurationUtil.configureTestFrameworksSupport(envMap, sdk, module, Collections.singletonList(SupportedTestFramework.RSPEC));
    }

    @NotNull
    private static String getTestScriptPath(@NotNull RSpecRunConfiguration config) {
        if (config == null) {
            RSpecRunCommandLineState.$$$reportNull$$$0(9);
        }
        String scriptPath = config.getTestScriptPath();
        String lineNumberOrExampleIDs = config.getLineNumberOrExampleIDs();
        Matcher lineNumberMatcher = RSpecRunConfiguration.LINE_NUMBER_PATTERN.matcher(lineNumberOrExampleIDs);
        Matcher exampleIDsMatcher = RSpecRunConfiguration.EXAMPLE_IDS_PATTERN.matcher(lineNumberOrExampleIDs);
        if (lineNumberMatcher.find()) {
            String string = scriptPath + ":" + lineNumberMatcher.group(0);
            if (string == null) {
                RSpecRunCommandLineState.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (exampleIDsMatcher.find()) {
            String string = scriptPath + exampleIDsMatcher.group(0);
            if (string == null) {
                RSpecRunCommandLineState.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = scriptPath;
        if (string == null) {
            RSpecRunCommandLineState.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private String determineRSpecRunnerScriptPath(Module module) {
        String rspecScriptPath;
        RSpecRunConfiguration config = this.getConfig();
        if (config.shouldUseCustomSpecRunner()) {
            rspecScriptPath = config.getCustomSpecsRunnerPath();
        } else {
            Sdk alternativeSdk = config.getAlternativeSdk();
            rspecScriptPath = RSpecUtil.determinePreferredSpecExecutablePath(module, (Sdk)(config.shouldUseAlternativeSdk() ? alternativeSdk : null), config.getRunnerGemVersion());
        }
        return rspecScriptPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerParamsGroup";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rspecRunnerScriptPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecRunCommandLineState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecRunCommandLineState";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestScriptPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addExamples";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMaskParam";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFormatter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRspec1Runner";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureTestFrameworkSupport";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTestScriptPath";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

