/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.testing.RubyTestFrameworkDetector;
import org.jetbrains.plugins.ruby.testing.RubyTestFrameworksUtil;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfiguration;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfigurationType;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecScriptTestsConfigurationProducer;

public final class RSpecCustomSetOfFilesRunConfigurationProducer
extends LazyRunConfigurationProducer<RSpecRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = RSpecRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            RSpecCustomSetOfFilesRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    public boolean isConfigurationFromContext(@NotNull RSpecRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        if (configuration == null) {
            RSpecCustomSetOfFilesRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RSpecCustomSetOfFilesRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((location = context.getLocation()) == null || !context.containsMultipleSelection()) {
            return false;
        }
        PsiElement[] psiFiles = (PsiElement[])ObjectUtils.chooseNotNull((Object)((PsiElement[])PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.getData(context.getDataContext())), (Object)PsiElement.EMPTY_ARRAY);
        List<VirtualFile> files = RubyTestFrameworksUtil.flattenAllSelectedFiles(psiFiles);
        if (configuration.getTestType() != AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES) {
            return false;
        }
        List paths = ContainerUtil.map(files, file -> file.getPath());
        List<String> pathsFromConf = configuration.getTestScriptsPaths();
        return pathsFromConf.size() == paths.size() && new HashSet(paths).containsAll(pathsFromConf);
    }

    protected boolean setupConfigurationFromContext(@NotNull RSpecRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        String exampleFilter;
        String exampleName;
        Location location;
        if (configuration == null) {
            RSpecCustomSetOfFilesRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            RSpecCustomSetOfFilesRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (sourceElement == null) {
            RSpecCustomSetOfFilesRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((location = context.getLocation()) == null || !context.containsMultipleSelection()) {
            return false;
        }
        Object[] psiFiles = RubyTestFrameworksUtil.getPsiElementArray(context.getDataContext());
        List<VirtualFile> files = RubyTestFrameworksUtil.flattenAllSelectedFiles((PsiElement[])psiFiles, (Condition<? super VirtualFile>)((Condition)file -> RSpecUtil.isFileWithRSpecTestFileName(file)));
        for (VirtualFile file2 : files) {
            Module module;
            Module module2 = module = file2 != null ? ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)location.getProject()) : null;
            if (file2 != null && (module == null || RSpecUtil.isRSpecSupportEnabled(module))) continue;
            return false;
        }
        for (VirtualFile file2 : ContainerUtil.filterIsInstance((Object[])psiFiles, RFile.class)) {
            if (file2 == null || RubyTestFrameworkDetector.detectFrameworkForFile((RFile)file2) != RubyTestFrameworkDetector.Result.MINITEST) continue;
            return false;
        }
        Project project = location.getProject();
        SMTRunnerTestTreeView testTree = (SMTRunnerTestTreeView)context.getDataContext().getData(SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW);
        if (testTree != null) {
            exampleFilter = exampleName = RSpecScriptTestsConfigurationProducer.buildExampleFilterFromTestTree(testTree.getSelectedTest(), project);
        } else {
            exampleName = RSpecScriptTestsConfigurationProducer.determineExampleName(context);
            exampleFilter = RSpecScriptTestsConfigurationProducer.determineExampleFilterString(context);
        }
        return RSpecCustomSetOfFilesRunConfigurationProducer.setupRunConfiguration(project, files, location, configuration, exampleName, exampleFilter);
    }

    private static boolean setupRunConfiguration(@NotNull Project project, @NotNull List<VirtualFile> files, @NotNull Location location, @NotNull RSpecRunConfiguration configuration, @Nullable String exampleOrGroupPresentableName, @Nullable String exampleOrGroupNameFilter) {
        Module module;
        if (project == null) {
            RSpecCustomSetOfFilesRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (files == null) {
            RSpecCustomSetOfFilesRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (location == null) {
            RSpecCustomSetOfFilesRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (configuration == null) {
            RSpecCustomSetOfFilesRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        Module module2 = module = !files.isEmpty() ? ModuleUtilCore.findModuleForFile((VirtualFile)files.get(0), (Project)project) : null;
        if (module == null) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)exampleOrGroupPresentableName)) {
            configuration.setGeneratedName(exampleOrGroupPresentableName);
        } else {
            configuration.setGeneratedName(RubyTestFrameworksUtil.createConfName(files));
        }
        configuration.setModule(module);
        if (StringUtil.isEmptyOrSpaces((String)configuration.getWorkingDirectory())) {
            VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
            configuration.setWorkingDirectory(projectDir != null ? projectDir.getPath() : null);
        }
        configuration.setTestType(AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES);
        configuration.setTestScriptsPaths(ContainerUtil.map(files, file -> file.getPath()));
        RSpecUtil.setCommonRunConfParams(configuration, exampleOrGroupNameFilter, module, location, false);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecCustomSetOfFilesRunConfigurationProducer";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecCustomSetOfFilesRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupRunConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

