/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.refactoring.let;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.AbstractExtractMethodDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.codeFragment.RubyExtractMethodUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RMultiAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RCodeBlockNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyDuplicatesFinder;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyExtractMethodHelperBase;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.refactoring.let.RSpecLetExtractRefactoringHandler;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RSpecLetExtractHelper
extends RubyExtractMethodHelperBase {
    private static final Logger LOG = Logger.getInstance(RSpecLetExtractHelper.class);
    private static final String UNDEFINED_VARIABLE_NAME = "name";
    @NonNls
    private static final String LET_NAME_VARIABLE = "LET_NAME_VARIABLE";
    @NonNls
    private static final String CALL_VARIABLE_NAME = "CALL_VARIABLE_NAME";
    @NonNls
    private static final String REFERENCE_VARIABLE_NAME = "REFERENCE_VARIABLE_NAME";
    public static final RSpecLetExtractHelper HELPER = new RSpecLetExtractHelper();

    private RSpecLetExtractHelper() {
    }

    @Override
    protected void handleExtractFromExpression(Project project, Editor editor, CodeFragment codeFragment, RPsiElement expression) {
        AbstractVariableData[] variableData;
        if (RSpecLetExtractHelper.checkForExpressionOut(project, editor, codeFragment)) {
            return;
        }
        if (RSpecLetExtractHelper.checkForGroupScope(project, editor, expression)) {
            return;
        }
        if (RSpecLetExtractHelper.checkForInputVariables(project, codeFragment)) {
            return;
        }
        List<PsiElement> usages = RSpecLetExtractHelper.getSingleOutputVariableUsages((PsiElement)expression, variableData = RSpecLetExtractHelper.getVariableData(codeFragment));
        PairConsumer<PsiElement, RBlockCall> duplicatesConsumer = RSpecLetExtractHelper.createDuplicatesConsumer(editor, expression, expression, variableData, !usages.isEmpty());
        WriteCommandAction.runWriteCommandAction((Project)project, (String)RSpecLetExtractRefactoringHandler.getRspecDialogTitle(), null, () -> {
            RBraceBlockCall generatedLetBlock = RSpecLetExtractHelper.generateBraceLetFromExpression(project, variableData, expression);
            generatedLetBlock = RSpecLetExtractHelper.insertGeneratedLetBlockCall(Collections.singletonList(expression), (RBlockCall)generatedLetBlock);
            PsiElement callElement = RSpecLetExtractHelper.generateLetCallElement(variableData, expression, project);
            callElement = RefactoringPsiHelper.replaceExpression(project, (PsiElement)expression, callElement);
            RSpecLetExtractHelper.startDefaultNameTemplate(project, editor, (RBlockCall)generatedLetBlock, callElement, usages, (PairConsumer<? super PsiElement, ? super RBlockCall>)duplicatesConsumer);
        }, (PsiFile[])new PsiFile[]{expression.getContainingFile()});
    }

    @Override
    protected void handleExtractFromStatements(Project project, Editor editor, CodeFragment codeFragment, RPsiElement statement1, RPsiElement statement2) {
        List outputVariables = (List)codeFragment.getOutputVariables();
        if (RSpecLetExtractHelper.checkForOutVariables(project, editor, codeFragment, outputVariables)) {
            return;
        }
        if (RSpecLetExtractHelper.checkForGroupScope(project, editor, statement1)) {
            return;
        }
        if (RSpecLetExtractHelper.checkForInputVariables(project, codeFragment)) {
            return;
        }
        AbstractVariableData[] variableData = RSpecLetExtractHelper.getVariableData(codeFragment);
        List<PsiElement> elementsRange = RSpecLetExtractHelper.collectElements((PsiElement)statement1, (PsiElement)statement2);
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)statement1);
        LOG.assertTrue(languageLevel != null, (Object)"Language level is null");
        List<PsiElement> usages = RSpecLetExtractHelper.getSingleOutputVariableUsages(elementsRange.get(0), variableData);
        PairConsumer<PsiElement, RBlockCall> duplicatesConsumer = RSpecLetExtractHelper.createDuplicatesConsumer(editor, statement1, statement2, variableData, !usages.isEmpty());
        WriteCommandAction.runWriteCommandAction((Project)project, (String)RSpecLetExtractRefactoringHandler.getRspecDialogTitle(), null, () -> {
            RBlockCall generatedLetBlock = RSpecLetExtractHelper.generateLetBlockFromElements(project, variableData, elementsRange);
            generatedLetBlock = RSpecLetExtractHelper.insertGeneratedLetBlockCall(elementsRange, generatedLetBlock);
            String variables = RSpecLetExtractHelper.insertReturnStatement(project, codeFragment, outputVariables, languageLevel, generatedLetBlock);
            PsiElement callElement = RSpecLetExtractHelper.insertCallElement(project, variableData, elementsRange, languageLevel, variables);
            RSpecLetExtractHelper.startDefaultNameTemplate(project, editor, generatedLetBlock, callElement, usages, (PairConsumer<? super PsiElement, ? super RBlockCall>)duplicatesConsumer);
        }, (PsiFile[])new PsiFile[]{statement1.getContainingFile()});
    }

    @NotNull
    private static List<PsiElement> getSingleOutputVariableUsages(@NotNull PsiElement anchor, AbstractVariableData @NotNull [] variableData) {
        if (anchor == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(0);
        }
        if (variableData == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(1);
        }
        if (variableData.length != 1) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                RSpecLetExtractHelper.$$$reportNull$$$0(2);
            }
            return list;
        }
        String variableName = variableData[0].getName();
        Collection<PsiElement> variables = ScopeUtil.collectLocalVariables(anchor);
        List<PsiNamedElement> elementList = variables.stream().mapMulti(StreamUtil.select(PsiNamedElement.class, (Class[])new Class[0])).filter(identifier -> variableName.equals(identifier.getName())).toList();
        if (elementList.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                RSpecLetExtractHelper.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiElement element = (PsiElement)elementList.iterator().next();
        List list = ContainerUtil.map((Collection)ReferencesSearch.search((PsiElement)element).findAll(), PsiReference::getElement);
        if (list == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static PairConsumer<PsiElement, RBlockCall> createDuplicatesConsumer(@NotNull Editor editor, @NotNull RPsiElement statement1, @NotNull RPsiElement statement2, AbstractVariableData @NotNull [] variableData, boolean hasUsages) {
        if (editor == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(5);
        }
        if (statement1 == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(6);
        }
        if (statement2 == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(7);
        }
        if (variableData == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(8);
        }
        Collection<String> outputVariables = RSpecLetExtractHelper.createOutputVariables(variableData);
        Collection<PsiElement> variables = ScopeUtil.collectLocalVariables((PsiElement)statement2);
        List<String> names = variables.stream().mapMulti(StreamUtil.select(NavigationItem.class, (Class[])new Class[0])).map(NavigationItem::getName).toList();
        AbstractVariableData[] localVariables = AbstractExtractMethodDialog.createVariableDataByNames(names);
        RSpecLetDuplicatesFinder duplicatesFinder = new RSpecLetDuplicatesFinder(statement1.getContainingFile(), statement1, statement2, localVariables, outputVariables);
        RBlockCall example = RSpecUtil.getSimpleCoveringExampleOrBeforeAfterScope((PsiElement)statement1);
        RPossibleCall groupBlock = RSpecLetExtractHelper.getCoveringGroupBlock((PsiElement)statement1);
        if (groupBlock == null) {
            PairConsumer pairConsumer = (exampleScope, group) -> {};
            if (pairConsumer == null) {
                RSpecLetExtractHelper.$$$reportNull$$$0(9);
            }
            return pairConsumer;
        }
        Project project = groupBlock.getProject();
        SmartPsiElementPointer scopePointer = null;
        if (example != null) {
            scopePointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)example);
        }
        SmartPsiElementPointer groupPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)groupBlock);
        SmartPsiElementPointer finalScopePointer = scopePointer;
        PairConsumer pairConsumer = (call, generatedLet) -> {
            RPossibleCall scopePointerElement = null;
            if (finalScopePointer != null) {
                scopePointerElement = (RPossibleCall)finalScopePointer.getElement();
                SmartPointerManager.getInstance((Project)project).removePointer(finalScopePointer);
            }
            RPossibleCall groupPointerElement = (RPossibleCall)groupPointer.getElement();
            SmartPointerManager.getInstance((Project)project).removePointer(groupPointer);
            MultiMap callsAccumulator = new MultiMap();
            RSpecLetExtractHelper.processDuplicates(call, generatedLet, duplicatesFinder, editor, scopePointerElement, groupPointerElement, (MultiMap<RPossibleCall, SmartPsiElementPointer>)callsAccumulator);
            CommandProcessor.getInstance().executeCommand(project, () -> RSpecLetExtractHelper.deleteUnnecessaryCalls(editor, call, hasUsages, (MultiMap<RPossibleCall, SmartPsiElementPointer>)callsAccumulator), RBundle.message((String)"rspec.refactoring.extract.delete.unnecessary.let.calls.command.name"), null);
        };
        if (pairConsumer == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(10);
        }
        return pairConsumer;
    }

    private static void deleteUnnecessaryCalls(@NotNull Editor editor, @NotNull PsiElement call, boolean hasUsages, @NotNull MultiMap<RPossibleCall, SmartPsiElementPointer> callsAccumulator) {
        if (editor == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(11);
        }
        if (call == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(12);
        }
        if (callsAccumulator == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(13);
        }
        SmartList callsToDelete = new SmartList();
        if (RSpecLetExtractHelper.isBetweenExamples(call)) {
            callsToDelete.add(SmartPointerManager.getInstance((Project)call.getProject()).createSmartPsiElementPointer(call));
        } else {
            if (hasUsages) {
                callsToDelete.add(SmartPointerManager.getInstance((Project)call.getProject()).createSmartPsiElementPointer(call));
            }
            for (RPossibleCall example : callsAccumulator.keySet()) {
                Collection calls = callsAccumulator.get((Object)example);
                if (calls.size() <= 1) continue;
                for (SmartPsiElementPointer referenceElementPointer : calls) {
                    RCodeBlock blockCall;
                    PsiElement compoundStatement;
                    PsiElement referenceElement = referenceElementPointer.getElement();
                    if (referenceElement == null || !((compoundStatement = referenceElement.getParent()) instanceof RCompoundStatement) || (blockCall = RCodeBlockNavigator.getByBlockCmsSt((RCompoundStatement)((RCompoundStatement)compoundStatement))) == null || blockCall.getParent() != example) continue;
                    callsToDelete.add(referenceElementPointer);
                }
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> RSpecLetExtractHelper.lambda$deleteUnnecessaryCalls$7((List)callsToDelete, editor));
    }

    @NotNull
    private static Collection<String> createOutputVariables(AbstractVariableData @NotNull [] data) {
        if (data == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(14);
        }
        List list = ContainerUtil.map((Object[])data, AbstractVariableData::getName);
        if (list == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private static PsiElement insertCallElement(@NotNull Project project, AbstractVariableData @NotNull [] variableData, @NotNull List<? extends PsiElement> elementsRange, @NotNull LanguageLevel languageLevel, @Nullable String variables) {
        if (project == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(16);
        }
        if (elementsRange == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(17);
        }
        if (languageLevel == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(18);
        }
        if (variableData == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(19);
        }
        String text4Call = RSpecLetExtractHelper.createLetVariableCall(variableData, variables);
        RPsiElement callElement = RubyElementFactoryCore.createElementFromText((Project)project, (String)text4Call, (LanguageLevel)languageLevel);
        PsiElement psiElement = RSpecLetExtractHelper.replaceElements(elementsRange, (PsiElement)callElement);
        if (psiElement == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(20);
        }
        return psiElement;
    }

    private static void deleteElementsRange(@NotNull List<? extends PsiElement> elementsRange) {
        if (elementsRange == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(21);
        }
        if (elementsRange.isEmpty()) {
            return;
        }
        PsiElement firstElement = elementsRange.get(0);
        RBlockCall block = RSpecUtil.getSimpleCoveringExampleOrBeforeAfterScope(firstElement);
        if (block == null) {
            block = RSpecLetExtractHelper.getCoveringGroupBlock(firstElement);
        }
        PsiElement element2 = elementsRange.get(elementsRange.size() - 1);
        PsiElement element1 = firstElement;
        PsiElement nextSibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)element2);
        if (RubySpaceUtil.isEol((PsiElement)nextSibling)) {
            element2 = nextSibling;
        } else {
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element1);
            if (RubySpaceUtil.isEol((PsiElement)prevSibling)) {
                element1 = prevSibling;
            }
        }
        PsiElement parent = element1.getParent();
        parent.deleteChildRange(element1, element2);
        if (block != null) {
            CodeStyleManager.getInstance((Project)element1.getProject()).reformatText(block.getContainingFile(), block.getTextRange().getStartOffset(), block.getTextRange().getEndOffset());
        }
    }

    private static void startDefaultNameTemplate(@NotNull Project project, @NotNull Editor editor, @NotNull RBlockCall generatedLetBlock, @NotNull PsiElement callElement, @NotNull List<? extends PsiElement> references, @NotNull PairConsumer<? super PsiElement, ? super RBlockCall> duplicatesConsumer) {
        if (project == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(22);
        }
        if (editor == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(23);
        }
        if (generatedLetBlock == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(24);
        }
        if (callElement == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(25);
        }
        if (references == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(26);
        }
        if (duplicatesConsumer == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(27);
        }
        SmartPsiElementPointer generatedLetBlockPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)generatedLetBlock);
        if ((callElement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)callElement)) == null) {
            LOG.warn("Failed to locate the let call after PSI postprocessing.");
            return;
        }
        generatedLetBlock = (RBlockCall)generatedLetBlockPointer.getElement();
        if (generatedLetBlock == null) {
            LOG.warn("Failed to locate the let block after PSI postprocessing.");
            return;
        }
        if (callElement instanceof RMultiAssignmentExpression) {
            callElement = ((RMultiAssignmentExpression)callElement).getValue();
        }
        if (callElement == null) {
            LOG.error("MultiAssignment expression value is null.");
            return;
        }
        RPossibleCall scope = RSpecLetExtractHelper.getCoveringGroupBlock((PsiElement)generatedLetBlock);
        if (scope == null) {
            LOG.error("Example covering block hasn't found; let block: " + generatedLetBlock.getText());
            return;
        }
        TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)scope);
        RPossibleCall call = generatedLetBlock.getCall();
        if (!(call instanceof RCall)) {
            return;
        }
        List arguments = call.getArguments();
        if (arguments.isEmpty()) {
            return;
        }
        RPsiElement letNameElement = (RPsiElement)arguments.get(0);
        TemplateBuilderImpl builder2 = (TemplateBuilderImpl)templateBuilder;
        builder2.replaceElement((PsiElement)letNameElement, TextRange.from((int)1, (int)(letNameElement.getTextLength() - 1)), LET_NAME_VARIABLE, (Expression)new ConstantNode(callElement.getText()), true);
        builder2.replaceElement(callElement, CALL_VARIABLE_NAME, LET_NAME_VARIABLE, false);
        references.forEach(element -> {
            if (element.isValid()) {
                builder2.replaceElement(element, REFERENCE_VARIABLE_NAME, LET_NAME_VARIABLE, false);
            }
        });
        CaretModel model = editor.getCaretModel();
        model.moveToOffset(scope.getTextRange().getStartOffset());
        Template inlineTemplate = builder2.buildInlineTemplate();
        TemplateManager.getInstance((Project)project).startTemplate(editor, inlineTemplate, (TemplateEditingListener)new DuplicatesTemplateEditingAdapter(editor, duplicatesConsumer));
    }

    private static boolean checkForExpressionOut(Project project, Editor editor, CodeFragment codeFragment) {
        if (codeFragment.getOutputVariables().isEmpty()) {
            return false;
        }
        String message = RBundle.message((String)(codeFragment.isReturnInstructionInside() ? "refactoring.extract.method.error.cannot.perform.refactoring.with.return.statement.inside.and.not.empty.output.variables" : "refactoring.extract.method.error.cannot.perform.refactoring.from.expression.with.not.empty.output.variables"));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RSpecLetExtractRefactoringHandler.getRspecDialogTitle(), (String)"refactoring.extractRSpecLet");
        return true;
    }

    private static boolean checkForInputVariables(Project project, CodeFragment codeFragment) {
        Collection variables = codeFragment.getInputVariables();
        if (variables.isEmpty()) {
            return false;
        }
        String inputVariables = StringUtil.join((Collection)variables, (String)", ");
        CommonRefactoringUtil.showErrorHint((Project)project, null, (String)RBundle.message((String)(variables.size() == 1 ? "rspec.refactoring.extract.let.error.cannot.perform.refactoring.with.input.variable" : "rspec.refactoring.extract.let.error.cannot.perform.refactoring.with.input.variables"), (Object[])new Object[]{inputVariables}), (String)RSpecLetExtractRefactoringHandler.getRspecDialogTitle(), (String)"refactoring.extractRSpecLet");
        return true;
    }

    private static boolean checkForOutVariables(Project project, Editor editor, CodeFragment codeFragment, List<String> outputVariables) {
        if (outputVariables.isEmpty() || !codeFragment.isReturnInstructionInside()) {
            return false;
        }
        String message = RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.with.return.statement.inside.and.not.empty.output.variables");
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RSpecLetExtractRefactoringHandler.getRspecDialogTitle(), (String)"refactoring.extractRSpecLet");
        return true;
    }

    private static boolean checkForGroupScope(Project project, Editor editor, RPsiElement statement1) {
        RPossibleCall contextContainer = RSpecLetExtractHelper.getCoveringGroupBlock((PsiElement)statement1);
        if (contextContainer != null) {
            return false;
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"rspec.refactoring.extract.let.error.cannot.perform.refactoring.with.not.in.example.scope"), (String)RSpecLetExtractRefactoringHandler.getRspecDialogTitle(), (String)"refactoring.extractRSpecLet");
        return true;
    }

    @Nullable
    private static String insertReturnStatement(Project project, CodeFragment codeFragment, List<String> outputVariables, LanguageLevel languageLevel, RBlockCall generatedLetBlock) {
        String variablesToReturn = null;
        if (!outputVariables.isEmpty()) {
            LOG.assertTrue(!codeFragment.isReturnInstructionInside(), (Object)"Cannot perform refactoring with 'return' statement inside.");
            if (outputVariables.size() != 1 || !StringUtil.equals((CharSequence)RSpecLetExtractHelper.getLastReturnName(project, generatedLetBlock), (CharSequence)outputVariables.get(0))) {
                StringBuilder builder2 = new StringBuilder();
                for (String outputVariable : outputVariables) {
                    if (!builder2.isEmpty()) {
                        builder2.append(",");
                    }
                    builder2.append(outputVariable);
                }
                if (outputVariables.size() > 1) {
                    variablesToReturn = builder2.toString();
                    builder2.insert(0, "return ");
                }
                RPsiElement returnStatement = RubyElementFactoryCore.createElementFromText((Project)project, (String)builder2.toString(), (LanguageLevel)languageLevel);
                generatedLetBlock.getBlock().getCompoundStatement().add((PsiElement)returnStatement);
            }
        }
        return variablesToReturn;
    }

    @Nullable
    public static String getLastReturnName(Project project, RBlockCall letBlock) {
        RubyExpressionCodeFragment fragment = RubyElementFactory.createExpressionCodeFragment(project, letBlock.getBlock().getText(), (PsiElement)letBlock, false);
        return ScopeUtil.getLastReturnName((ScopeHolder)fragment);
    }

    @NotNull
    private static PsiElement generateLetCallElement(AbstractVariableData[] data, RPsiElement expression, Project project) {
        String text4Call = RSpecLetExtractHelper.createSingleOutputVariable(data);
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)expression);
        LOG.assertTrue(languageLevel != null, (Object)("Language level cannot be null for: " + expression.getText()));
        RPsiElement rPsiElement = RubyElementFactoryCore.createElementFromText((Project)project, (String)text4Call, (LanguageLevel)languageLevel);
        if (rPsiElement == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(28);
        }
        return rPsiElement;
    }

    @NotNull
    private static RBraceBlockCall generateBraceLetFromExpression(Project project, AbstractVariableData[] variableData, RPsiElement expression) {
        String methodText = RSpecLetExtractHelper.generateLetSignature((PsiElement)expression, variableData) + "{" + expression.getText() + "}";
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)expression);
        LOG.assertTrue(languageLevel != null, (Object)("Language level cannot be null for: " + expression.getText()));
        RBraceBlockCall braceLet = (RBraceBlockCall)RubyElementFactoryCore.createElementFromText((Project)project, (String)methodText, (LanguageLevel)languageLevel);
        RubyPsiUtil.markGenerated((PsiElement)braceLet);
        RBraceBlockCall rBraceBlockCall = braceLet;
        if (rBraceBlockCall == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(29);
        }
        return rBraceBlockCall;
    }

    @NotNull
    private static RBlockCall insertGeneratedLetBlockCall(List<? extends PsiElement> elementsRange, RBlockCall generatedLet) {
        RPossibleCall coveringCodeBlockScope;
        PsiElement anchor = elementsRange.get(0);
        Pair data = (Pair)anchor.getUserData(RubyPsiUtil.SELECTION_BREAKS_AST_NODE);
        if (data != null) {
            anchor = (PsiElement)data.first;
        }
        if ((coveringCodeBlockScope = RSpecLetExtractHelper.getCoveringGroupBlock(anchor)) instanceof RBlockCall) {
            List statements = ((RBlockCall)coveringCodeBlockScope).getBlock().getCompoundStatement().getStatements();
            PsiElement element2AddBefore = statements.isEmpty() ? anchor : (PsiElement)statements.get(0);
            boolean needInsertNewLine = !RSpecLetExtractHelper.isBetweenExamples(anchor) || statements.get(0) != elementsRange.get(0);
            RBlockCall newLet = (RBlockCall)element2AddBefore.getParent().addBefore((PsiElement)generatedLet, element2AddBefore);
            if (needInsertNewLine) {
                element2AddBefore.getParent().addBefore(RubyElementFactoryCore.createNewLine((PsiElement)element2AddBefore), element2AddBefore);
            }
            RBlockCall rBlockCall = newLet;
            if (rBlockCall == null) {
                RSpecLetExtractHelper.$$$reportNull$$$0(30);
            }
            return rBlockCall;
        }
        RBlockCall contextContainer = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)anchor, RBlockCall.class);
        LOG.assertTrue(contextContainer != null, (Object)"It seems element is out of example group scope.");
        RPsiElement statement = RubyPsiUtilCore.getStatement((RCompoundStatement)contextContainer.getBlock().getCompoundStatement(), (PsiElement)anchor);
        assert (statement != null);
        RBlockCall rBlockCall = (RBlockCall)statement.getParent().addAfter((PsiElement)generatedLet, (PsiElement)statement);
        if (rBlockCall == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(31);
        }
        return rBlockCall;
    }

    private static boolean isBetweenExamples(PsiElement anchor) {
        return RSpecUtil.getSimpleCoveringExampleOrBeforeAfterScope(anchor) == null && RSpecLetExtractHelper.getCoveringGroupBlock(anchor) != null;
    }

    @Nullable
    static RPossibleCall getCoveringGroupBlock(PsiElement anchor) {
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(anchor, RSpecUtil.CLASS_CONTEXT_CALLS, null);
    }

    private static RBlockCall generateLetBlockFromElements(Project project, AbstractVariableData[] variableData, List<? extends PsiElement> elementsRange) {
        PsiElement first = elementsRange.get(0);
        StringBuilder methodText = new StringBuilder(RSpecLetExtractHelper.generateLetSignature(first, variableData) + "do\n");
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)first);
        for (PsiElement psiElement : elementsRange) {
            methodText.append(psiElement.getText());
        }
        methodText.append("\nend").append("\n");
        LOG.assertTrue(languageLevel != null, (Object)"Language level is null");
        RBlockCall method = (RBlockCall)RubyElementFactoryCore.createElementFromText((Project)project, (String)methodText.toString(), (LanguageLevel)languageLevel);
        RubyPsiUtil.markGenerated((PsiElement)method);
        return method;
    }

    private static String generateLetSignature(@NotNull PsiElement element, AbstractVariableData[] variableData) {
        if (element == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(32);
        }
        String name = RSpecLetExtractHelper.createSingleOutputVariable(variableData);
        RubyCodeStyleSettings settings = RubyCodeStyleSettings.getInstance((PsiElement)element);
        boolean generateParenthesesAroundArguments = settings.PARENTHESES_AROUND_METHOD_ARGUMENTS;
        char open = generateParenthesesAroundArguments ? (char)'(' : ' ';
        char close = generateParenthesesAroundArguments ? (char)')' : ' ';
        return "let" + open + ":" + name + close;
    }

    @NotNull
    private static String createLetVariableCall(AbstractVariableData[] data, String variables) {
        Object object = variables == null ? RSpecLetExtractHelper.createSingleOutputVariable(data) : variables + " = " + RSpecLetExtractHelper.createSingleOutputVariable(data);
        if (object == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(33);
        }
        return object;
    }

    @NotNull
    private static String createSingleOutputVariable(AbstractVariableData[] data) {
        String string = data.length != 1 ? UNDEFINED_VARIABLE_NAME : data[0].getName();
        if (string == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static AbstractVariableData @NotNull [] getVariableData(CodeFragment fragment) {
        Collection outputVariables = fragment.getOutputVariables();
        AbstractVariableData[] abstractVariableDataArray = AbstractExtractMethodDialog.createVariableDataByNames((List)ContainerUtil.collect(outputVariables.iterator()));
        if (abstractVariableDataArray == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(35);
        }
        return abstractVariableDataArray;
    }

    private static void processDuplicates(@NotNull PsiElement callElement, @NotNull RBlockCall generatedLet, @NotNull SimpleDuplicatesFinder finder, @NotNull Editor editor, @Nullable RPossibleCall simpleCoveringExampleOrBeforeAfterScope, @Nullable RPossibleCall parentContainer, @NotNull MultiMap<RPossibleCall, SmartPsiElementPointer> accumulator) {
        if (callElement == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(36);
        }
        if (generatedLet == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(37);
        }
        if (finder == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(38);
        }
        if (editor == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(39);
        }
        if (accumulator == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(40);
        }
        SmartList scope = new SmartList();
        if (parentContainer == null) {
            return;
        }
        if (parentContainer instanceof RBlockCall && simpleCoveringExampleOrBeforeAfterScope instanceof RBlockCall) {
            scope.add(simpleCoveringExampleOrBeforeAfterScope);
            for (RPsiElement example : ((RBlockCall)parentContainer).getBlock().getCompoundStatement().getStatements()) {
                if (example.equals((Object)simpleCoveringExampleOrBeforeAfterScope) || example.equals((Object)generatedLet)) continue;
                scope.add(example);
            }
        }
        finder.setReplacement(callElement);
        List duplicates = ExtractMethodHelper.collectDuplicates((SimpleDuplicatesFinder)finder, (List)scope, (PsiElement)generatedLet);
        ExtractMethodHelper.replaceDuplicates((PsiElement)callElement, (Editor)editor, pair -> RSpecLetExtractHelper.replaceDuplicateElements(generatedLet, (SimpleMatch)pair.first, ((PsiElement)pair.second).copy(), accumulator), (List)duplicates);
    }

    private static void replaceDuplicateElements(@NotNull RBlockCall generatedLet, @NotNull SimpleMatch match, @NotNull PsiElement callElement, @NotNull MultiMap<RPossibleCall, SmartPsiElementPointer> accumulator) {
        List<PsiElement> elementsRange;
        if (generatedLet == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(41);
        }
        if (match == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(42);
        }
        if (callElement == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(43);
        }
        if (accumulator == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(44);
        }
        if ((elementsRange = RSpecLetExtractHelper.collectElements(match.getStartElement(), match.getEndElement())).isEmpty()) {
            return;
        }
        Map changedParameters = match.getChangedParameters();
        PsiElement firstElement = elementsRange.get(0);
        RBlockCall example = RSpecUtil.getSimpleCoveringExampleOrBeforeAfterScope(firstElement);
        if (example == null) {
            return;
        }
        if (changedParameters.size() > 1) {
            Collection patternParameters = changedParameters.values();
            StringBuilder builder2 = new StringBuilder();
            for (String variable : RSpecLetExtractHelper.getCodeFragmentOutputVariables(firstElement, match)) {
                if (!patternParameters.contains(variable)) continue;
                if (!builder2.isEmpty()) {
                    builder2.append(",");
                }
                builder2.append(variable);
            }
            builder2.append(" = ").append(callElement.getText());
            RExpression multipleDuplicateCall = RubyElementFactoryCore.createExpressionFromText((PsiElement)firstElement, (String)builder2.toString());
            RSpecLetExtractHelper.replaceElements(elementsRange, (PsiElement)multipleDuplicateCall);
            return;
        }
        if (changedParameters.size() == 1) {
            RPossibleCall call = generatedLet.getCall();
            if (!(call instanceof RCall)) {
                return;
            }
            List arguments = call.getArguments();
            if (arguments.size() != 1) {
                return;
            }
            RPsiElement letName = (RPsiElement)arguments.get(0);
            String newVariableName = letName instanceof RSymbol ? ((RSymbol)letName).getValue() : letName.getText();
            String changedParameter = (String)changedParameters.values().iterator().next();
            List<? extends PsiElement> changedVariableList = RSpecLetExtractHelper.getVariableUsagesInScope(changedParameter, firstElement);
            if (changedVariableList.isEmpty()) {
                return;
            }
            PsiElement variableToChange = changedVariableList.get(0);
            Query query = ReferencesSearch.search((PsiElement)variableToChange);
            for (PsiReference reference : query.findAll()) {
                PsiElement element = reference.getElement();
                if (element == variableToChange) continue;
                PsiElement newVariableElement = element.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)variableToChange, (String)newVariableName));
                SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)generatedLet.getProject()).createSmartPsiElementPointer(newVariableElement);
                accumulator.putValue((Object)example, (Object)pointer);
            }
        }
        PsiElement replacedCallElement = RSpecLetExtractHelper.replaceElements(elementsRange, callElement);
        SmartPsiElementPointer replacedCallElementPointer = SmartPointerManager.getInstance((Project)generatedLet.getProject()).createSmartPsiElementPointer(replacedCallElement);
        accumulator.putValue((Object)example, (Object)replacedCallElementPointer);
    }

    @NotNull
    private static List<? extends PsiElement> getVariableUsagesInScope(String variableName, PsiElement anchor) {
        List<PsiNamedElement> list = ScopeUtil.collectLocalVariables(anchor).stream().mapMulti(StreamUtil.select(PsiNamedElement.class, (Class[])new Class[0])).filter(element -> variableName.equals(element.getName())).toList();
        if (list == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(45);
        }
        return list;
    }

    @NotNull
    private static Collection<String> getCodeFragmentOutputVariables(@NotNull PsiElement anchor, @NotNull SimpleMatch simpleMatch) {
        ScopeHolder owner;
        if (anchor == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(46);
        }
        if (simpleMatch == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(47);
        }
        if ((owner = ScopeUtilCore.findScopeHolder((PsiElement)anchor)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                RSpecLetExtractHelper.$$$reportNull$$$0(48);
            }
            return list;
        }
        Object fragment = RubyExtractMethodUtil.createCodeFragment(owner, simpleMatch.getStartElement(), simpleMatch.getEndElement());
        if (!(fragment instanceof CodeFragment)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                RSpecLetExtractHelper.$$$reportNull$$$0(49);
            }
            return list;
        }
        Collection collection = ((CodeFragment)fragment).getOutputVariables();
        if (collection == null) {
            RSpecLetExtractHelper.$$$reportNull$$$0(50);
        }
        return collection;
    }

    private static /* synthetic */ void lambda$deleteUnnecessaryCalls$7(List callsToDelete, Editor editor) {
        for (SmartPsiElementPointer pointer : callsToDelete) {
            PsiElement callToDelete = pointer.getElement();
            if (callToDelete == null) {
                Logger.getInstance(RSpecLetExtractHelper.class).warn("Pointer did not survive " + String.valueOf(pointer));
                continue;
            }
            RSpecLetExtractHelper.deleteElementsRange(Collections.singletonList(callToDelete));
        }
        int reducedCount = callsToDelete.size();
        if (reducedCount > 0) {
            ApplicationManager.getApplication().invokeLater(() -> HintManager.getInstance().showInformationHint(editor, reducedCount == 1 ? RBundle.message((String)"rspec.refactoring.extract.let.reduced.count.message") : RBundle.message((String)"rspec.refactoring.extract.let.reduced.count.plural.message", (Object[])new Object[]{reducedCount})));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 9, 10, 15, 20, 28, 29, 30, 31, 33, 34, 35, 45, 48, 49, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableData";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 45: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/refactoring/let/RSpecLetExtractHelper";
                break;
            }
            case 5: 
            case 11: 
            case 23: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callsAccumulator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsRange";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedLetBlock";
                break;
            }
            case 25: 
            case 36: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicatesConsumer";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedLet";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleMatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/refactoring/let/RSpecLetExtractHelper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleOutputVariableUsages";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDuplicatesConsumer";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputVariables";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "insertCallElement";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLetCallElement";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "generateBraceLetFromExpression";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "insertGeneratedLetBlockCall";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createLetVariableCall";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingleOutputVariable";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableData";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableUsagesInScope";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragmentOutputVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSingleOutputVariableUsages";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 45: 
            case 48: 
            case 49: 
            case 50: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDuplicatesConsumer";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteUnnecessaryCalls";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createOutputVariables";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "insertCallElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "deleteElementsRange";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "startDefaultNameTemplate";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "generateLetSignature";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicates";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "replaceDuplicateElements";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCodeFragmentOutputVariables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 9, 10, 15, 20, 28, 29, 30, 31, 33, 34, 35, 45, 48, 49, 50 -> new IllegalStateException(string);
        };
    }

    private static class RSpecLetDuplicatesFinder
    extends RubyDuplicatesFinder {
        @NotNull
        private final Collection<String> myOutputVariables;

        RSpecLetDuplicatesFinder(@NotNull PsiFile file, @NotNull RPsiElement statement1, @NotNull RPsiElement statement2, AbstractVariableData @NotNull [] data, @NotNull Collection<String> outputVariables) {
            if (file == null) {
                RSpecLetDuplicatesFinder.$$$reportNull$$$0(0);
            }
            if (statement1 == null) {
                RSpecLetDuplicatesFinder.$$$reportNull$$$0(1);
            }
            if (statement2 == null) {
                RSpecLetDuplicatesFinder.$$$reportNull$$$0(2);
            }
            if (outputVariables == null) {
                RSpecLetDuplicatesFinder.$$$reportNull$$$0(3);
            }
            if (data == null) {
                RSpecLetDuplicatesFinder.$$$reportNull$$$0(4);
            }
            super(file, (PsiElement)statement1, (PsiElement)statement2, outputVariables, data);
            this.myOutputVariables = outputVariables;
        }

        @Override
        @Nullable
        protected SimpleMatch isDuplicateFragment(@NotNull PsiElement candidate) {
            SimpleMatch simpleMatch;
            if (candidate == null) {
                RSpecLetDuplicatesFinder.$$$reportNull$$$0(5);
            }
            if ((simpleMatch = super.isDuplicateFragment(candidate)) == null) {
                return null;
            }
            Set outputVariablesPattern = ContainerUtil.map2SetNotNull(this.myOutputVariables, outputVariable -> (String)simpleMatch.getChangedParameters().get(outputVariable));
            Collection<String> outputVariablesCandidate = RSpecLetExtractHelper.getCodeFragmentOutputVariables(candidate, simpleMatch);
            if (ContainerUtil.compareLexicographically((List)ContainerUtil.sorted((Collection)outputVariablesPattern), (List)ContainerUtil.sorted(outputVariablesCandidate)) != 0) {
                return null;
            }
            return simpleMatch;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputVariables";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidate";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/refactoring/let/RSpecLetExtractHelper$RSpecLetDuplicatesFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDuplicateFragment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DuplicatesTemplateEditingAdapter
    extends TemplateEditingAdapter {
        private final PairConsumer<? super PsiElement, ? super RBlockCall> myDuplicatesConsumer;
        private final Editor myEditor;
        private int myLetBlockArgumentOffset;
        private int myCallElementOffset;

        DuplicatesTemplateEditingAdapter(@NotNull Editor editor, @NotNull PairConsumer<? super PsiElement, ? super RBlockCall> duplicatesConsumer) {
            if (editor == null) {
                DuplicatesTemplateEditingAdapter.$$$reportNull$$$0(0);
            }
            if (duplicatesConsumer == null) {
                DuplicatesTemplateEditingAdapter.$$$reportNull$$$0(1);
            }
            this.myDuplicatesConsumer = duplicatesConsumer;
            this.myEditor = editor;
        }

        public void currentVariableChanged(@NotNull TemplateState templateState, Template template, int oldIndex, int newIndex) {
            TextRange letRange;
            if (templateState == null) {
                DuplicatesTemplateEditingAdapter.$$$reportNull$$$0(2);
            }
            this.myLetBlockArgumentOffset = (letRange = templateState.getVariableRange(RSpecLetExtractHelper.LET_NAME_VARIABLE)) == null ? -1 : letRange.getStartOffset();
            TextRange callRange = templateState.getVariableRange(RSpecLetExtractHelper.CALL_VARIABLE_NAME);
            this.myCallElementOffset = callRange == null ? -1 : callRange.getStartOffset();
        }

        public void templateFinished(@NotNull Template template, boolean brokenOff) {
            Project project;
            if (template == null) {
                DuplicatesTemplateEditingAdapter.$$$reportNull$$$0(3);
            }
            LOG.assertTrue((project = this.myEditor.getProject()) != null, (Object)"Editor project is null.");
            PsiFile containingFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.myEditor.getDocument());
            if (containingFile == null) {
                return;
            }
            PsiElement callElement = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)containingFile, (int)this.myCallElementOffset, RIdentifier.class, (boolean)false);
            RBlockCall generatedLet = (RBlockCall)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)containingFile, (int)this.myLetBlockArgumentOffset, RBlockCall.class, (boolean)false);
            if (generatedLet == null || callElement == null) {
                return;
            }
            Runnable runnable = () -> this.myDuplicatesConsumer.consume((Object)callElement, (Object)generatedLet);
            Application application = ApplicationManager.getApplication();
            if (application.isHeadlessEnvironment()) {
                runnable.run();
            } else {
                application.invokeLater(runnable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicatesConsumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/refactoring/let/RSpecLetExtractHelper$DuplicatesTemplateEditingAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "currentVariableChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "templateFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

