/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.symbols.fqn.RubyFactoryBotFqns;
import org.jetbrains.plugins.ruby.factoryGirl.codeInsight.symbols.fqn.RubyFactoryGirlFqns;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.HelperSymbol;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecMockingUtil;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecSymbolProvider;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols.RSpecExampleGroupContextSymbol;

public final class RSpecExampleGroupUtil {
    public static final String HELPER_GROUP = "helper";
    public static final String MODEL_GROUP = "model";
    public static final Map<String, String> RAILS_1x_EXAMPLE_GROUP_TYPES = new HashMap<String, String>();
    public static final Map<String, String> RAILS_2x_EXAMPLE_GROUP_TYPES = new HashMap<String, String>();
    private static final String DEFAULT_RSPEC_EXAMPLE_GROUP_CLASS_FQN_API_1x = "Spec::Example::ExampleGroup";
    private static final String RSPEC_RAILS_2x_SETUP_AND_TEARDOWN_ADAPTER_FQN = "RSpec::Rails::SetupAndTeardownAdapter";
    private static final String RSPEC_RAILS_2x_TUNIT_ASSERTIONS_ADAPTER_FQN = "RSpec::Rails::TestUnitAssertionAdapter";
    private static final String RPSEC_RAILS_2x_RSPEC_RAILS_MATCHERS = "RSpec::Rails::Matchers";
    private static final String TUNIT_ASSERTIONS_MODULE_FQN = "Test::Unit::Assertions";
    private static final FQN ACTIVERECORD_TESTCASE = FQN.Builder.fromString((String)"ActiveRecord::TestCase");
    private static final FQN ACTIVESUPPORT_TESTCASE = FQN.Builder.fromString((String)"ActiveSupport::TestCase");
    private static final FQN ACTION_VIEW_HELPERS = FQN.Builder.fromString((String)"ActionView::Helpers");
    static final Set<String> STATIC_MATCHERS = Set.of("be_nil", "be_false", "be_true", "be_arbitrary_predicate", "be_instance_of", "be_an_instance_of");
    public static final String HELPER_1x_EXAMPLE_GROUP = "HelperExampleGroup";
    public static final String HELPER_2x_EXAMPLE_GROUP_MODULE = "HelperExampleGroup";

    private RSpecExampleGroupUtil() {
    }

    @Nullable
    static RPsiElement findSubjectCall(RCall call) {
        RBlockCall exampleBlock = RSpecUtil.getSimpleCoveringExampleOrBeforeAfterScope((PsiElement)call);
        if (exampleBlock != null) {
            RBlockCall coveringExampleGroup = RSpecUtil.getSimpleCoveringExampleGroupScope((PsiElement)exampleBlock);
            while (coveringExampleGroup != null) {
                RPsiElement subject = RSpecExampleGroupUtil.findSubjectCallInGroup(coveringExampleGroup);
                if (subject != null) {
                    return subject;
                }
                coveringExampleGroup = RSpecUtil.getSimpleCoveringExampleGroupScope((PsiElement)coveringExampleGroup);
            }
        }
        return null;
    }

    @Nullable
    private static RPsiElement findSubjectCallInGroup(RBlockCall group) {
        RCompoundStatement statement = group.getBlock().getCompoundStatement();
        for (RPsiElement element : statement.getStatements()) {
            if (!(element instanceof RPossibleCall) || !RSpecUtil.SUBJECT_CALL_NAMES.contains(((RPossibleCall)element).getCommand())) continue;
            return element instanceof RBlockCall ? ((RBlockCall)element).getCall() : element;
        }
        return null;
    }

    @Nullable
    private static Symbol getRSpec13xRailsModelExamplesGroupImplicitSuperClass(@NotNull RClass modelGroupPsiClass) {
        if (modelGroupPsiClass == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(0);
        }
        Project project = modelGroupPsiClass.getProject();
        FQN superClassValue = modelGroupPsiClass.getSuperClassFQN();
        if (superClassValue != null && FQN.same((FQN)superClassValue, (String)"base")) {
            Symbol activeRecordTestCase = SymbolUtil.findConstantByFQN(project, Type.CLASS, ACTIVERECORD_TESTCASE, null);
            if (activeRecordTestCase != null) {
                return activeRecordTestCase;
            }
            Symbol activeSupportTestCase = SymbolUtil.findConstantByFQN(project, Type.CLASS, ACTIVESUPPORT_TESTCASE, null);
            if (activeSupportTestCase != null) {
                return activeSupportTestCase;
            }
        }
        return null;
    }

    @Nullable
    public static RSpecExampleGroupContextSymbol createDefaultExampleGroupContext(Project project, @Nullable RContainer container) {
        RSpecExampleGroupContextSymbol contextRspec2 = RSpecExampleGroupUtil.createDefaultExampleGroupContext_RSpec2x(project, null, container, Collections.emptyList());
        if (contextRspec2 != null) {
            return contextRspec2;
        }
        FQN fqn = FQN.of((String)DEFAULT_RSPEC_EXAMPLE_GROUP_CLASS_FQN_API_1x);
        RContainer originalContainer = RubyFQNUtil.findContainerByFQN(project, Type.CLASS.asSet(), fqn, null);
        if (originalContainer == null) {
            return null;
        }
        return RSpecExampleGroupUtil.createDefaultExampleGroupContext_RSpec1x(project, originalContainer, container, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Nullable
    public static Symbol getDefaultExampleGroupBaseClass_RSpec2x(Project project) {
        return SymbolUtil.findConstantByFQN(project, Type.CLASS, RSpecSymbolProvider.DEFAULT_RSPEC_EXAMPLE_GROUP_CLASS_FQN, null);
    }

    @Nullable
    public static RSpecExampleGroupContextSymbol getRailsExampleGroupByType(String type, @NotNull RailsApp railsApp, @Nullable RBlockCall exampleGroup, @Nullable RContainer container) {
        Project project;
        boolean rspec20SupportLoaded;
        Map<String, String> group2TypesMapping;
        String fqnPath;
        if (railsApp == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(1);
        }
        if ((fqnPath = (group2TypesMapping = (rspec20SupportLoaded = RSpecUtil.isRSpec20SupportLoaded(project = railsApp.getProject())) ? RAILS_2x_EXAMPLE_GROUP_TYPES : RAILS_1x_EXAMPLE_GROUP_TYPES).get(type)) != null) {
            if (rspec20SupportLoaded) {
                RSpecExampleGroupContextSymbol contextSymbol;
                ArrayList<Symbol> implicitIncludes = new ArrayList<Symbol>();
                ContainerUtil.addIfNotNull(implicitIncludes, (Object)RSpecExampleGroupUtil.findModuleByFqn(project, fqnPath));
                if (HELPER_GROUP.equals(type)) {
                    implicitIncludes.addAll(RSpecExampleGroupUtil.gatherModulesIncludedInHelperGroup(project, exampleGroup));
                }
                if (RSpecUtil.isRailsRSpec36plusGemAttached(railsApp.getModule())) {
                    ContainerUtil.addIfNotNull(implicitIncludes, (Object)RSpecExampleGroupUtil.findModuleByFqn(project, RPSEC_RAILS_2x_RSPEC_RAILS_MATCHERS));
                }
                if ((contextSymbol = RSpecExampleGroupUtil.createRailsDefaultExampleGroupContext_RSpec2x(project, type, container, implicitIncludes)) != null) {
                    return contextSymbol;
                }
            } else {
                RContainer groupBaseClass = RubyFQNUtil.findContainerByFQN(project, Type.CLASS.asSet(), FQN.of((String)fqnPath), null);
                if (groupBaseClass != null) {
                    Symbol superClass;
                    ArrayList<Symbol> implicitIncludes = new ArrayList<Symbol>();
                    ArrayList<Symbol> implicitSuperclasses = new ArrayList<Symbol>();
                    if (HELPER_GROUP.equals(type)) {
                        implicitIncludes.addAll(RSpecExampleGroupUtil.gatherModulesIncludedInHelperGroup(project, exampleGroup));
                    } else if (MODEL_GROUP.equals(type) && (superClass = RSpecExampleGroupUtil.getRSpec13xRailsModelExamplesGroupImplicitSuperClass((RClass)groupBaseClass)) != null) {
                        implicitSuperclasses.add(superClass);
                    }
                    return RSpecExampleGroupUtil.createDefaultExampleGroupContext_RSpec1x(project, groupBaseClass, container, implicitIncludes, Collections.emptyList(), implicitSuperclasses);
                }
            }
        }
        return RSpecExampleGroupUtil.createRailsDefaultExampleGroupContext(project, container);
    }

    @Nullable
    public static RSpecExampleGroupContextSymbol createRailsDefaultExampleGroupContext(Project project, @Nullable RContainer container) {
        if (RSpecUtil.isRSpec20SupportLoaded(project)) {
            return RSpecExampleGroupUtil.createRailsDefaultExampleGroupContext_RSpec2x(project, null, container, Collections.emptyList());
        }
        return RSpecExampleGroupUtil.createRailsDefaultExampleGroupContext_RSpec1x(project, container);
    }

    @Nullable
    private static RSpecExampleGroupContextSymbol createRailsDefaultExampleGroupContext_RSpec1x(Project project, @Nullable RContainer container) {
        RContainer groupBaseClass = RubyFQNUtil.findContainerByFQN(project, Type.CLASS.asSet(), FQN.of((String)"ActiveSupport::TestCase"), null);
        if (groupBaseClass == null) {
            return null;
        }
        return RSpecExampleGroupUtil.createDefaultExampleGroupContext_RSpec1x(project, groupBaseClass, container, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @NotNull
    private static RSpecExampleGroupContextSymbol createDefaultExampleGroupContext_RSpec1x(@NotNull Project project, @NotNull RContainer originalContainer, @Nullable RContainer container, @NotNull List<Symbol> additionalIncludes, @NotNull List<Symbol> additionalExtends, @NotNull List<Symbol> additionalSuperclasses) {
        if (project == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(2);
        }
        if (originalContainer == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(3);
        }
        if (additionalIncludes == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(4);
        }
        if (additionalExtends == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(5);
        }
        if (additionalSuperclasses == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(6);
        }
        ArrayList<Symbol> implicitIncludes = new ArrayList<Symbol>(additionalIncludes);
        ArrayList<Symbol> implicitExtends = new ArrayList<Symbol>(additionalExtends);
        Symbol matchers1x = SymbolUtil.findConstantByFQN(project, Type.MODULE, RSpecSymbolProvider.RSPEC_1x_MATCHERS_MODULE_FQN, null);
        if (matchers1x != null) {
            implicitIncludes.add(matchers1x);
        }
        ContainerUtil.addIfNotNull(implicitIncludes, (Object)SymbolUtil.findConstantByFQN(project, Type.MODULE, RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS, null));
        ContainerUtil.addIfNotNull(implicitIncludes, (Object)SymbolUtil.findConstantByFQN(project, Type.MODULE, RubyFactoryGirlFqns.FACTORY_GIRL_SYNTAX_METHODS, null));
        Symbol methods = SymbolUtil.findConstantByFQN(project, Type.MODULE, RSpecSymbolProvider.RSPEC_1x_EXAMPLE_GROUP_METHODS_MODULE_FQN, null);
        if (methods != null) {
            implicitExtends.add(methods);
        }
        return new RSpecExampleGroupContextSymbol(originalContainer, null, container, implicitIncludes, implicitExtends, additionalSuperclasses);
    }

    @Nullable
    private static RSpecExampleGroupContextSymbol createRailsDefaultExampleGroupContext_RSpec2x(Project project, @Nullable String groupType, @Nullable RContainer container, @NotNull List<Symbol> additionalIncludes) {
        if (additionalIncludes == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(7);
        }
        ArrayList<Symbol> implicitIncludes = new ArrayList<Symbol>(additionalIncludes);
        ContainerUtil.addIfNotNull(implicitIncludes, (Object)RSpecExampleGroupUtil.findModuleByFqn(project, RSPEC_RAILS_2x_SETUP_AND_TEARDOWN_ADAPTER_FQN));
        ContainerUtil.addIfNotNull(implicitIncludes, (Object)RSpecExampleGroupUtil.findModuleByFqn(project, RSPEC_RAILS_2x_TUNIT_ASSERTIONS_ADAPTER_FQN));
        ContainerUtil.addIfNotNull(implicitIncludes, (Object)RSpecExampleGroupUtil.findModuleByFqn(project, TUNIT_ASSERTIONS_MODULE_FQN));
        return RSpecExampleGroupUtil.createDefaultExampleGroupContext_RSpec2x(project, groupType, container, implicitIncludes);
    }

    @Nullable
    private static RSpecExampleGroupContextSymbol createDefaultExampleGroupContext_RSpec2x(@NotNull Project project, @Nullable String groupType, @Nullable RContainer container, @NotNull List<Symbol> additionalIncludes) {
        Symbol groupBaseClass;
        if (project == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(8);
        }
        if (additionalIncludes == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(9);
        }
        if ((groupBaseClass = RSpecExampleGroupUtil.getDefaultExampleGroupBaseClass_RSpec2x(project)) == null || !(groupBaseClass.getPsiElement() instanceof RContainer)) {
            return null;
        }
        ArrayList<Symbol> implicitIncludes = new ArrayList<Symbol>(additionalIncludes);
        ContainerUtil.addIfNotNull(implicitIncludes, (Object)SymbolUtil.findConstantByFQN(project, Type.MODULE, RSpecSymbolProvider.RSPEC_2x_MATCHERS_MODULE_FQN, null));
        ContainerUtil.addIfNotNull(implicitIncludes, (Object)SymbolUtil.findConstantByFQN(project, Type.MODULE, RSpecSymbolProvider.RSPEC_2x_MOCK_FRAMEWORK_ADAPTER_FQN, null));
        ContainerUtil.addIfNotNull(implicitIncludes, (Object)SymbolUtil.findConstantByFQN(project, Type.MODULE, RubyFactoryBotFqns.FACTORY_BOT_SYNTAX_METHODS, null));
        ContainerUtil.addIfNotNull(implicitIncludes, (Object)SymbolUtil.findConstantByFQN(project, Type.MODULE, RubyFactoryGirlFqns.FACTORY_GIRL_SYNTAX_METHODS, null));
        Module[] modules = RModuleUtil.getInstance().getAllModulesWithRubySupport(project);
        boolean useRspecMocks = true;
        for (Module module : modules) {
            useRspecMocks &= RSpecMockingUtil.isRSpecMockingFrUsed(module);
        }
        if (useRspecMocks) {
            ContainerUtil.addIfNotNull(implicitIncludes, (Object)SymbolUtil.findConstantByFQN(project, Type.MODULE, "RSpec::Mocks::ExampleMethods", null));
        }
        return new RSpecExampleGroupContextSymbol((RContainer)groupBaseClass.getPsiElement(), groupType, container, implicitIncludes, Collections.emptyList(), Collections.emptyList());
    }

    @NotNull
    private static List<Symbol> gatherModulesIncludedInHelperGroup(@NotNull Project project, @Nullable RBlockCall exampleGroup) {
        Symbol helperModuleSymbol;
        String helperModuleFqn;
        if (project == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(10);
        }
        ArrayList<Symbol> modulesToInclude = new ArrayList<Symbol>();
        Symbol actionViewBase = RSpecExampleGroupUtil.findClassByFqn(project, "ActionView::Base");
        if (actionViewBase != null) {
            ClassModuleSymbol base = (ClassModuleSymbol)actionViewBase;
            List<Symbol> includes = base.getIncludeSymbols((PsiElement)exampleGroup);
            for (Symbol include : includes) {
                FQN fqnPath = include.getFQNWithNesting();
                if (!ACTION_VIEW_HELPERS.equals((Object)fqnPath)) continue;
                modulesToInclude.add(include);
            }
        }
        List<Symbol> builtInHelperModules = HelperSymbol.findBuiltInHelperModules(project, (PsiElement)exampleGroup);
        modulesToInclude.addAll(builtInHelperModules);
        Symbol erbUtilsModule = RSpecExampleGroupUtil.findModuleByFqn(project, "ERB::Util");
        if (erbUtilsModule != null) {
            modulesToInclude.add(erbUtilsModule);
        }
        if (exampleGroup != null && (helperModuleFqn = RSpecSymbolProvider.getHelperSpecifiedByHelperNameCall(exampleGroup)) != null && (helperModuleSymbol = RSpecExampleGroupUtil.findModuleByFqn(project, helperModuleFqn)) != null) {
            modulesToInclude.add(helperModuleSymbol);
        }
        ArrayList<Symbol> arrayList = modulesToInclude;
        if (arrayList == null) {
            RSpecExampleGroupUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private static Symbol findModuleByFqn(Project project, String moduleFqnPath) {
        return SymbolUtil.findConstantByFQN(project, Type.MODULE, FQN.Builder.fromString((String)moduleFqnPath), null);
    }

    @Nullable
    private static Symbol findClassByFqn(Project project, String moduleFqnPath) {
        return SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.Builder.fromString((String)moduleFqnPath), null);
    }

    static {
        RAILS_1x_EXAMPLE_GROUP_TYPES.put("controller", "Spec::Rails::Example::ControllerExampleGroup");
        RAILS_1x_EXAMPLE_GROUP_TYPES.put(MODEL_GROUP, "Spec::Rails::Example::ModelExampleGroup");
        RAILS_1x_EXAMPLE_GROUP_TYPES.put(HELPER_GROUP, "Spec::Rails::Example::HelperExampleGroup");
        RAILS_1x_EXAMPLE_GROUP_TYPES.put("view", "Spec::Rails::Example::ViewExampleGroup");
        RAILS_1x_EXAMPLE_GROUP_TYPES.put("integration", "Spec::Rails::Example::IntegrationExampleGroup");
        RAILS_1x_EXAMPLE_GROUP_TYPES.put("routing", "Spec::Rails::Example::RoutingExampleGroup");
        RAILS_2x_EXAMPLE_GROUP_TYPES.put("controller", "RSpec::Rails::ControllerExampleGroup");
        RAILS_2x_EXAMPLE_GROUP_TYPES.put(MODEL_GROUP, "RSpec::Rails::ModelExampleGroup");
        RAILS_2x_EXAMPLE_GROUP_TYPES.put(HELPER_GROUP, "RSpec::Rails::HelperExampleGroup");
        RAILS_2x_EXAMPLE_GROUP_TYPES.put("view", "RSpec::Rails::ViewExampleGroup");
        RAILS_2x_EXAMPLE_GROUP_TYPES.put("request", "RSpec::Rails::RequestExampleGroup");
        RAILS_2x_EXAMPLE_GROUP_TYPES.put("integration", "RSpec::Rails::RequestExampleGroup");
        RAILS_2x_EXAMPLE_GROUP_TYPES.put("mailer", "RSpec::Rails::MailerExampleGroup");
        RAILS_2x_EXAMPLE_GROUP_TYPES.put("routing", "RSpec::Rails::RoutingExampleGroup");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelGroupPsiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsApp";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalContainer";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalIncludes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalExtends";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalSuperclasses";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/symbols/RSpecExampleGroupUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/symbols/RSpecExampleGroupUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "gatherModulesIncludedInHelperGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRSpec13xRailsModelExamplesGroupImplicitSuperClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRailsExampleGroupByType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultExampleGroupContext_RSpec1x";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRailsDefaultExampleGroupContext_RSpec2x";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultExampleGroupContext_RSpec2x";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "gatherModulesIncludedInHelperGroup";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

