/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.codeInsight;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;

public final class RSpecMockingUtil {
    static final String DEFAULT_MOCKING_FRAMEWORK = "rspec";
    static final String RR_MOCKING_FRAMEWORK = "rr";
    static final String MOCHA_MOCKING_FRAMEWORK = "mocha";
    static final String FLEXMOCK_MOCKING_FRAMEWORK = "flexmock";
    static final String[] EXTERNAL_MOCKING_FRAMEWORKS = new String[]{"mocha", "flexmock", "rr"};
    private static final Collection<String> MOCKING_FRAMEWORKS = new HashSet<String>();
    private static final String RSPEC1_MOCKING_PREFIX = "spec/adapters/mock_frameworks/";
    private static final String RSPEC2_MOCKING_PREFIX = "rspec/core/mocking/with_";

    private RSpecMockingUtil() {
    }

    @Nullable
    public static VirtualFile determineUsedMockFrameworkAdapter(@NotNull Module module, @NotNull VirtualFile rspecLibDir) {
        if (module == null) {
            RSpecMockingUtil.$$$reportNull$$$0(0);
        }
        if (rspecLibDir == null) {
            RSpecMockingUtil.$$$reportNull$$$0(1);
        }
        String mockingFramework = RSpecMockingUtil.getEnabledMockingFramework(module);
        boolean rspec2x = RSpecUtil.isRSpec20SupportLoaded(module.getProject());
        return rspecLibDir.findFileByRelativePath(RSpecMockingUtil.getAdapterRelativePath(mockingFramework, rspec2x));
    }

    public static boolean isMockingAdapterDisabled(@NotNull Project project, @NotNull VirtualFile invocationPoint, @NotNull VirtualFile file) {
        String nameWithoutExtension;
        if (project == null) {
            RSpecMockingUtil.$$$reportNull$$$0(2);
        }
        if (invocationPoint == null) {
            RSpecMockingUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            RSpecMockingUtil.$$$reportNull$$$0(4);
        }
        if (!MOCKING_FRAMEWORKS.contains(nameWithoutExtension = file.getNameWithoutExtension())) {
            return false;
        }
        String path = file.getPath();
        if (!path.endsWith(RSpecMockingUtil.getAdapterRelativePath(nameWithoutExtension, true)) && !path.endsWith(RSpecMockingUtil.getAdapterRelativePath(nameWithoutExtension, false))) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)invocationPoint, (Project)project);
        if (module == null) {
            return false;
        }
        String enabledMockingFrameworkName = RSpecMockingUtil.getEnabledMockingFramework(module);
        return !enabledMockingFrameworkName.equals(nameWithoutExtension);
    }

    public static boolean isRSpecMockingFrUsed(@NotNull Module module) {
        if (module == null) {
            RSpecMockingUtil.$$$reportNull$$$0(5);
        }
        return DEFAULT_MOCKING_FRAMEWORK.equals(RSpecMockingUtil.getEnabledMockingFramework(module));
    }

    private static String getAdapterRelativePath(String mockingFramework, boolean rspec2x) {
        return rspec2x ? RSPEC2_MOCKING_PREFIX + mockingFramework + ".rb" : RSPEC1_MOCKING_PREFIX + mockingFramework + ".rb";
    }

    @NotNull
    private static String getEnabledMockingFramework(@NotNull Module module) {
        if (module == null) {
            RSpecMockingUtil.$$$reportNull$$$0(6);
        }
        Project project = module.getProject();
        String string = (String)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)RSpecMockingUtil.getEnabledMockingFrameworkImpl(module), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)project)}));
        if (string == null) {
            RSpecMockingUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String getEnabledMockingFrameworkImpl(@NotNull Module module) {
        if (module == null) {
            RSpecMockingUtil.$$$reportNull$$$0(8);
        }
        for (String frameworkName : EXTERNAL_MOCKING_FRAMEWORKS) {
            if (!GemUtil.isGemOrRailsPluginSupportEnabled(module, new String[]{frameworkName}, new String[]{frameworkName})) continue;
            String string = frameworkName;
            if (string == null) {
                RSpecMockingUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        return DEFAULT_MOCKING_FRAMEWORK;
    }

    static {
        Collections.addAll(MOCKING_FRAMEWORKS, EXTERNAL_MOCKING_FRAMEWORKS);
        MOCKING_FRAMEWORKS.add(DEFAULT_MOCKING_FRAMEWORK);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rspecLibDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/RSpecMockingUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/RSpecMockingUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledMockingFramework";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledMockingFrameworkImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "determineUsedMockFrameworkAdapter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMockingAdapterDisabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecMockingFrUsed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledMockingFramework";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledMockingFrameworkImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9 -> new IllegalStateException(string);
        };
    }
}

