/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.codeInsight;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.ImplicitRequireProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyEvalCallType;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecCallTypeProvider;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecMockingUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class RSpecImplicitRequiresProvider
implements ImplicitRequireProvider {
    @Override
    @NotNull
    public Collection<VirtualFile> getLoadPath(@Nullable Module module, @NotNull VirtualFile file) {
        if (file == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(0);
        }
        if (module != null && RSpecImplicitRequiresProvider.isRSpecSupportEnabledForFile(module, file) && RSpecUtil.isRSpecRailsSupportEnabled(module)) {
            StandardRailsPaths paths = RailsFacetUtil.getRailsAppStaticPaths(module);
            assert (paths != null);
            String specFolderUrl = RSpecUtil.getRailsSpecFolderPathOrUrl(paths.getRailsApplicationHomeURL());
            VirtualFile specFolder = VirtualFileManager.getInstance().findFileByUrl(specFolderUrl);
            if (specFolder != null) {
                List<VirtualFile> list = Collections.singletonList(specFolder);
                if (list == null) {
                    RSpecImplicitRequiresProvider.$$$reportNull$$$0(1);
                }
                return list;
            }
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getImplicitRequires(@NotNull Module module, PsiFile file) {
        if (module == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(3);
        }
        if (!(file instanceof RFile)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                RSpecImplicitRequiresProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (!RSpecImplicitRequiresProvider.isRSpecSupportEnabledForFile(module, file)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                RSpecImplicitRequiresProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile rspecLibDir = RSpecUtil.getRSpecLibFolder(module);
        if (rspecLibDir == null) {
            ArrayList<VirtualFile> arrayList = result;
            if (arrayList == null) {
                RSpecImplicitRequiresProvider.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        VirtualFile mockAdapter = RSpecMockingUtil.determineUsedMockFrameworkAdapter(module, rspecLibDir);
        if (mockAdapter != null) {
            result.add(mockAdapter);
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    public boolean gemAutoRequireSuppressedFor(@NotNull Project project, @NotNull VirtualFile invocationPoint, @NotNull VirtualFile location) {
        if (project == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(8);
        }
        if (invocationPoint == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(9);
        }
        if (location == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(10);
        }
        return RSpecMockingUtil.isMockingAdapterDisabled(project, invocationPoint, location);
    }

    private static boolean isRSpecSupportEnabledForFile(@NotNull Module module, @NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (module == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(11);
        }
        if (file == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(12);
        }
        return (virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)file)) != null && RSpecImplicitRequiresProvider.isRSpecSupportEnabledForFile(module, virtualFile);
    }

    private static boolean isRSpecSupportEnabledForFile(@NotNull Module module, @NotNull VirtualFile virtualFile) {
        if (module == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(13);
        }
        if (virtualFile == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(14);
        }
        return RSpecUtil.isRSpecSupportEnabled(module) && (RSpecUtil.isFileWithRSpecTestFileName(virtualFile) || RSpecUtil.underSpecDirectory(virtualFile));
    }

    @Nullable
    public static String getAttachedHelperModuleFqn(@NotNull RCall rCall) {
        String helperName;
        RPsiElement helperNameArg;
        List argsList;
        if (rCall == null) {
            RSpecImplicitRequiresProvider.$$$reportNull$$$0(15);
        }
        if (RSpecCallTypeProvider.HELPER_NAME_CALL == rCall.getCallType() && (argsList = rCall.getArguments()).size() == 1 && RubyEvalCallType.isValidElementForArg(helperNameArg = (RPsiElement)argsList.get(0)) && (helperName = RubyPsiUtilCore.getElementText((PsiElement)helperNameArg)) != null) {
            return RSpecImplicitRequiresProvider.fetchModuleNameFromHelperNameCallArgument(helperName);
        }
        return null;
    }

    private static String fetchModuleNameFromHelperNameCallArgument(String helperName) {
        String fileRelativeName = helperName + "_helper";
        return NamingConventions.toCamelCase((String)fileRelativeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/RSpecImplicitRequiresProvider";
                break;
            }
            case 3: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/RSpecImplicitRequiresProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitRequires";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoadPath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitRequires";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "gemAutoRequireSuppressedFor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecSupportEnabledForFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedHelperModuleFqn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

